/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat.variable;

import ch.javasoft.jsmat.common.MatClass;
import ch.javasoft.jsmat.common.MatType;
import ch.javasoft.jsmat.primitive.MatDouble;
import ch.javasoft.jsmat.variable.MatMatrix;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatDoubleMatrix
extends MatMatrix<double[]> {
    private final MatDouble mDoubles;

    public MatDoubleMatrix(double[] values, boolean rowVector) {
        this(values, rowVector ? 1 : values.length, rowVector ? values.length : 1);
    }

    public MatDoubleMatrix(double[] values, int rows, int cols) {
        this(values, new int[]{rows, cols});
    }

    public MatDoubleMatrix(double[][] values) {
        this(MatDoubleMatrix.to1dimArray(values), new int[]{values.length, values.length == 0 ? 0 : values[0].length});
    }

    public MatDoubleMatrix(double[] values, int[] dims) {
        super(MatClass.DOUBLE, MatType.DOUBLE, dims);
        this.mDoubles = new MatDouble(values);
        this.checkValueLength(this.getMatrixSize());
    }

    @Override
    protected int getMatrixSize() {
        return this.mDoubles.getArrayLength();
    }

    public static MatDoubleMatrix createMatrixFromRows(List<double[]> rows) {
        return new MatDoubleMatrix(MatDoubleMatrix.to1dimArray(rows, true), new int[]{rows.size(), rows.size() == 0 ? 0 : rows.get(0).length});
    }

    public static MatDoubleMatrix createMatrixFromColumns(List<double[]> columns) {
        return new MatDoubleMatrix(MatDoubleMatrix.to1dimArray(columns, false), new int[]{columns.size() == 0 ? 0 : columns.get(0).length, columns.size()});
    }

    private static double[] to1dimArray(double[][] values) {
        int rows = values.length;
        int cols = rows == 0 ? 0 : values[0].length;
        double[] arr = new double[rows * cols];
        int col = 0;
        while (col < cols) {
            int row = 0;
            while (row < rows) {
                arr[row + col * rows] = values[row][col];
                ++row;
            }
            ++col;
        }
        return arr;
    }

    private static double[] to1dimArray(List<double[]> data, boolean rowsInList) {
        int cols;
        int rows;
        if (rowsInList) {
            rows = data.size();
            cols = rows == 0 ? 0 : data.get(0).length;
        } else {
            cols = data.size();
            rows = cols == 0 ? 0 : data.get(0).length;
        }
        double[] arr = new double[rows * cols];
        if (rowsInList) {
            int col = 0;
            while (col < cols) {
                int row = 0;
                while (row < rows) {
                    arr[row + col * rows] = data.get(row)[col];
                    ++row;
                }
                ++col;
            }
        } else {
            int col = 0;
            while (col < cols) {
                double[] dcol = data.get(col);
                System.arraycopy(dcol, 0, arr, col * rows, rows);
                ++col;
            }
        }
        return arr;
    }

    @Override
    public int getRawDataSize() {
        return this.mDoubles.getSize();
    }

    @Override
    public void writeRawData(DataOutput out) throws IOException {
        this.mDoubles.write(out);
    }
}

