/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat;

import ch.javasoft.jsmat.MatWriter;
import ch.javasoft.jsmat.ReservedComplexWriter;
import ch.javasoft.jsmat.VariableWriter;
import ch.javasoft.jsmat.variable.MatReserved;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReservedWriter {
    protected final MatWriter<? extends DataOutput> mWriter;
    protected final MatReserved mReserved;
    private VariableWriter mVariableWriter;
    protected DataOutput mDataOutput;

    protected ReservedWriter(ReservedComplexWriter complexWriter, MatReserved reserved) {
        this(complexWriter.mWriter, reserved);
    }

    protected ReservedWriter(MatWriter<? extends DataOutput> writer, MatReserved reserved) {
        this.mWriter = writer;
        this.mReserved = reserved;
    }

    protected void open(String name) throws IOException {
        if (this.mWriter.mReservedWriter == this) {
            this.mVariableWriter = this.mWriter.createVariableWriter();
            this.mDataOutput = this.mVariableWriter.open();
        } else {
            this.mVariableWriter = this.mWriter.mReservedWriter.mVariableWriter;
            if (this.mVariableWriter == null) {
                throw new IOException("outer reserved writer has already been closed");
            }
            this.mDataOutput = this.mWriter.mReservedWriter.mDataOutput;
        }
        this.mReserved.writeDataBlockStart(name, this.mDataOutput);
    }

    public void close() throws IOException {
        this.mReserved.writeDataBlockEnd(this.mDataOutput);
        this.closeVariableWriter();
    }

    protected void closeVariableWriter() throws IOException {
        if (this.mWriter.mReservedWriter == this) {
            this.mVariableWriter.close();
            this.mWriter.mReservedWriter = null;
        }
        this.mVariableWriter = null;
        this.mDataOutput = null;
    }
}

