/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.job;

import ch.javasoft.io.Streams;
import ch.javasoft.job.AbstractJob;
import ch.javasoft.job.JobMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipeJob
extends AbstractJob<Void> {
    private final InputStream mSrc;
    private final OutputStream mDst;
    private final byte[] mBuf;

    public PipeJob(InputStream src, OutputStream dst) {
        this(src, dst, new byte[1024]);
    }

    public PipeJob(InputStream src, OutputStream dst, byte[] buffer) {
        this.mSrc = src;
        this.mDst = dst;
        this.mBuf = buffer;
    }

    @Override
    public Void run() throws IOException {
        Streams.transfer(this.mSrc, this.mDst, this.mBuf);
        return null;
    }

    public static JobMonitor<Void> pipe(InputStream src, OutputStream dst) {
        return PipeJob.pipe(src, dst, new byte[1024]);
    }

    public static JobMonitor<Void> pipe(InputStream src, OutputStream dst, byte[] buffer) {
        return new PipeJob(src, dst, buffer).exec();
    }
}

