/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.job;

import ch.javasoft.job.AbstractJobProcessor;
import ch.javasoft.job.Job;
import ch.javasoft.job.JobMonitor;
import ch.javasoft.job.JobResult;
import ch.javasoft.job.JobResultFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewThreadJobProcessor<R>
extends AbstractJobProcessor<R, R, Job<? extends R>> {
    @Override
    public JobMonitor<R> exec(final Job<? extends R> job) {
        final List res = Collections.synchronizedList(new ArrayList(1));
        final Thread thread = new Thread(){

            public void run() {
                JobResult result;
                try {
                    Object rawResult = job.run();
                    result = JobResultFactory.createJobResult(rawResult);
                }
                catch (Throwable th) {
                    result = JobResultFactory.createJobResultForException(th);
                }
                res.add(result);
                if (result.isException()) {
                    NewThreadJobProcessor.this.invokeTerminationExceptionHandlers(job, result.getException());
                } else {
                    NewThreadJobProcessor.this.invokeTerminationHandlers(job, result.getResult());
                }
            }
        };
        thread.start();
        return new JobMonitor<R>(){

            @Override
            public JobResult<R> getJobResult() {
                return res.isEmpty() ? null : (JobResult)res.get(0);
            }

            @Override
            public boolean isRunning() {
                return res.isEmpty();
            }

            @Override
            public JobResult<R> waitForResult() throws InterruptedException {
                int time = 8;
                int end = 1024;
                while (this.isRunning()) {
                    Thread.sleep(time);
                    if (time >= end) continue;
                    time *= 2;
                }
                return this.getJobResult();
            }

            @Override
            public void interrupt() {
                thread.interrupt();
            }
        };
    }
}

