/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.job;

import ch.javasoft.job.JobMonitor;
import ch.javasoft.job.JobResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JobResultFactory {
    public static <R> JobResult<R> createJobResult(final R result) {
        return new JobResult<R>(){

            @Override
            public Throwable getException() {
                return null;
            }

            @Override
            public R getResult() {
                return result;
            }

            @Override
            public boolean isException() {
                return false;
            }
        };
    }

    public static <R> JobResult<R> createJobResultForException(final Throwable exc) {
        return new JobResult<R>(){

            @Override
            public Throwable getException() {
                return exc;
            }

            @Override
            public R getResult() {
                return null;
            }

            @Override
            public boolean isException() {
                return true;
            }
        };
    }

    public static <R> JobMonitor<R> createJobStatusForException(Throwable exc) {
        final JobResult<R> result = JobResultFactory.createJobResultForException(exc);
        return new JobMonitor<R>(){

            @Override
            public JobResult<R> getJobResult() {
                return result;
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isRunning() {
                return false;
            }

            @Override
            public JobResult<R> waitForResult() throws InterruptedException {
                return result;
            }
        };
    }

    private JobResultFactory() {
    }
}

