/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.job;

import ch.javasoft.job.Job;
import ch.javasoft.job.JobProcessor;
import ch.javasoft.job.JobResult;
import ch.javasoft.job.JobTerminationHandler;
import ch.javasoft.job.UncaughtJobTerminationHandlerException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJobProcessor<JR, R, J extends Job<? extends JR>>
implements JobProcessor<JR, R, J> {
    private final List<JobTerminationHandler<R>> mHandlers = new ArrayList<JobTerminationHandler<R>>();

    @Override
    public void addJobTerminatedHandler(JobTerminationHandler<R> handler) {
        this.mHandlers.add(handler);
    }

    @Override
    public boolean removeJobTerminatedHandler(JobTerminationHandler<R> handler) {
        return this.mHandlers.remove(handler);
    }

    protected void invokeTerminationHandlers(J job, R result) {
        ArrayList<JobTerminationHandler<R>> handlers = new ArrayList<JobTerminationHandler<R>>(this.mHandlers);
        for (JobTerminationHandler jobTerminationHandler : handlers) {
            try {
                jobTerminationHandler.terminated((Job)job, result);
            }
            catch (Throwable unc) {
                throw new UncaughtJobTerminationHandlerException("uncaught exception in job termination handler [job=" + job + ", hdl=" + jobTerminationHandler + "], e=" + unc, unc);
            }
        }
    }

    protected void invokeTerminationExceptionHandlers(J job, Throwable throwable) {
        ArrayList<JobTerminationHandler<R>> handlers = new ArrayList<JobTerminationHandler<R>>(this.mHandlers);
        for (JobTerminationHandler jobTerminationHandler : handlers) {
            try {
                jobTerminationHandler.terminatedByException((Job)job, throwable);
            }
            catch (ClassCastException cce) {
                throw new UncaughtJobTerminationHandlerException("uncaught exception in job termination handler [job=" + job + ", hdl=" + jobTerminationHandler + "], e=" + cce, cce);
            }
            catch (Throwable unc) {
                throw new UncaughtJobTerminationHandlerException("uncaught exception in job termination handler [job=" + job + ", hdl=" + jobTerminationHandler + "], e=" + unc, unc);
            }
        }
    }

    @Override
    public JobResult<R> execAndWait(J job) throws InterruptedException {
        return this.exec(job).waitForResult();
    }

    @Override
    public R execAndWaitThrowException(J job) throws InterruptedException, Throwable {
        JobResult<R> result = this.execAndWait(job);
        if (result.isException()) {
            throw result.getException();
        }
        return result.getResult();
    }
}

