/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase.util;

import ch.javasoft.jbase.Table;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedTableWeakReference<E>
implements Table<E> {
    private final int paletteSize;
    private final boolean cacheOnWrite;
    private final Map<Integer, Palette> cache = new ConcurrentHashMap<Integer, Palette>();
    private final Table<E> baseTable;
    private volatile Palette last = null;

    public CachedTableWeakReference(Table<E> baseTable) {
        this(baseTable, 256, false);
    }

    public CachedTableWeakReference(Table<E> baseTable, int paletteSize, boolean cacheOnWrite) {
        this.baseTable = baseTable;
        this.paletteSize = paletteSize;
        this.cacheOnWrite = cacheOnWrite;
    }

    protected Palette getPalette(int index, boolean forceCreate) {
        Integer key = index / this.paletteSize;
        Palette pal = this.cache.get(key);
        if (pal == null && forceCreate) {
            pal = new Palette();
            this.cache.put(key, pal);
        }
        return pal == null ? pal : (this.last = pal);
    }

    protected void cacheEntity(int index, E entity, boolean force) {
        Palette pal = this.getPalette(index, force);
        if (pal != null) {
            pal.set(index, entity, force);
        }
    }

    @Override
    public int add(E entity) throws IOException {
        int pos = this.baseTable.add(entity);
        if (this.cacheOnWrite) {
            this.cacheEntity(pos, entity, true);
        }
        return pos;
    }

    @Override
    public void removeAll() throws IOException {
        this.baseTable.removeAll();
        this.clearCache();
    }

    @Override
    public void close(boolean erase) throws IOException {
        this.baseTable.close(erase);
        this.clearCache();
    }

    @Override
    public void flush() throws IOException {
        this.baseTable.flush();
    }

    @Override
    public E get(int index) throws IOException {
        Palette pal = this.getPalette(index, true);
        Object entity = pal.get(index);
        if (entity == null) {
            entity = this.baseTable.get(index);
            pal.set(index, entity, true);
        }
        return entity;
    }

    @Override
    public void remove(int index) throws IOException {
        this.baseTable.remove(index);
        this.cacheEntity(index, null, false);
    }

    @Override
    public void set(int index, E entity) throws IOException {
        this.baseTable.set(index, entity);
        this.cacheEntity(index, entity, this.cacheOnWrite);
    }

    @Override
    public void swap(int indexA, int indexB) throws IOException {
        this.baseTable.swap(indexA, indexB);
        this.cacheEntity(indexA, null, false);
        this.cacheEntity(indexB, null, false);
    }

    @Override
    public int size() throws IOException {
        return this.baseTable.size();
    }

    public void clearCache() {
        this.cache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Palette {
        WeakReference<E[]> data;

        Palette() {
            this.data = new WeakReference<Object[]>(new Object[CachedTableWeakReference.this.paletteSize]);
        }

        E get(int index) {
            Object[] arr = (Object[])this.data.get();
            if (arr == null) {
                CachedTableWeakReference.this.cache.remove(index / CachedTableWeakReference.this.paletteSize);
                return null;
            }
            return arr[index % CachedTableWeakReference.this.paletteSize];
        }

        void set(int index, E value, boolean force) {
            Object[] arr = (Object[])this.data.get();
            if (arr == null) {
                if (force) {
                    arr = new Object[CachedTableWeakReference.this.paletteSize];
                    this.data = new WeakReference<Object[]>(arr);
                } else {
                    CachedTableWeakReference.this.cache.remove(index / CachedTableWeakReference.this.paletteSize);
                    return;
                }
            }
            arr[index % ((CachedTableWeakReference)CachedTableWeakReference.this).paletteSize] = value;
        }
    }
}

