/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase;

import ch.javasoft.jbase.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryTable<E>
implements Table<E> {
    private final List<E> list;

    public MemoryTable() {
        this(new ArrayList());
    }

    public MemoryTable(List<E> list) {
        this.list = list;
    }

    @Override
    public int add(E entity) {
        this.list.add(entity);
        return this.list.size() - 1;
    }

    @Override
    public void close(boolean erase) {
        this.list.clear();
    }

    @Override
    public void flush() {
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public void remove(int index) {
        if (index >= this.list.size()) {
            throw new ArrayIndexOutOfBoundsException("no such entry: " + index);
        }
        E last = this.list.remove(this.list.size() - 1);
        if (index != this.list.size()) {
            this.list.set(index, last);
        }
    }

    @Override
    public void set(int index, E entity) {
        this.list.set(index, entity);
    }

    @Override
    public void swap(int indexA, int indexB) {
        Collections.swap(this.list, indexA, indexB);
    }

    @Override
    public void removeAll() throws IOException {
        this.list.clear();
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

