/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase;

import ch.javasoft.jbase.ByteArray;
import ch.javasoft.jbase.FixedWidthMarshaller;
import ch.javasoft.jbase.RandomAccessFilePersistor;
import ch.javasoft.jbase.RandomAccessPersister;
import ch.javasoft.jbase.Table;
import ch.javasoft.jbase.concurrent.Stateful;
import ch.javasoft.jbase.util.UnsupportedOperationException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.ReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedWidthTable<E>
implements Table<E>,
Stateful {
    private final RandomAccessPersister raPersister;
    private final FixedWidthMarshaller<E> marshaller;
    private final FixedWidthMarshaller<E> bufferingMarshaller;
    private volatile int size;
    private volatile boolean needsFlush;

    protected FixedWidthTable(RandomAccessPersister raPersister, final FixedWidthMarshaller<E> marshaller, int size) {
        this.raPersister = raPersister;
        this.marshaller = marshaller;
        this.size = size;
        this.bufferingMarshaller = new FixedWidthMarshaller<E>(){
            final int byteWidth;
            private final ByteArray buffer;
            {
                this.byteWidth = fixedWidthMarshaller.getByteWidth();
                this.buffer = new ByteArray();
            }

            @Override
            public int getByteWidth() {
                return this.byteWidth;
            }

            @Override
            public E readFrom(DataInput in) throws IOException {
                this.buffer.reset();
                this.buffer.readBytesFrom(in, this.byteWidth);
                return marshaller.readFrom(this.buffer.getDataInputStream());
            }

            @Override
            public void writeTo(E entity, DataOutput out) throws IOException {
                this.buffer.reset();
                marshaller.writeTo(entity, this.buffer.getDataOutputStream());
                this.buffer.writeTo(out);
            }
        };
    }

    public static int readByteWidth(RandomAccessPersister raPersister) throws IOException {
        raPersister.setPosition(0L);
        DataInput in = raPersister.getInput();
        return in.readInt();
    }

    public static int readSize(RandomAccessPersister raPersister) throws IOException {
        raPersister.setPosition(0L);
        DataInput in = raPersister.getInput();
        in.readInt();
        return in.readInt();
    }

    public static <En> FixedWidthTable<En> open(File file, FixedWidthMarshaller<En> marshaller) throws IOException {
        return FixedWidthTable.open(new RandomAccessFilePersistor(file, new RandomAccessFile(file, "r")), marshaller);
    }

    public static <En> FixedWidthTable<En> open(File file, FixedWidthMarshaller<En> marshaller, int cacheTableSize, int cacheEntrySize) throws IOException {
        return FixedWidthTable.open(new RandomAccessFilePersistor(file, new RandomAccessFile(file, "r")), marshaller);
    }

    public static <En> FixedWidthTable<En> open(RandomAccessPersister raPersister, FixedWidthMarshaller<En> marshaller) throws IOException {
        FixedWidthTable<En> tbl = new FixedWidthTable<En>(raPersister, marshaller, 0);
        tbl.readHeader();
        tbl.needsFlush = false;
        return tbl;
    }

    public static <En> FixedWidthTable<En> create(File file, FixedWidthMarshaller<En> marshaller) throws IOException {
        return FixedWidthTable.create(new RandomAccessFilePersistor(file), marshaller);
    }

    public static <En> FixedWidthTable<En> create(File file, FixedWidthMarshaller<En> marshaller, int cacheTableSize, int cacheEntrySize) throws IOException {
        return FixedWidthTable.create(new RandomAccessFilePersistor(file), marshaller);
    }

    public static <En> FixedWidthTable<En> create(RandomAccessPersister raPersister, FixedWidthMarshaller<En> marshaller) throws IOException {
        FixedWidthTable<En> tbl = new FixedWidthTable<En>(raPersister, marshaller, 0);
        raPersister.setLength(0L);
        tbl.writeHeader();
        tbl.needsFlush = true;
        return tbl;
    }

    protected void readHeader() throws IOException {
        if (this.size < 0) {
            throw new IOException("table already closed.");
        }
        this.raPersister.setPosition(0L);
        DataInput in = this.raPersister.getInput();
        int byteWidth = in.readInt();
        if (byteWidth != this.marshaller.getByteWidth()) {
            throw new IOException("file byte width not consistent with marshaller byte width: " + byteWidth + " != " + this.marshaller.getByteWidth());
        }
        this.size = in.readInt();
    }

    protected void writeHeader() throws IOException {
        if (this.size < 0) {
            throw new IOException("table already closed.");
        }
        this.raPersister.setPosition(0L);
        DataOutput out = this.raPersister.getOutput();
        out.writeInt(this.marshaller.getByteWidth());
        out.writeInt(this.size);
    }

    public int getByteWidth() {
        return this.marshaller.getByteWidth();
    }

    public FixedWidthMarshaller<E> getEntityMarshaller() {
        return this.marshaller;
    }

    @Override
    public int add(E entity) throws IOException {
        int pos = this.size++;
        this.set(pos, entity);
        this.needsFlush = true;
        return pos;
    }

    @Override
    public E get(int index) throws IOException {
        if (this.size < 0) {
            throw new IOException("table already closed.");
        }
        this.raPersister.setPosition(this.byteOffset(index));
        return this.bufferingMarshaller.readFrom(this.raPersister.getInput());
    }

    @Override
    public void remove(int index) throws IOException {
        if (this.size < 0) {
            throw new IOException("table already closed.");
        }
        if (index != this.size - 1) {
            this.set(index, this.get(this.size - 1));
        }
        --this.size;
    }

    @Override
    public void set(int index, E entity) throws IOException {
        if (this.size < 0) {
            throw new IOException("table already closed.");
        }
        this.raPersister.setPosition(this.byteOffset(index));
        this.bufferingMarshaller.writeTo(entity, this.raPersister.getOutput());
        this.needsFlush = true;
    }

    @Override
    public void swap(int indexA, int indexB) throws IOException {
        if (this.size < 0) {
            throw new IOException("table already closed.");
        }
        if (indexA == indexB) {
            return;
        }
        this.raPersister.setPosition(this.byteOffset(indexA));
        Object entityA = this.bufferingMarshaller.readFrom(this.raPersister.getInput());
        this.raPersister.setPosition(this.byteOffset(indexB));
        Object entityB = this.bufferingMarshaller.readFrom(this.raPersister.getInput());
        this.raPersister.setPosition(this.byteOffset(indexB));
        this.bufferingMarshaller.writeTo(entityA, this.raPersister.getOutput());
        this.raPersister.setPosition(this.byteOffset(indexA));
        this.bufferingMarshaller.writeTo(entityB, this.raPersister.getOutput());
        this.needsFlush = true;
    }

    @Override
    public void removeAll() throws IOException {
        if (this.size < 0) {
            throw new IOException("table already closed.");
        }
        this.size = 0;
        this.needsFlush = true;
    }

    @Override
    public int size() throws IOException {
        if (this.size < 0) {
            throw new IOException("table already closed.");
        }
        return this.size;
    }

    @Override
    public void flush() throws IOException {
        this.flush(null);
    }

    private void flush(ReadWriteLock lock) throws IOException {
        if (this.size < 0) {
            throw new IOException("table already closed.");
        }
        if (this.needsFlush) {
            if (lock != null) {
                lock.writeLock().lock();
            }
            try {
                long pos = this.raPersister.getPosition();
                this.writeHeader();
                this.raPersister.setPosition(pos);
                this.raPersister.setLength(this.byteSizeTotal());
                this.raPersister.flush();
                this.needsFlush = false;
            }
            finally {
                if (lock != null) {
                    lock.writeLock().unlock();
                }
            }
        }
    }

    @Override
    public void close(boolean erase) throws IOException {
        if (this.size >= 0) {
            if (!erase) {
                this.flush();
            }
            this.raPersister.close(erase);
            this.size = -1;
        }
    }

    private FixedWidthMarshaller<E> createReadCopyMarshaller(ReadWriteLock lock) throws IOException {
        return this.marshaller instanceof Stateful ? (FixedWidthMarshaller)((Stateful)((Object)this.marshaller)).createReadCopy(lock) : this.marshaller;
    }

    @Override
    public FixedWidthTable<E> createReadCopy(final ReadWriteLock lock) throws IOException {
        RandomAccessPersister persistor = this.raPersister.createReadCopy(lock);
        FixedWidthMarshaller<E> rmarshaller = this.createReadCopyMarshaller(lock);
        return new FixedWidthTable<E>(persistor, rmarshaller, this.size){

            private void sync() throws IOException {
                if (FixedWidthTable.this.size < 0) {
                    throw new IOException("table already closed.");
                }
                if (FixedWidthTable.this.size != FixedWidthTable.this.size) {
                    if (FixedWidthTable.this.size < 0) {
                        this.close(false);
                        throw new IOException("table already closed.");
                    }
                    FixedWidthTable.this.flush(lock);
                    this.readHeader();
                }
            }

            @Override
            public E get(int index) throws IOException {
                this.sync();
                return super.get(index);
            }

            @Override
            public int size() throws IOException {
                this.sync();
                return FixedWidthTable.this.size;
            }

            @Override
            public int add(E entity) throws IOException {
                throw new UnsupportedOperationException("unmodifyable read copy table");
            }

            @Override
            public void set(int index, E entity) throws IOException {
                throw new UnsupportedOperationException("unmodifyable read copy table");
            }

            @Override
            public void swap(int indexA, int indexB) throws IOException {
                throw new UnsupportedOperationException("unmodifyable read copy table");
            }

            @Override
            public void remove(int index) throws IOException {
                throw new UnsupportedOperationException("unmodifyable read copy table");
            }

            @Override
            public void removeAll() throws IOException {
                throw new UnsupportedOperationException("unmodifyable read copy table");
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close(boolean erase) throws IOException {
                if (erase) {
                    throw new UnsupportedOperationException("unmodifyable read copy table");
                }
                super.close(false);
            }

            @Override
            protected void finalize() throws Throwable {
                this.close(false);
            }
        };
    }

    protected void finalize() throws Throwable {
        this.close(false);
    }

    protected long byteOffset() {
        return 8L;
    }

    protected long byteOffset(int index) {
        return this.byteOffset() + (long)index * (long)this.getByteWidth();
    }

    protected long byteSizeTotal() {
        return this.byteSizeData() + this.byteOffset();
    }

    protected long byteSizeData() {
        return (long)this.size * (long)this.getByteWidth();
    }
}

