/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ByteArray
extends OutputStream {
    private byte[] bytes;
    private int start = 0;
    private int end = 0;
    private ByteArrayInputStream arrayIn;
    private DataInputStream dataIn;
    private DataOutputStream dataOut;

    public ByteArray() {
        this(32);
    }

    public ByteArray(int size) {
        this.bytes = new byte[size];
    }

    public void write(int b) {
        this.ensureCapacity(this.end + 1);
        this.bytes[this.end++] = (byte)b;
    }

    public void write(byte[] b) {
        this.ensureCapacity(b.length + this.end);
        System.arraycopy(b, 0, this.bytes, this.end, b.length);
        this.end += b.length;
    }

    public void write(byte[] b, int off, int len) {
        if (off < 0 || len < 0) {
            throw new IndexOutOfBoundsException("negative index of offset");
        }
        if (off + len > b.length) {
            throw new IndexOutOfBoundsException("off + len > b.length: " + off + ", " + len + ", " + b.length);
        }
        this.ensureCapacity(len + this.end);
        System.arraycopy(b, off, this.bytes, this.end, len);
        this.end += len;
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.bytes.length) {
            int len = Math.max(2 * this.bytes.length, capacity);
            byte[] larger = new byte[len];
            System.arraycopy(this.bytes, 0, larger, 0, this.end);
            this.arrayIn = null;
            this.dataIn = null;
            this.bytes = larger;
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public void reset() {
        this.start = 0;
        this.end = 0;
    }

    public int copyTo(byte[] dest) {
        int len = Math.min(dest.length, this.end - this.start);
        System.arraycopy(this.bytes, this.start, dest, 0, len);
        this.start += len;
        return len;
    }

    public int writeTo(DataOutput out) throws IOException {
        int len = this.end - this.start;
        out.write(this.bytes, this.start, len);
        this.start += len;
        return len;
    }

    public void readBytesFrom(DataInput in, int len) throws IOException {
        this.ensureCapacity(this.end + len);
        in.readFully(this.bytes, this.end, len);
        this.end += len;
    }

    public ByteArrayInputStream getInputStream() {
        if (this.arrayIn == null) {
            this.arrayIn = new ByteArrayInputStream(this.bytes);
        } else {
            this.arrayIn.reset();
            this.arrayIn.skip(this.start);
        }
        ByteArrayInputStream res = this.arrayIn;
        this.reset();
        return res;
    }

    public DataInputStream getDataInputStream() throws IOException {
        if (this.dataIn == null) {
            this.dataIn = new DataInputStream(this.getInputStream());
        } else {
            this.dataIn.reset();
            this.dataIn.skip(this.start);
        }
        return this.dataIn;
    }

    public DataOutputStream getDataOutputStream() throws IOException {
        if (this.dataOut == null) {
            this.dataOut = new DataOutputStream(this);
        }
        return this.dataOut;
    }
}

