/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Files {
    private static final Format FORMAT_STAMPED_FILE = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss-SSS");

    public static void copyFile(File src, File dst) throws IOException {
        FileChannel sourceChannel = new FileInputStream(src).getChannel();
        FileChannel destinationChannel = new FileOutputStream(dst).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    public static void deleteRecursive(File dir) throws IOException {
        if (dir.exists()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    Files.deleteRecursive(file);
                }
                if (!file.delete()) {
                    throw new IOException("could not delete file: " + file.getAbsolutePath());
                }
                ++n2;
            }
        }
    }

    public static File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static File getTempFile(String fileName) {
        return new File(Files.getTempDir(), fileName);
    }

    public static File getTempFileStamped() {
        return Files.getTempFile(Files.getFileNameStamped());
    }

    public static String getFileNameStamped() {
        return FORMAT_STAMPED_FILE.format(new Date());
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static File getUserWorkingDir() {
        return new File(System.getProperty("user.dir"));
    }

    private Files() {
    }
}

