/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.bitset.search;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.bitset.search.SubSetSearch;
import ch.javasoft.bitset.search.SuperSetSearch;
import java.util.ArrayList;
import java.util.List;

public class ListSearch
implements SuperSetSearch,
SubSetSearch {
    private final List<IBitSet> sets = new ArrayList<IBitSet>();

    public boolean add(IBitSet set) {
        return this.sets.add(set);
    }

    public boolean remove(IBitSet set) {
        return this.sets.remove(set);
    }

    public IBitSet findSuperSet(IBitSet of) {
        for (IBitSet s : this.sets) {
            if (!of.isSubSetOf(s)) continue;
            return s;
        }
        return null;
    }

    public IBitSet findSuperSet(IBitSet of, IBitSet after) {
        int index = this.indexOf(after);
        int i = index + 1;
        while (i < this.sets.size()) {
            IBitSet s = this.sets.get(i);
            if (of.isSubSetOf(s)) {
                return s;
            }
            ++i;
        }
        return null;
    }

    public IBitSet findSubSet(IBitSet of) {
        for (IBitSet s : this.sets) {
            if (!s.isSubSetOf(of)) continue;
            return s;
        }
        return null;
    }

    public IBitSet findSubSet(IBitSet of, IBitSet after) {
        int index = this.indexOf(after);
        int i = index + 1;
        while (i < this.sets.size()) {
            IBitSet s = this.sets.get(i);
            if (s.isSubSetOf(of)) {
                return s;
            }
            ++i;
        }
        return null;
    }

    private int indexOf(IBitSet set) {
        int i = 0;
        while (i < this.sets.size()) {
            if (set.equals(this.sets.get(i))) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("after set not found");
    }
}

