/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.bitset;

import ch.javasoft.bitset.BitSetFactory;
import ch.javasoft.bitset.IBitSet;
import java.util.BitSet;

public class DefaultBitSet
implements IBitSet {
    public static final DefaultBitSetFactory FACTORY = new DefaultBitSetFactory();
    private BitSet mBitSet;

    public DefaultBitSet() {
        this(new BitSet());
    }

    public DefaultBitSet(int capacity) {
        this(new BitSet(capacity));
    }

    public DefaultBitSet(BitSet bitSet) {
        this.mBitSet = bitSet;
    }

    public DefaultBitSet(IBitSet bitSet) {
        this(bitSet.toBitSet());
    }

    public void set(int bit) {
        this.mBitSet.set(bit);
    }

    public void set(int bit, boolean value) {
        this.mBitSet.set(bit, value);
    }

    public void clear(int bit) {
        this.mBitSet.clear(bit);
    }

    public void clear() {
        this.mBitSet.clear();
    }

    public void flip(int bit) {
        this.mBitSet.flip(bit);
    }

    public boolean get(int bit) {
        return this.mBitSet.get(bit);
    }

    public boolean isSubSetOf(IBitSet of) {
        return this.isSubSetOf(of instanceof DefaultBitSet ? ((DefaultBitSet)of).mBitSet : of.toBitSet());
    }

    public boolean isSubSetOf(DefaultBitSet of) {
        return this.isSubSetOf(of.mBitSet);
    }

    public boolean isSubSetOf(BitSet of) {
        if (this.length() > of.length()) {
            return false;
        }
        BitSet and = (BitSet)this.mBitSet.clone();
        and.and(of);
        return and.equals(this.mBitSet);
    }

    public boolean isSuperSetOfIntersection(IBitSet interA, IBitSet interB) {
        BitSet bsA = interA instanceof DefaultBitSet ? ((DefaultBitSet)interA).mBitSet : interA.toBitSet();
        BitSet bsB = interB instanceof DefaultBitSet ? ((DefaultBitSet)interB).mBitSet : interB.toBitSet();
        return this.isSuperSetOfIntersection(bsA, bsB);
    }

    public boolean isSuperSetOfIntersection(BitSet interA, BitSet interB) {
        BitSet and = (BitSet)interA.clone();
        and.and(interB);
        and.and(this.mBitSet);
        return and.equals(this.mBitSet);
    }

    public void and(IBitSet with) {
        this.and(with instanceof DefaultBitSet ? (DefaultBitSet)with : new DefaultBitSet(with));
    }

    public void and(DefaultBitSet with) {
        this.mBitSet.and(with.mBitSet);
    }

    public DefaultBitSet getAnd(IBitSet with) {
        DefaultBitSet clone = this.clone();
        clone.mBitSet.and(with instanceof DefaultBitSet ? ((DefaultBitSet)with).mBitSet : with.toBitSet());
        return clone;
    }

    public DefaultBitSet getAnd(DefaultBitSet with) {
        DefaultBitSet clone = this.clone();
        clone.and(with);
        return clone;
    }

    public int getAndCardinality(IBitSet with) {
        return this.getAnd(with).cardinality();
    }

    public int getAndCardinality(DefaultBitSet with) {
        return this.getAnd(with).cardinality();
    }

    public void or(IBitSet with) {
        this.or(with instanceof DefaultBitSet ? (DefaultBitSet)with : new DefaultBitSet(with));
    }

    public void or(DefaultBitSet with) {
        this.mBitSet.or(with.mBitSet);
    }

    public DefaultBitSet getOr(IBitSet with) {
        DefaultBitSet clone = this.clone();
        clone.mBitSet.or(with instanceof DefaultBitSet ? ((DefaultBitSet)with).mBitSet : with.toBitSet());
        return clone;
    }

    public DefaultBitSet getOr(DefaultBitSet with) {
        DefaultBitSet clone = this.clone();
        clone.or(with);
        return clone;
    }

    public void xor(IBitSet with) {
        this.xor(with instanceof DefaultBitSet ? (DefaultBitSet)with : new DefaultBitSet(with));
    }

    public void xor(DefaultBitSet with) {
        this.mBitSet.xor(with.mBitSet);
    }

    public DefaultBitSet getXor(IBitSet with) {
        DefaultBitSet clone = this.clone();
        clone.mBitSet.xor(with instanceof DefaultBitSet ? ((DefaultBitSet)with).mBitSet : with.toBitSet());
        return clone;
    }

    public DefaultBitSet getXor(DefaultBitSet with) {
        DefaultBitSet clone = this.clone();
        clone.xor(with);
        return clone;
    }

    public int getXorCardinality(IBitSet with) {
        return this.getXor(with).cardinality();
    }

    public int getXorCardinality(DefaultBitSet with) {
        return this.getXor(with).cardinality();
    }

    public void andNot(IBitSet with) {
        this.andNot(with instanceof DefaultBitSet ? (DefaultBitSet)with : new DefaultBitSet(with));
    }

    public void andNot(DefaultBitSet with) {
        this.mBitSet.andNot(with.mBitSet);
    }

    public DefaultBitSet getAndNot(IBitSet with) {
        DefaultBitSet clone = this.clone();
        clone.mBitSet.andNot(with instanceof DefaultBitSet ? ((DefaultBitSet)with).mBitSet : with.toBitSet());
        return clone;
    }

    public DefaultBitSet getAndNot(DefaultBitSet with) {
        DefaultBitSet clone = this.clone();
        clone.andNot(with);
        return clone;
    }

    public int length() {
        return this.mBitSet.length();
    }

    public int cardinality() {
        return this.mBitSet.cardinality();
    }

    public int cardinality(int fromBit, int toBit) {
        return this.mBitSet.get(fromBit, toBit).cardinality();
    }

    public int compareTo(IBitSet o) {
        return this.compareTo(o instanceof DefaultBitSet ? (DefaultBitSet)o : new DefaultBitSet(o));
    }

    public int compareTo(DefaultBitSet o) {
        throw new RuntimeException("not implemented");
    }

    public int nextSetBit(int from) {
        return this.mBitSet.nextSetBit(from);
    }

    public int nextClearBit(int from) {
        return this.mBitSet.nextClearBit(from);
    }

    public DefaultBitSet clone() {
        return new DefaultBitSet((BitSet)this.mBitSet.clone());
    }

    public String toString() {
        return this.mBitSet.toString();
    }

    public int hashCode() {
        return this.mBitSet.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultBitSet) {
            return this.mBitSet.equals(((DefaultBitSet)obj).mBitSet);
        }
        return false;
    }

    public BitSet toBitSet() {
        return (BitSet)this.mBitSet.clone();
    }

    public BitSetFactory factory() {
        return FACTORY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DefaultBitSetFactory
    implements BitSetFactory {
        @Override
        public DefaultBitSet create() {
            return new DefaultBitSet();
        }

        @Override
        public DefaultBitSet create(int capacity) {
            return new DefaultBitSet(capacity);
        }

        @Override
        public DefaultBitSet create(IBitSet bits) {
            return new DefaultBitSet(bits);
        }

        @Override
        public DefaultBitSet create(BitSet bits) {
            return new DefaultBitSet(bits);
        }

        @Override
        public DefaultBitSet convert(IBitSet bitSet) {
            return bitSet instanceof DefaultBitSet ? (DefaultBitSet)bitSet : new DefaultBitSet(bitSet);
        }

        public Class<DefaultBitSet> getBitSetClass() {
            return DefaultBitSet.class;
        }
    }
}

