/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.bitset;

import ch.javasoft.bitset.BitSetFactory;
import ch.javasoft.bitset.IBitSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ByteBitSet
implements IBitSet {
    public static final ByteBitSetFactory FACTORY = new ByteBitSetFactory();
    private static final int BITS_PER_UNIT = 8;
    private byte[] mUnits;

    public ByteBitSet() {
        this(8);
    }

    public ByteBitSet(int bitCapacity) {
        this.mUnits = new byte[1 + (bitCapacity - 1) / 8];
    }

    public ByteBitSet(BitSet bitSet) {
        this(bitSet.length());
        int bit = bitSet.nextSetBit(0);
        while (bit >= 0) {
            this.set(bit);
            bit = bitSet.nextSetBit(bit + 1);
        }
    }

    public ByteBitSet(IBitSet bitSet) {
        this(bitSet.length());
        int bit = bitSet.nextSetBit(0);
        while (bit >= 0) {
            this.set(bit);
            bit = bitSet.nextSetBit(bit + 1);
        }
    }

    public ByteBitSet(String bitString) {
        this(bitString.length());
        int ii = 0;
        while (ii < bitString.length()) {
            if (bitString.charAt(ii) == '1') {
                this.set(ii);
            }
            ++ii;
        }
    }

    public ByteBitSet(byte[] units, boolean cloneArray) {
        this.mUnits = cloneArray ? Arrays.copyOf(units, units.length) : units;
    }

    private void ensureCapacity(int unitLen) {
        if (this.mUnits.length < unitLen) {
            byte[] newUnits = new byte[unitLen];
            System.arraycopy(this.mUnits, 0, newUnits, 0, this.mUnits.length);
            this.mUnits = newUnits;
        }
    }

    public void set(int bit, boolean value) {
        if (value) {
            this.set(bit);
        } else {
            this.clear(bit);
        }
    }

    public void set(int bit) {
        int unit = bit / 8;
        int index = bit % 8;
        int mask = 1 << index;
        this.ensureCapacity(unit + 1);
        int n = unit;
        this.mUnits[n] = (byte)(this.mUnits[n] | mask);
    }

    public void clear(int bit) {
        int unit = bit / 8;
        int index = bit % 8;
        int mask = 1 << index;
        int n = unit;
        this.mUnits[n] = (byte)(this.mUnits[n] & ~mask);
    }

    public void clear() {
        int ii = 0;
        while (ii < this.mUnits.length) {
            this.mUnits[ii] = 0;
            ++ii;
        }
    }

    public void flip(int bit) {
        int unit = bit / 8;
        int index = bit % 8;
        int mask = 1 << index;
        this.ensureCapacity(unit + 1);
        int n = unit;
        this.mUnits[n] = (byte)(this.mUnits[n] ^ this.mUnits[unit] & mask);
    }

    public boolean get(int bit) {
        int unit = bit / 8;
        if (unit >= this.mUnits.length) {
            return false;
        }
        int index = bit % 8;
        int mask = 1 << index;
        return (this.mUnits[unit] & mask) != 0;
    }

    public boolean isSubSetOf(IBitSet of) {
        return this.isSubSetOf(of instanceof ByteBitSet ? (ByteBitSet)of : new ByteBitSet(of));
    }

    public boolean isSubSetOf(ByteBitSet of) {
        if (this == of) {
            return true;
        }
        int min = Math.min(this.mUnits.length, of.mUnits.length);
        int ii = 0;
        while (ii < min) {
            int and = this.mUnits[ii] & of.mUnits[ii];
            if (and != this.mUnits[ii]) {
                return false;
            }
            ++ii;
        }
        int i = min;
        while (i < this.mUnits.length) {
            if (this.mUnits[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSuperSetOfIntersection(IBitSet interA, IBitSet interB) {
        ByteBitSet byteA = interA instanceof ByteBitSet ? (ByteBitSet)interA : new ByteBitSet(interA);
        ByteBitSet byteB = interB instanceof ByteBitSet ? (ByteBitSet)interB : new ByteBitSet(interB);
        return this.isSuperSetOfIntersection(byteA, byteB);
    }

    public boolean isSuperSetOfIntersection(ByteBitSet interA, ByteBitSet interB) {
        if (this == interA || this == interB) {
            return true;
        }
        int minInter = Math.min(interA.mUnits.length, interB.mUnits.length);
        int minAll = Math.min(this.mUnits.length, minInter);
        int ii = 0;
        while (ii < minAll) {
            long inter = interA.mUnits[ii] & interB.mUnits[ii];
            if (inter != (inter & (long)this.mUnits[ii])) {
                return false;
            }
            ++ii;
        }
        int i = minAll;
        while (i < minInter) {
            if (0L != (long)(interA.mUnits[i] & interB.mUnits[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void and(IBitSet with) {
        this.and(with instanceof ByteBitSet ? (ByteBitSet)with : new ByteBitSet(with));
    }

    public void and(ByteBitSet with) {
        if (this == with) {
            return;
        }
        int len = Math.min(this.mUnits.length, with.mUnits.length);
        int ii = 0;
        while (ii < len) {
            int n = ii;
            this.mUnits[n] = (byte)(this.mUnits[n] & with.mUnits[ii]);
            ++ii;
        }
        ii = len;
        while (ii < this.mUnits.length) {
            this.mUnits[ii] = 0;
            ++ii;
        }
    }

    public ByteBitSet getAnd(IBitSet with) {
        return ByteBitSet.getAnd(this, with instanceof ByteBitSet ? (ByteBitSet)with : new ByteBitSet(with));
    }

    public ByteBitSet getAnd(ByteBitSet with) {
        return ByteBitSet.getAnd(this, with);
    }

    public int getAndCardinality(IBitSet with) {
        return ByteBitSet.getAndCardinality(this, with instanceof ByteBitSet ? (ByteBitSet)with : new ByteBitSet(with));
    }

    public int getAndCardinality(ByteBitSet with) {
        return ByteBitSet.getAndCardinality(this, with);
    }

    public void or(IBitSet with) {
        this.or(with instanceof ByteBitSet ? (ByteBitSet)with : new ByteBitSet(with));
    }

    public void or(ByteBitSet with) {
        if (this == with) {
            return;
        }
        if (with.mUnits.length > this.mUnits.length) {
            byte[] newUnits = new byte[with.mUnits.length];
            int i = 0;
            while (i < this.mUnits.length) {
                newUnits[i] = (byte)(this.mUnits[i] | with.mUnits[i]);
                ++i;
            }
            i = this.mUnits.length;
            while (i < with.mUnits.length) {
                newUnits[i] = with.mUnits[i];
                ++i;
            }
            this.mUnits = newUnits;
        } else {
            int len = Math.min(this.mUnits.length, with.mUnits.length);
            int i = 0;
            while (i < len) {
                int n = i;
                this.mUnits[n] = (byte)(this.mUnits[n] | with.mUnits[i]);
                ++i;
            }
        }
    }

    public ByteBitSet getOr(IBitSet with) {
        return ByteBitSet.getOr(this, with instanceof ByteBitSet ? (ByteBitSet)with : new ByteBitSet(with));
    }

    public ByteBitSet getOr(ByteBitSet with) {
        return ByteBitSet.getOr(this, with);
    }

    public void xor(IBitSet with) {
        this.xor(with instanceof ByteBitSet ? (ByteBitSet)with : new ByteBitSet(with));
    }

    public void xor(ByteBitSet with) {
        int newlen = Math.max(this.mUnits.length, with.mUnits.length);
        if (this.mUnits.length == with.mUnits.length) {
            while (newlen > 0 && (this.mUnits[newlen - 1] ^ with.mUnits[newlen - 1]) == 0) {
                --newlen;
            }
        }
        if (newlen != this.mUnits.length) {
            byte[] newUnits = new byte[newlen];
            System.arraycopy(this.mUnits, 0, newUnits, 0, Math.min(newlen, this.mUnits.length));
            this.mUnits = newUnits;
        }
        int len = Math.min(with.mUnits.length, newlen);
        int i = 0;
        while (i < len) {
            int n = i;
            this.mUnits[n] = (byte)(this.mUnits[n] ^ with.mUnits[i]);
            ++i;
        }
    }

    public ByteBitSet getXor(IBitSet with) {
        return ByteBitSet.getXor(this, with instanceof ByteBitSet ? (ByteBitSet)with : new ByteBitSet(with));
    }

    public ByteBitSet getXor(ByteBitSet with) {
        return ByteBitSet.getXor(this, with);
    }

    public int getXorCardinality(IBitSet with) {
        return ByteBitSet.getXorCardinality(this, with instanceof ByteBitSet ? (ByteBitSet)with : new ByteBitSet(with));
    }

    public int getXorCardinality(ByteBitSet with) {
        return ByteBitSet.getXorCardinality(this, with);
    }

    public void andNot(IBitSet with) {
        this.andNot(with instanceof ByteBitSet ? (ByteBitSet)with : new ByteBitSet(with));
    }

    public void andNot(ByteBitSet with) {
        int len = Math.min(this.mUnits.length, with.mUnits.length);
        int i = 0;
        while (i < len) {
            int n = i;
            this.mUnits[n] = (byte)(this.mUnits[n] & ~with.mUnits[i]);
            ++i;
        }
    }

    public ByteBitSet getAndNot(IBitSet with) {
        return ByteBitSet.getAndNot(this, with instanceof ByteBitSet ? (ByteBitSet)with : new ByteBitSet(with));
    }

    public ByteBitSet getAndNot(ByteBitSet with) {
        return ByteBitSet.getAndNot(this, with);
    }

    public static ByteBitSet getXor(ByteBitSet setA, ByteBitSet setB) {
        ByteBitSet res;
        if (setA.mUnits.length > setB.mUnits.length) {
            res = setA.clone();
            res.xor(setB);
        } else {
            res = setB.clone();
            res.xor(setA);
        }
        return res;
    }

    public static int getXorCardinality(ByteBitSet setA, ByteBitSet setB) {
        int card = 0;
        int minLen = Math.min(setA.mUnits.length, setB.mUnits.length);
        int i = 0;
        while (i < minLen) {
            card += Integer.bitCount(setA.mUnits[i] ^ setB.mUnits[i]);
            ++i;
        }
        i = minLen;
        while (i < setA.mUnits.length) {
            card += Integer.bitCount(setA.mUnits[i]);
            ++i;
        }
        i = minLen;
        while (i < setB.mUnits.length) {
            card += Integer.bitCount(setB.mUnits[i]);
            ++i;
        }
        return card;
    }

    public static ByteBitSet getOr(ByteBitSet setA, ByteBitSet setB) {
        ByteBitSet smaller;
        ByteBitSet larger;
        if (setA.mUnits.length >= setB.mUnits.length) {
            larger = setA;
            smaller = setB;
        } else {
            larger = setB;
            smaller = setA;
        }
        byte[] units = new byte[larger.mUnits.length];
        int i = 0;
        while (i < smaller.mUnits.length) {
            units[i] = (byte)(smaller.mUnits[i] | larger.mUnits[i]);
            ++i;
        }
        return new ByteBitSet(units, false);
    }

    public static ByteBitSet getAnd(ByteBitSet setA, ByteBitSet setB) {
        ByteBitSet smaller;
        ByteBitSet larger;
        if (setA.mUnits.length >= setB.mUnits.length) {
            larger = setA;
            smaller = setB;
        } else {
            larger = setB;
            smaller = setA;
        }
        byte[] units = new byte[smaller.mUnits.length];
        int i = 0;
        while (i < smaller.mUnits.length) {
            units[i] = (byte)(smaller.mUnits[i] & larger.mUnits[i]);
            ++i;
        }
        return new ByteBitSet(units, false);
    }

    public static int getAndCardinality(ByteBitSet setA, ByteBitSet setB) {
        int card = 0;
        int minLen = Math.min(setA.mUnits.length, setB.mUnits.length);
        int i = 0;
        while (i < minLen) {
            card += Integer.bitCount(setA.mUnits[i] & setB.mUnits[i]);
            ++i;
        }
        return card;
    }

    public static ByteBitSet getAndNot(ByteBitSet setA, ByteBitSet setB) {
        byte[] units = new byte[setA.mUnits.length];
        int i = 0;
        while (i < setB.mUnits.length) {
            units[i] = (byte)(setA.mUnits[i] & ~setA.mUnits[i]);
            ++i;
        }
        i = setB.mUnits.length;
        while (i < setA.mUnits.length) {
            units[i] = setA.mUnits[i];
            ++i;
        }
        return new ByteBitSet(units, false);
    }

    public static ByteBitSet getAnd(ByteBitSet ... bitSets) {
        if (bitSets.length == 0) {
            return new ByteBitSet();
        }
        if (bitSets.length == 1) {
            return bitSets[0].clone();
        }
        if (bitSets.length == 2) {
            return ByteBitSet.getAnd(bitSets[0], bitSets[1]);
        }
        int smallest = 0;
        int i = 1;
        while (i < bitSets.length) {
            if (bitSets[i].length() < bitSets[smallest].length()) {
                smallest = i;
            }
            ++i;
        }
        ByteBitSet result = bitSets[smallest].clone();
        int i2 = 0;
        while (i2 < bitSets.length) {
            if (i2 != smallest) {
                result.and(bitSets[i2]);
            }
            ++i2;
        }
        return result;
    }

    public int compareTo(IBitSet o) {
        return this.compareTo(o instanceof ByteBitSet ? (ByteBitSet)o : new ByteBitSet(o));
    }

    public int compareTo(ByteBitSet o) {
        int min = Math.min(this.mUnits.length, o.mUnits.length);
        int i = 0;
        while (i < min) {
            int cmp = Integer.reverse(0xFF & this.mUnits[i]) - Integer.reverse(0xFF & o.mUnits[i]);
            if (cmp < 0) {
                return -1;
            }
            if (cmp > 0) {
                return 1;
            }
            ++i;
        }
        i = min;
        while (i < this.mUnits.length) {
            if (this.mUnits[i] != 0) {
                return 1;
            }
            ++i;
        }
        i = min;
        while (i < o.mUnits.length) {
            if (this.mUnits[i] != 0) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    protected int unitLength() {
        int index = this.mUnits.length;
        while (--index >= 0 && this.mUnits[index] == 0) {
        }
        return index + 1;
    }

    public int length() {
        int index = this.mUnits.length;
        while (--index >= 0 && this.mUnits[index] == 0) {
        }
        return index < 0 ? 0 : index * 8 + 32 - Integer.numberOfLeadingZeros(this.mUnits[index]);
    }

    public boolean isEmpty() {
        int index = this.mUnits.length;
        while (--index >= 0 && this.mUnits[index] == 0) {
        }
        return index < 0;
    }

    public ByteBitSet clone() {
        return new ByteBitSet((byte[])this.mUnits.clone(), false);
    }

    public int cardinality() {
        int card = 0;
        int ii = 0;
        while (ii < this.mUnits.length) {
            card += Integer.bitCount(this.mUnits[ii]);
            ++ii;
        }
        return card;
    }

    public int cardinality(int fromBit, int toBit) {
        int fromUnit = fromBit / 8;
        int toUnit = (toBit + 8 - 1) / 8;
        int unitStart = Math.max(0, fromUnit);
        int unitLen = Math.min(this.mUnits.length, toUnit);
        int card = 0;
        int ii = unitStart;
        while (ii < unitLen) {
            if (this.mUnits[ii] != 0) {
                int bit;
                byte unit = this.mUnits[ii];
                if (ii == fromUnit) {
                    bit = fromBit % 8;
                    unit = (byte)(unit & 255 >>> bit);
                }
                if (ii == toUnit - 1) {
                    bit = fromBit % 8;
                    unit = (byte)(unit & 255 << 8 - bit);
                }
                card += Integer.bitCount(unit);
            }
            ++ii;
        }
        return card;
    }

    public int hashCode() {
        int code = 0;
        int ii = 0;
        while (ii < this.mUnits.length) {
            code ^= this.mUnits[ii] << ((ii & 3) << 3);
            ++ii;
        }
        return code;
    }

    public int hashCodeObj() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ByteBitSet) {
            ByteBitSet bitSet = (ByteBitSet)obj;
            int len = Math.min(this.mUnits.length, bitSet.mUnits.length);
            int ii = 0;
            while (ii < len) {
                if (this.mUnits[ii] != bitSet.mUnits[ii]) {
                    return false;
                }
                ++ii;
            }
            ii = len;
            while (ii < this.mUnits.length) {
                if (this.mUnits[ii] != 0) {
                    return false;
                }
                ++ii;
            }
            ii = len;
            while (ii < bitSet.mUnits.length) {
                if (bitSet.mUnits[ii] != 0) {
                    return false;
                }
                ++ii;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int unitLen = this.unitLength();
        int ii = 0;
        while (ii < unitLen) {
            int len;
            int n = len = ii == unitLen - 1 ? 1 + (this.length() - 1) % 8 : 8;
            if (this.mUnits[ii] != 0) {
                int bit = 1;
                int jj = 0;
                while (jj < len) {
                    if ((this.mUnits[ii] & bit) != 0) {
                        sb.append('1');
                    } else {
                        sb.append('0');
                    }
                    ++jj;
                    bit <<= 1;
                }
            } else {
                sb.append("00000000", 0, len);
            }
            ++ii;
        }
        sb.append('}');
        return sb.toString();
    }

    public int nextSetBit(int from) {
        int fromBit = from % 8;
        int fromUnit = from / 8;
        int ii = Math.max(0, fromUnit);
        while (ii < this.mUnits.length) {
            if (this.mUnits[ii] != 0) {
                int unit = this.mUnits[ii];
                if (ii == fromUnit) {
                    unit = (int)((long)unit & -1L << fromBit);
                }
                if (unit != 0) {
                    return ii * 8 + Integer.numberOfTrailingZeros(unit);
                }
            }
            ++ii;
        }
        return -1;
    }

    public int nextClearBit(int from) {
        int fromUnit;
        int fromBit = from % 8;
        int ii = fromUnit = from / 8;
        while (ii < this.mUnits.length) {
            if (this.mUnits[ii] != -1) {
                int unit = ~this.mUnits[ii];
                if (ii == fromUnit) {
                    unit = (int)((long)unit & -1L << fromBit);
                }
                if (unit != 0) {
                    return ii * 8 + Integer.numberOfTrailingZeros(unit);
                }
            }
            ++ii;
        }
        return Math.max(from, this.length());
    }

    public BitSet toBitSet() {
        BitSet bitSet = new BitSet(this.length());
        int bit = this.nextSetBit(0);
        while (bit >= 0) {
            bitSet.set(bit);
            bit = this.nextSetBit(bit + 1);
        }
        return bitSet;
    }

    public void writeTo(OutputStream out) throws IOException {
        DataOutput dout = out instanceof DataOutput ? (DataOutput)((Object)out) : new DataOutputStream(out);
        dout.writeByte(this.mUnits.length);
        int i = 0;
        while (i < this.mUnits.length) {
            dout.writeByte(this.mUnits[i]);
            ++i;
        }
    }

    public static ByteBitSet readFrom(InputStream in) throws IOException {
        DataInput din = in instanceof DataInput ? (DataInput)((Object)in) : new DataInputStream(in);
        int len = din.readByte();
        byte[] units = new byte[len];
        int i = 0;
        while (i < len) {
            units[i] = din.readByte();
            ++i;
        }
        return new ByteBitSet(units, false);
    }

    public byte[] compress() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.compress(out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toByteArray();
    }

    public void compress(OutputStream out) throws IOException {
        ZipOutputStream zOut = new ZipOutputStream(out);
        zOut.putNextEntry(new ZipEntry("A"));
        DataOutputStream dOut = new DataOutputStream(zOut);
        dOut.writeByte(this.mUnits.length);
        int ii = 0;
        while (ii < this.mUnits.length) {
            dOut.writeByte(this.mUnits[ii]);
            ++ii;
        }
        dOut.flush();
        zOut.closeEntry();
        zOut.flush();
    }

    public static ByteBitSet uncompress(byte[] bytes) {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
        try {
            return ByteBitSet.uncompress(byteIn);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static ByteBitSet uncompress(InputStream in) throws IOException {
        ZipInputStream zIn = new ZipInputStream(in);
        zIn.getNextEntry();
        DataInputStream dIn = new DataInputStream(zIn);
        int unitLen = dIn.readByte();
        byte[] units = new byte[unitLen];
        int ii = 0;
        while (ii < unitLen) {
            units[ii] = dIn.readByte();
            ++ii;
        }
        return new ByteBitSet(units, false);
    }

    public BitSetFactory factory() {
        return FACTORY;
    }

    public int[] toByteArray() {
        return this.toByteArray(null, 0);
    }

    public int[] toByteArray(int[] arr, int offset) {
        int len = this.unitLength();
        if (arr == null || arr.length < len + offset) {
            arr = new int[len + offset];
        }
        System.arraycopy(this.mUnits, 0, arr, offset, len);
        return arr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ByteBitSetFactory
    implements BitSetFactory {
        @Override
        public ByteBitSet create() {
            return new ByteBitSet();
        }

        @Override
        public ByteBitSet create(int capacity) {
            return new ByteBitSet(capacity);
        }

        @Override
        public ByteBitSet create(IBitSet bits) {
            return new ByteBitSet(bits);
        }

        @Override
        public ByteBitSet convert(IBitSet bitSet) {
            return bitSet instanceof ByteBitSet ? (ByteBitSet)bitSet : new ByteBitSet(bitSet);
        }

        @Override
        public ByteBitSet create(BitSet bits) {
            return new ByteBitSet(bits);
        }

        public Class<ByteBitSet> getBitSetClass() {
            return ByteBitSet.class;
        }
    }
}

