import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig, IHttpRouteIntegration, PayloadFormatVersion, ParameterMapping } from '@aws-cdk/aws-apigatewayv2-alpha';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
/**
 * (experimental) Lambda Proxy integration properties.
 *
 * @experimental
 */
export interface LambdaProxyIntegrationProps {
    /**
     * (experimental) The handler for this integration.
     *
     * @experimental
     */
    readonly handler: IFunction;
    /**
     * (experimental) Version of the payload sent to the lambda handler.
     *
     * @default PayloadFormatVersion.VERSION_2_0
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     * @experimental
     */
    readonly payloadFormatVersion?: PayloadFormatVersion;
    /**
     * (experimental) Specifies how to transform HTTP requests before sending them to the backend.
     *
     * @default undefined requests are sent to the backend unmodified
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html
     * @experimental
     */
    readonly parameterMapping?: ParameterMapping;
}
/**
 * (experimental) The Lambda Proxy integration resource for HTTP API.
 *
 * @experimental
 */
export declare class LambdaProxyIntegration implements IHttpRouteIntegration {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: LambdaProxyIntegrationProps);
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
