import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig, HttpMethod, IHttpRouteIntegration, ParameterMapping } from '@aws-cdk/aws-apigatewayv2-alpha';
/**
 * (experimental) Properties to initialize a new `HttpProxyIntegration`.
 *
 * @experimental
 */
export interface HttpProxyIntegrationProps {
    /**
     * (experimental) The full-qualified HTTP URL for the HTTP integration.
     *
     * @experimental
     */
    readonly url: string;
    /**
     * (experimental) The HTTP method that must be used to invoke the underlying HTTP proxy.
     *
     * @default HttpMethod.ANY
     * @experimental
     */
    readonly method?: HttpMethod;
    /**
     * (experimental) Specifies how to transform HTTP requests before sending them to the backend.
     *
     * @default undefined requests are sent to the backend unmodified
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html
     * @experimental
     */
    readonly parameterMapping?: ParameterMapping;
}
/**
 * (experimental) The HTTP Proxy integration resource for HTTP API.
 *
 * @experimental
 */
export declare class HttpProxyIntegration implements IHttpRouteIntegration {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: HttpProxyIntegrationProps);
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(_: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
