import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig } from '@aws-cdk/aws-apigatewayv2-alpha';
import * as elbv2 from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { HttpPrivateIntegrationOptions } from './base-types';
import { HttpPrivateIntegration } from './private/integration';
/**
 * (experimental) Properties to initialize `HttpAlbIntegration`.
 *
 * @experimental
 */
export interface HttpAlbIntegrationProps extends HttpPrivateIntegrationOptions {
    /**
     * (experimental) The listener to the application load balancer used for the integration.
     *
     * @experimental
     */
    readonly listener: elbv2.IApplicationListener;
}
/**
 * (experimental) The Application Load Balancer integration resource for HTTP API.
 *
 * @experimental
 */
export declare class HttpAlbIntegration extends HttpPrivateIntegration {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: HttpAlbIntegrationProps);
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
