# WebraftChatBot
##A Module to build chatbots easily (by webraft)
##Doesn't need high end servers to use . 
##Works well with discord BOT API.
##Needs Python version >=3.0
##Currently Only Supports CSV DATASET with two columns (input , label) .

###**USAGE:**
####Import library
#######```from chatbot_webraft import chatbot```

#####Create Model
#######```chatbot.create_model("my-model")```

#####Load  CSV DATASET (here 'input' needs to be replaced with the column in dataset that has the fields containing the data to be inputted same to be done with 'label' but with fields containing the data to be outputted. )
#######```chatbot.dataset(CSV_FILE_NAME,'input','label',"my-model"") ```

#####Add more data to chatbot(OPTIONAL)
#######```chatbot.add_data("my-model"",["input1","input2"],["output1","output2"]) ```

#####Specify Input
#######```input = "hi"``` / ```input = input("Enter: ")```
#####Run chatbot
#######```print(chatbot.model_run(input,"my-model"))```

###**Basic BOT Usage:**
 ```
 #Import library
from chatbot_webraft import chatbot

#set model name
model = "my-model" 

#create model
chatbot.create_model(model)

#load CSV dataset , Mention input column (question) and label column (answer)
chatbot.dataset(CSV_FILE_NAME,INPUT_COLUMN,LABEL_COLUMN,model) 


#run in loop
while True:
  prompt = input("You: ")    
  #run model and parse input
  print("Bot: ",chatbot.model_run(prompt,model)) 

 ```

 ###**Bot usage for discord:**
```
#Import libraries
from chatbot_webraft import chatbot
import discord 
client = discord.Client(intents=discord.Intents.all())


model = "my-model" #set model name
chatbot.create_model(model) #create model
chatbot.dataset(CSV_FILE_NAME,INPUT_COLUMN,LABEL_COLUMN,model) #load CSV dataset .. Mention input column (question) and label column (answer)
chatbot.add_data(model,["hey","what about you"],["hello bro","im fine ,you?"]) #add more data to model (Not saved , only in memory). Data that you may want to add later.
@client.event
async def on_message(message):
    if message.author == client.user:
        return

    prompt = message.content
    
    await message.reply(chatbot.model_run(prompt,model)) #run model and parse input
client.run(BOT_TOKEN)
```
###**SAMPLE CSV DATASET:**
#######Download Sample csv dataset from [here]("https://webraft.in/sample.csv") , Dont forget to put the file in your project directory
#######Change `CSV_FILE_NAME` to "sample.csv" , `INPUT_COLUMN` to "input" , `LABEL_COLUMN` to "label" in the code
#######RUN THE PROJECT