"""Unified Logger - Async interface to backend logging systems.

A Python logging library that provides consistent, structured logging 
across different environments and applications with support for multiple
backend systems including Fluentd, Elasticsearch, Kafka, and Jaeger.
"""

from .cli import cli
from .core import UnifiedLogger
from .formatters import LogFormatter, JSONFormatter, PlainFormatter
from .handlers import (
    ConsoleBackend, FileBackend, ElasticsearchBackend,
    FluentdBackend, KafkaBackend, JaegerBackend
)
from .filters import LevelFilter, FieldFilter, RateLimitFilter
from .config import load_config, get_backend_config, get_logger_config

__version__ = "0.1.0"

__all__ = [
    # Core classes
    "UnifiedLogger",
    
    # Formatters
    "LogFormatter",
    "JSONFormatter", 
    "PlainFormatter",
    
    # Backends/Handlers
    "ConsoleBackend",
    "FileBackend", 
    "ElasticsearchBackend",
    "FluentdBackend",
    "KafkaBackend",
    "JaegerBackend",
    
    # Filters
    "LevelFilter",
    "FieldFilter",
    "RateLimitFilter",
    
    # Config
    "load_config",
    "get_backend_config",
    "get_logger_config",
    
    # CLI
    "cli",
]
