# OS/2 table Unicode Range bits with corresponding Names and Ranges
# 2011-01-30

unicodeRanges = {
      0: [("Basic Latin",                               0x00000, 0x0007f)],
      1: [("Latin-1 Supplement",                        0x00080, 0x000ff)],
      2: [("Latin Extended-A",                          0x00100, 0x0017F)],
      3: [("Latin Extended-B",                          0x00180, 0x0024f)],
      4: [("IPA Extensions",                            0x00250, 0x002af)],
      3: [("Latin Extended-B",                          0x00180, 0x0024f)],
      4: [("IPA Extensions",                            0x00250, 0x002af),
          ("Phonetic Extensions",                       0x01d00, 0x01d7f),
          ("Phonetic Extensions Supplement",            0x01D80, 0x01DBF)],
      5: [("Spacing Modifier Letters",                  0x002B0, 0x002FF),
          ("Modifier Tone Letters",                     0x0A700, 0x0A71F)],
      6: [("Combining Diacritical Marks",               0x00300, 0x0036F),
          ("Combining Diacritical Marks Supplement",    0x01DC0, 0x01DFF)],
      7: [("Greek and Coptic",                          0x00370, 0x003FF)],
      8: [("Coptic",                                    0x02C80, 0x02CFF)],
      9: [("Cyrillic",                                  0x00400, 0x004FF),
          ("Cyrillic Supplement",                       0x00500, 0x0052F),
          ("Cyrillic Extended-A",                       0x02DE0, 0x02DFF),
          ("Cyrillic Extended-B",                       0x0A640, 0x0A69F)],
     10: [("Armenian",                                  0x00530, 0x0058F)],
     11: [("Hebrew",                                    0x00590, 0x005FF)],
     12: [("Vai",                                       0x0A500, 0x0A63F)],
     13: [("Arabic",                                    0x00600, 0x006FF),
          ("Arabic Supplement",                         0x00750, 0x0077F)],
     14: [("NKo",                                       0x007C0, 0x007FF)],
     15: [("Devanagari",                                0x00900, 0x0097F)],
     16: [("Bengali",                                   0x00980, 0x009FF)],
     17: [("Gurmukhi",                                  0x00A00, 0x00A7F)],
     18: [("Gujarati",                                  0x00A80, 0x00AFF)],
     19: [("Oriya",                                     0x00B00, 0x00B7F)],
     20: [("Tamil",                                     0x00B80, 0x00BFF)],
     21: [("Telugu",                                    0x00C00, 0x00C7F)],
     22: [("Kannada",                                   0x00C80, 0x00CFF)],
     23: [("Malayalam",                                 0x00D00, 0x00D7F)],
     24: [("Thai",                                      0x00E00, 0x00E7F)],
     25: [("Lao",                                       0x00E80, 0x00EFF)],
     26: [("Georgian",                                  0x010A0, 0x010FF),
          ("Georgian Supplement",                       0x02D00, 0x02D2F)],
     27: [("Balinese",                                  0x01B00, 0x01B7F)],
     28: [("Hangul Jamo",                               0x01100, 0x011FF)],
     29: [("Latin Extended Additional",                 0x01E00, 0x01EFF),
          ("Latin Extended-C",                          0x02C60, 0x02C7F),
          ("Latin Extended-D",                          0x0A720, 0x0A7FF)],
     30: [("Greek Extended",                            0x01F00, 0x01FFF)],
     31: [("General Punctuation",                       0x02000, 0x0206F),
          ("Supplemental Punctuation",                  0x02E00, 0x02E7F)],
     32: [("Superscripts And Subscripts",               0x02070, 0x0209F)],
     33: [("Currency Symbols",                          0x020A0, 0x020CF)],
     34: [("Combining Diacritical Marks For Symbols",   0x020D0, 0x020FF)],
     35: [("Letterlike Symbols",                        0x02100, 0x0214F)],
     36: [("Number Forms",                              0x02150, 0x0218F)],
     37: [("Arrows",                                    0x02190, 0x021FF),
          ("Supplemental Arrows-A",                     0x027F0, 0x027FF),
          ("Supplemental Arrows-B",                     0x02900, 0x0297F),
          ("Miscellaneous Symbols and Arrows",          0x02B00, 0x02BFF)],
     38: [("Mathematical Operators",                    0x02200, 0x022FF),
          ("Supplemental Mathematical Operators",       0x02A00, 0x02AFF),
          ("Miscellaneous Mathematical Symbols-A",      0x027C0, 0x027EF),
          ("Miscellaneous Mathematical Symbols-B",      0x02980, 0x029FF)],
     39: [("Miscellaneous Technical",                   0x02300, 0x023FF)],
     40: [("Control Pictures",                          0x02400, 0x0243F)],
     41: [("Optical Character Recognition",             0x02440, 0x0245F)],
     42: [("Enclosed Alphanumerics",                    0x02460, 0x024FF)],
     43: [("Box Drawing",                               0x02500, 0x0257F)],
     44: [("Block Elements",                            0x02580, 0x0259F)],
     45: [("Geometric Shapes",                          0x025A0, 0x025FF)],
     46: [("Miscellaneous Symbols",                     0x02600, 0x026FF)],
     47: [("Dingbats",                                  0x02700, 0x027BF)],
     48: [("CJK Symbols And Punctuation",               0x03000, 0x0303F)],
     49: [("Hiragana",                                  0x03040, 0x0309F)],
     50: [("Katakana",                                  0x030A0, 0x030FF),
          ("Katakana Phonetic Extensions",              0x031F0, 0x031FF)],
     51: [("Bopomofo",                                  0x03100, 0x0312F),
          ("Bopomofo Extended",                         0x031A0, 0x031BF)],
     52: [("Hangul Compatibility Jamo",                 0x03130, 0x0318F)],
     53: [("Phags-pa",                                  0x0A840, 0x0A87F)],
     54: [("Enclosed CJK Letters And Months",           0x03200, 0x032FF)],
     55: [("CJK Compatibility",                         0x03300, 0x033FF)],
     56: [("Hangul Syllables",                          0x0AC00, 0x0D7AF)],
     57: [("Non-Plane 0 *",                             0x0D800, 0x0DFFF)],
     58: [("Phoenician",                                0x10900, 0x1091F)],
     59: [("CJK Unified Ideographs",                    0x04E00, 0x09FFF),
          ("CJK Radicals Supplement",                   0x02E80, 0x02EFF),
          ("Kangxi Radicals",                           0x02F00, 0x02FDF),
          ("Ideographic Description Characters",        0x02FF0, 0x02FFF),
          ("CJK Unified Ideographs Extension A",        0x03400, 0x04DBF),
          ("CJK Unified Ideographs Extension B",        0x20000, 0x2A6DF),
          ("Kanbun",                                    0x03190, 0x0319F)],
     60: [("Private Use Area (plane 0)",                0x0E000, 0x0F8FF)],
     61: [("CJK Strokes",                               0x031C0, 0x031EF),
          ("CJK Compatibility Ideographs",              0x0F900, 0x0FAFF),
          ("CJK Compatibility Ideographs Supplement",   0x2F800, 0x2FA1F)],
     62: [("Alphabetic Presentation Forms",             0x0FB00, 0x0FB4F)],
     63: [("Arabic Presentation Forms-A",               0x0FB50, 0x0FDFF)],
     64: [("Combining Half Marks",                      0x0FE20, 0x0FE2F)],
     65: [("Vertical Forms",                            0x0FE10, 0x0FE1F),
          ("CJK Compatibility Forms",                   0x0FE30, 0x0FE4F)],
     66: [("Small Form Variants",                       0x0FE50, 0x0FE6F)],
     67: [("Arabic Presentation Forms-B",               0x0FE70, 0x0FEFF)],
     68: [("Halfwidth And Fullwidth Forms",             0x0FF00, 0x0FFEF)],
     69: [("Specials",                                  0x0FFF0, 0x0FFFF)],
     70: [("Tibetan",                                   0x00F00, 0x00FFF)],
     71: [("Syriac",                                    0x00700, 0x0074F)],
     72: [("Thaana",                                    0x00780, 0x007BF)],
     73: [("Sinhala",                                   0x00D80, 0x00DFF)],
     74: [("Myanmar",                                   0x01000, 0x0109F)],
     75: [("Ethiopic",                                  0x01200, 0x0137F),
          ("Ethiopic Supplement",                       0x01380, 0x0139F),
          ("Ethiopic Extended",                         0x02D80, 0x02DDF)],
     76: [("Cherokee",                                  0x013A0, 0x013FF)],
     77: [("Unified Canadian Aboriginal Syllabics",     0x01400, 0x0167F)],
     78: [("Ogham",                                     0x01680, 0x0169F)],
     79: [("Runic",                                     0x016A0, 0x016FF)],
     80: [("Khmer",                                     0x01780, 0x017FF),
          ("Khmer Symbols",                             0x019E0, 0x019FF)],
     81: [("Mongolian",                                 0x01800, 0x018AF)],
     82: [("Braille Patterns",                          0x02800, 0x028FF)],
     83: [("Yi Syllables",                              0x0A000, 0x0A48F),
          ("Yi Radicals",                               0x0A490, 0x0A4CF)],
     84: [("Tagalog",                                   0x01700, 0x0171F),
          ("Hanunoo",                                   0x01720, 0x0173F),
          ("Buhid",                                     0x01740, 0x0175F),
          ("Tagbanwa",                                  0x01760, 0x0177F)],
     85: [("Old Italic",                                0x10300, 0x1032F)],
     86: [("Gothic",                                    0x10330, 0x1034F)],
     87: [("Deseret",                                   0x10400, 0x1044F)],
     88: [("Byzantine Musical Symbols",                 0x1D000, 0x1D0FF),
          ("Musical Symbols",                           0x1D100, 0x1D1FF),
          ("Ancient Greek Musical Notation",            0x1D200, 0x1D24F)],
     89: [("Mathematical Alphanumeric Symbols",         0x1D400, 0x1D7FF)],
     90: [("Private Use (plane 15)",                    0xFF000, 0xFFFFD),
          ("Private Use (plane 16)",                    0x100000,0x10FFFD)],
     91: [("Variation Selectors",                       0x0FE00, 0x0FE0F),
          ("Variation Selectors Supplement",            0xE0100, 0xE01EF)],
     92: [("Tags",                                      0xE0000, 0xE007F)],
     93: [("Limbu",                                     0x01900, 0x0194F)],
     94: [("Tai Le",                                    0x01950, 0x0197F)],
     95: [("New Tai Lue",                               0x01980, 0x019DF)],
     96: [("Buginese",                                  0x01A00, 0x01A1F)],
     97: [("Glagolitic",                                0x02C00, 0x02C5F)],
     98: [("Tifinagh",                                  0x02D30, 0x02D7F)],
     99: [("Yijing Hexagram Symbols",                   0x04DC0, 0x04DFF)],
    100: [("Syloti Nagri",                              0x0A800, 0x0A82F)],
    101: [("Linear B Syllabary",                        0x10000, 0x1007F),
          ("Linear B Ideograms",                        0x10080, 0x100FF),
          ("Aegean Numbers",                            0x10100, 0x1013F)],
    102: [("Ancient Greek Numbers",                     0x10140, 0x1018F)],
    103: [("Ugaritic",                                  0x10380, 0x1039F)],
    104: [("Old Persian",                               0x103A0, 0x103DF)],
    105: [("Shavian",                                   0x10450, 0x1047F)],
    106: [("Osmanya",                                   0x10480, 0x104AF)],
    107: [("Cypriot Syllabary",                         0x10800, 0x1083F)],
    108: [("Kharoshthi",                                0x10A00, 0x10A5F)],
    109: [("Tai Xuan Jing Symbols",                     0x1D300, 0x1D35F)],
    110: [("Cuneiform",                                 0x12000, 0x123FF),
          ("Cuneiform Numbers and Punctuation",         0x12400, 0x1247F)],
    111: [("Counting Rod Numerals",                     0x1D360, 0x1D37F)],
    112: [("Sundanese",                                 0x01B80, 0x01BBF)],
    113: [("Lepcha",                                    0x01C00, 0x01C4F)],
    114: [("Ol Chiki",                                  0x01C50, 0x01C7F)],
    115: [("Saurashtra",                                0x0A880, 0x0A8DF)],
    116: [("Kayah Li",                                  0x0A900, 0x0A92F)],
    117: [("Rejang",                                    0x0A930, 0x0A95F)],
    118: [("Cham",                                      0x0AA00, 0x0AA5F)],
    119: [("Ancient Symbols",                           0x10190, 0x101CF)],
    120: [("Phaistos Disc",                             0x101D0, 0x101FF)],
    121: [("Carian",                                    0x102A0, 0x102DF),
          ("Lycian",                                    0x10280, 0x1029F),
          ("Lydian",                                    0x10920, 0x1093F)],
    122: [("Domino Tiles",                              0x1F030, 0x1F09F),
          ("Mahjong Tiles",                             0x1F000, 0x1F02F)],
    123: [("Reserved",          None, None)],
    124: [("Reserved",          None, None)],
    125: [("Reserved",          None, None)],
    126: [("Reserved",          None, None)],
    127: [("Reserved",          None, None)],
}


def getUnicodesForRangeBit(b):
    """Get a list of unicodes for the bit b. The meanings of the bits are
    specified in the OpenType specification for the OS/2 table ulUnicodeRange[1..4] entries.

    :param b: The bit (0-127).
    :type b: int"""
    records = unicodeRanges[b]
    codes = []
    for i in range(len(records)):
        start, stop = (records[i][1], records[i][2])
        for code in range(start, stop+1):
            codes.append(code)
    return codes


def getNameForRangeBit(b):
    """Get the name for the bit b. The meanings of the bits are
    specified in the OpenType specification for the OS/2 table ulUnicodeRange[1..4] entries.

    :param b: The bit (0-127).
    :type b: int"""
    records = unicodeRanges[b]
    name = ""
    for i in range(len(records)):
        name += records[i][0] + ", "
    return name[:-2]


def __test__():
    myRangeBits = [0, 4]
    for b in myRangeBits:
        print("\nBit %3i:" % b)
        codes = getUnicodesForRangeBit(b)
        print("Codes:",)
        for c in codes:
            print(hex(c),)


if __name__ == "__main__":
    __test__()
