# AUTOGENERATED! DO NOT EDIT! File to edit: 13_gffcompare.ipynb (unless otherwise specified).

__all__ = ['Gffcompare']

# Cell

from ..base import Base, modify_cmd


# Cell

class Gffcompare(Base):
    def __init__(self, software, fd):
        super(Gffcompare, self).__init__(software)
        self._default = fd

    def cmd_version(self):
        '''
        :return:
        '''
        return 'echo {repr} ;echo $({software} --version)'.format(
            repr=self.__repr__(),
            software=self._software
        )

    @modify_cmd
    def cmd_gffcompare(self, gtflist, reference, prefix, gtfs):
        '''
        :param gtflist:
        :param reference:
        :param prefix:
        :param extend_para: -M -N
        :param gtfs:
        :return:
        '''
        cmd = ''
        if None is gtflist or gtflist == '':
            cmd = cmd + ' '.join(gtfs)

        else:
            cmd = cmd + ' -i ' + gtflist

        return r'''
{gffcompare} {gffcompare_default} \
            -o {prefix} \
            -r {reference} \
            {cmd}
        '''.format(
            gffcompare=self._software,
            gffcompare_default=self._default['default'],
            prefix=prefix,
            reference=reference,
            cmd=cmd,
        )

    def __repr__(self):
        return 'gffcompare:' + self._software

    def __str__(self):
        return 'Program for processing GTF/GFF files'