# AUTOGENERATED! DO NOT EDIT! File to edit: 02_fastqc.ipynb (unless otherwise specified).

__all__ = ['Fastqc']

# Cell

from ..base import Base, modify_cmd


# Cell

class Fastqc(Base):
    def __init__(self, software, fd):
        super(Fastqc, self).__init__(software)
        self._default = fd


    def cmd_version(self):
        '''

        :return:
        '''
        return 'echo {repr} ;{software} -v'.format(
            repr=self.__repr__(),
            software=self._software
        )

    @modify_cmd
    def cmd_fastqc_stat(self, outdir, fq1, fq2=''):
        '''

        :param outdir:
        :param fq1:
        :param fq2:
        :return:
        '''
        return r'''
{software} {default} \
        -o {outdir} \
        {fq1} {fq2}
        '''.format(
            default=self._default['default'],
            software=self._software,
            **locals()
        )

    def __repr__(self):
        return 'fastqc:' + self._software

    def __str__(self):
        return 'A quality control tool for high throughput sequence data.'