# AUTOGENERATED! DO NOT EDIT! File to edit: 11_gffread.ipynb (unless otherwise specified).

__all__ = ['Gffread']

# Cell

from ..base import Base,modify_cmd

# Cell

class Gffread(Base):
    def __init__(self, software, fd):
        super(Gffread, self).__init__(software)
        self._default = fd

    def cmd_version(self):
        '''
        :return:
        '''
        return 'echo {repr} ;{software} --version'.format(
            repr=self.__repr__(),
            software=self._software
        )

    @modify_cmd
    def cmd_extract_fasta(self, gtf, reference, output):
        '''

        :param gtf:
        :param reference:
        :param output:
        :return:
        '''
        return r'''
{software} {para} \
        {gtf} \
        -g {reference} \
        -w {output}
            '''.format(
                para=self._default['gtf2fasta'],
                software=self._software,
                **locals()
            )



    def __repr__(self):
        return 'gffread:' + self._software

    def __str__(self):
        return 'GFF/GTF utility providing format conversions, ' \
               'filtering, FASTA sequence extraction and more.'