# AUTOGENERATED! DO NOT EDIT! File to edit: 07_featurecounts.ipynb (unless otherwise specified).

__all__ = ['Featurecounts']

# Cell

from ..base import Base, modify_cmd

# Cell

class Featurecounts(Base):
    def __init__(self, software, fd):
        super(Featurecounts, self).__init__(software)
        self._default = fd


    def cmd_version(self):
        '''
        :return:
        '''
        return 'echo {repr} ;{software} -v'.format(
            repr=self.__repr__(),
            software=self._software
        )

    @modify_cmd
    def cmd_featurecounts(self, bams,gtf,output,tmp):
        '''
        '''
        return r'''
{software} {paras} \
        -a {gtf} \
        -o {output} \
        --tmpDir {tmp} \
        {bam_list}
        '''.format(
            software=self._software,
            paras=self._default['default'],
            bam_list=' '.join(bams) if isinstance(bams,list) else bams,
            **locals()
        )

    def __repr__(self):
        return 'featureCounts:' + self._software

    def __str__(self):
        return 'featureCounts for quantity of RNA-seq'