"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Configuration = exports.ConfigurationProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const acm_generated_1 = require("./acm.generated");
Object.defineProperty(exports, "ConfigurationProperty", { enumerable: true, get: function () { return acm_generated_1.RosConfiguration; } });
/**
 * A ROS resource type:  `ALIYUN::ACM::Configuration`
 */
class Configuration extends ros.Resource {
    /**
     * Create a new `ALIYUN::ACM::Configuration`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosConfiguration = new acm_generated_1.RosConfiguration(this, id, {
            group: props.group === undefined || props.group === null ? 'DEFAULT_GROUP' : props.group,
            desc: props.desc,
            type: props.type === undefined || props.type === null ? 'text' : props.type,
            dataId: props.dataId,
            content: props.content,
            namespaceId: props.namespaceId,
            tags: props.tags,
            appName: props.appName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosConfiguration;
        this.attrDataId = rosConfiguration.attrDataId;
        this.attrGroup = rosConfiguration.attrGroup;
        this.attrNamespaceId = rosConfiguration.attrNamespaceId;
    }
}
exports.Configuration = Configuration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uZmlndXJhdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNvbmZpZ3VyYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLG1EQUFtRDtBQUV0QixzR0FGcEIsZ0NBQWdCLE9BRXlCO0FBbURsRDs7R0FFRztBQUNILE1BQWEsYUFBYyxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBc0IzQzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXlCLEVBQUUsbUNBQTJDLElBQUk7UUFDcEgsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLGdCQUFnQixHQUFHLElBQUksZ0NBQWdCLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUNyRCxLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUssS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLEtBQUssS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLEtBQUs7WUFDeEYsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSSxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsSUFBSTtZQUMzRSxNQUFNLEVBQUUsS0FBSyxDQUFDLE1BQU07WUFDcEIsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7WUFDaEIsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1NBQ3pCLEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsZ0JBQWdCLENBQUM7UUFDakMsSUFBSSxDQUFDLFVBQVUsR0FBRyxnQkFBZ0IsQ0FBQyxVQUFVLENBQUM7UUFDOUMsSUFBSSxDQUFDLFNBQVMsR0FBRyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUM7UUFDNUMsSUFBSSxDQUFDLGVBQWUsR0FBRyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUM7SUFDNUQsQ0FBQztDQUNKO0FBL0NELHNDQStDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc0NvbmZpZ3VyYXRpb24gfSBmcm9tICcuL2FjbS5nZW5lcmF0ZWQnO1xuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXG5leHBvcnQgeyBSb3NDb25maWd1cmF0aW9uIGFzIENvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB9O1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6QUNNOjpDb25maWd1cmF0aW9uYFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENvbmZpZ3VyYXRpb25Qcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjb250ZW50OiBUaGUgY29udGVudHMgb2YgdGhlIGNvbmZpZ3VyYXRpb25cbiAgICAgKi9cbiAgICByZWFkb25seSBjb250ZW50OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkYXRhSWQ6IFRoZSBJRCBvZiB0aGUgY29uZmlndXJhdGlvbi4gQWxsb3dlZCBjaGFyYWN0ZXJzIGFyZSB1cHBlciBhbmQgbG93ZXIgY2FzZSBsZXR0ZXJzLCBudW1iZXJzLCBkZWNpbWFsIHBvaW50cyAoLiksIENvbG9ucyAoOiksIGFzdGVyaXNrcyAoKiksIHVuZGVyc2NvcmVzIChfKSwgYW5kIHVuZGVyc2NvcmVzICgtKS4gV2hlbiB0aGUgSUQgcHJlZml4IGlzIHRoZSBmb2xsb3dpbmcgdmFsdWUsIEFDTSB3aWxsIGF1dG9tYXRpY2FsbHkgdXNlIEtNUyBzZXJ2aWNlIHRvIGVuY3J5cHQgdGhpcyBjb25maWd1cmF0aW9uOlxuICAgICAqIFRoZSBwcmVmaXggaXMgY2lwaGVyLTogdGhlIEtNUyBzZXJ2aWNlIGlzIGNhbGxlZCB0byBlbmNyeXB0IGFuZCBkZWNyeXB0IHRoZSBjb25maWd1cmF0aW9uLiBUaGUgc2l6ZSBvZiB0aGUgZW5jcnlwdGVkIGRhdGEgZG9lcyBub3QgZXhjZWVkIDQgS0IsIGFuZCB0aGUgbWF4aW11bSBkb2VzIG5vdCBleGNlZWQgNiBLQi4gU3BlY2lhbCBzeW1ib2xzIHN1Y2ggYXMgYW5kICgmYW1wOykgd2lsbCBkZWNyeXB0IGVycm9ycyBhbmQgYXJlIG5vdCByZWNvbW1lbmRlZC5cbiAgICAgKiBUaGUgcHJlZml4IGlzIGNpcGhlci1rbXMtYWVzLTEyOC06IHVzaW5nIEtNUydzIGVudmVsb3BlIGVuY3J5cHRpb24gYW5kIGRlY3J5cHRpb24gbWV0aG9kLCB0aGUgY29uZmlndXJhdGlvbiBjb250ZW50IGNhbiBleGNlZWQgIDYgS0IsIHVwIHRvIDEwMCBLQi4gVGhlIHBsYWluIHRleHQgZGF0YSBvZiB0aGUgY29uZmlndXJhdGlvbiBjb250ZW50IHdpbGwgbm90IGJlIHRyYW5zbWl0dGVkIHRvIHRoZSBLTVMgc3lzdGVtLCB3aGljaCBpcyBtb3JlIHNlY3VyZSBhbmQgcmVjb21tZW5kZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGF0YUlkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBuYW1lc3BhY2VJZDogSUQgb2YgbmFtZXNwYWNlXG4gICAgICovXG4gICAgcmVhZG9ubHkgbmFtZXNwYWNlSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGFwcE5hbWU6IENvbmZpZ3VyYXRpb24gYXBwbGljYXRpb24gbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFwcE5hbWU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkZXNjOiBDb25maWd1cmF0aW9uIGRlc2NyaXB0aW9uIGV4cGxhaW5zXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzYz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGdyb3VwOiBHcm91cFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGdyb3VwPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdGFnczogTGFiZWwgY29uZmlndXJhdGlvbnMsIHN1Y2ggYXMgdGhlIHByZXNlbmNlIG9mIGEgcGx1cmFsaXR5IG9mIHRhZ3MsIHNlcGFyYXRlZCBieSBjb21tYXNcbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdHlwZTogUHJvdmlzaW9uaW5nIGNvbnRlbnQgZm9ybWF0LCBvcHRpb25hbCB2YWx1ZXMgYXMgZm9sbG93czpcbiAgICAgKiB0ZXh0LCBqc29uLCB4bWwsIHlhbWwsIHRleHQvaHRtbCwgcHJvcGVydGllc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogQSBST1MgcmVzb3VyY2UgdHlwZTogIGBBTElZVU46OkFDTTo6Q29uZmlndXJhdGlvbmBcbiAqL1xuZXhwb3J0IGNsYXNzIENvbmZpZ3VyYXRpb24gZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxuICAgICAqL1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIERhdGFJZDogVGhlIElEIG9mIHRoZSBjb25maWd1cmF0aW9uXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJEYXRhSWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBHcm91cDogR3JvdXBcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckdyb3VwOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgTmFtZXNwYWNlSWQ6IElEIG9mIG5hbWVzcGFjZVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyTmFtZXNwYWNlSWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpBQ006OkNvbmZpZ3VyYXRpb25gLlxuICAgICAqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENvbmZpZ3VyYXRpb25Qcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgICAgICBjb25zdCByb3NDb25maWd1cmF0aW9uID0gbmV3IFJvc0NvbmZpZ3VyYXRpb24odGhpcywgaWQsICB7XG4gICAgICAgICAgICBncm91cDogcHJvcHMuZ3JvdXAgPT09IHVuZGVmaW5lZCB8fCBwcm9wcy5ncm91cCA9PT0gbnVsbCA/ICdERUZBVUxUX0dST1VQJyA6IHByb3BzLmdyb3VwLFxuICAgICAgICAgICAgZGVzYzogcHJvcHMuZGVzYyxcbiAgICAgICAgICAgIHR5cGU6IHByb3BzLnR5cGUgPT09IHVuZGVmaW5lZCB8fCBwcm9wcy50eXBlID09PSBudWxsID8gJ3RleHQnIDogcHJvcHMudHlwZSxcbiAgICAgICAgICAgIGRhdGFJZDogcHJvcHMuZGF0YUlkLFxuICAgICAgICAgICAgY29udGVudDogcHJvcHMuY29udGVudCxcbiAgICAgICAgICAgIG5hbWVzcGFjZUlkOiBwcm9wcy5uYW1lc3BhY2VJZCxcbiAgICAgICAgICAgIHRhZ3M6IHByb3BzLnRhZ3MsXG4gICAgICAgICAgICBhcHBOYW1lOiBwcm9wcy5hcHBOYW1lLFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc0NvbmZpZ3VyYXRpb247XG4gICAgICAgIHRoaXMuYXR0ckRhdGFJZCA9IHJvc0NvbmZpZ3VyYXRpb24uYXR0ckRhdGFJZDtcbiAgICAgICAgdGhpcy5hdHRyR3JvdXAgPSByb3NDb25maWd1cmF0aW9uLmF0dHJHcm91cDtcbiAgICAgICAgdGhpcy5hdHRyTmFtZXNwYWNlSWQgPSByb3NDb25maWd1cmF0aW9uLmF0dHJOYW1lc3BhY2VJZDtcbiAgICB9XG59XG4iXX0=