# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dploy_kickstart']

package_data = \
{'': ['*']}

install_requires = \
['apispec>=3.3.0,<4.0.0',
 'click>=7.1.2,<8.0.0',
 'flask>=1.1.2,<2.0.0',
 'paste>=3.4.0,<4.0.0',
 'waitress>=1.4.3,<2.0.0']

entry_points = \
{'console_scripts': ['kickstart = dploy_kickstart.cmd:cli']}

setup_kwargs = {
    'name': 'dploy-kickstart',
    'version': '0.1.6',
    'description': 'Expose your functions as HTTP endpoints.',
    'long_description': '## dploy-kickstart\n\n[![maintained](https://img.shields.io/badge/maintained%20by-dploy.ai-brightgreen.svg)](https://dploy.ai/) \n[![PyPI version](https://badge.fury.io/py/dploy-kickstart.svg)](https://badge.fury.io/py/dploy-kickstart)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/dploy-kickstart)\n![workflow](https://github.com/dploy-ai/dploy-kickstart/workflows/tests/badge.svg)\n[![codecov](https://codecov.io/gh/dploy-ai/dploy-kickstart/branch/master/graph/badge.svg?token=KypiVRoPJz)](https://codecov.io/gh/dploy-ai/dploy-kickstart)\n\nExpose your Python functions via an HTTP API. `dploy-kickstart` is designed with a focus of making deployment of machine learning models as easy as possible with as clean of a contract as possible. This means that you will find configurations options that are less relevant outside of this domain.\n\n### Installation\n\n`pip install dploy_kickstart`\n\nWhen installed it provides a `kickstart` executable. Have a look at the help functionality: `kickstart --help`.\n\n\n### Usage\n\n`dploy_kickstart` is a helper utility that can expose your Python functions as HTTP endpoints. Based on comment annotations it wraps your chosen functions to be served as API endpoints. It is meant to be used via the `kickstart` CLI, hence, it would generally not be used programmatically.\n\nLet\'s say you have a `script.py` with `@dploy` comment annotations:\n\n```python\n# @dploy endpoint echo\ndef echo_func(payload):\n    return payload\n```\n\nServe this function with:\n\n```sh\nkickstart serve -e script.py\n```\n\nLet\'s try to call the endpoint via `curl`.\n\n```\n$ curl -d \'{"foo":"bar"}\' -H "Content-Type: application/json" -X POST http://localhost:8080/echo/\n\n{"foo":"bar"}\n```\n\n### Annotations\n\nFollowing annotation options are currently available.\n\n- `# @dploy endpoint {endpoint_path}`  \n  Will expose the annotated function on path {endpoint_path} with trailing slash (and redirect without trailing slash).\n- `# @dploy response_mime_type {mimetype}`  \n  Specify response mime type, will wrap function response accordingly.\n  default: `application/json`  \n  available: `application/json`\n- `# @dploy request_content_type {content_type}`  \n  Specify allowed request content type.  \n  default: `application/json`\n  available: `application/json`\n- `# @dploy request_method {method}`  \n  Specify allowed request method.  \n  default: `post`  \n  available: any method supported by Flask\n- `# @dploy json_to_kwargs`  \n  Will map json payload\'s keys to function kwargs if supplied.\n\n### Endpoint utilities\n\nFollowing paths are generated automatically:\n\n- `GET /healthz`: that always returns a 200\n- `GET /openapi.yaml`: autogenerated OpenAPI Spec (WIP)\n\n### Current dependency tree\n\nAim is to keep this as small as possible to not clutter the user space.\n\n```\n$ poetry show --no-dev --tree\n\napispec 3.3.0 A pluggable API specification generator. Currently supports the OpenAPI Specification (f.k.a. the Swagger specification).\nclick 7.1.2 Composable command line interface toolkit\nflask 1.1.2 A simple framework for building complex web applications.\n├── click >=5.1\n├── itsdangerous >=0.24\n├── jinja2 >=2.10.1\n│   └── markupsafe >=0.23 \n└── werkzeug >=0.15\npaste 3.4.0 Tools for using a Web Server Gateway Interface stack\n└── six >=1.4.0\nwaitress 1.4.3 Waitress WSGI server\n```\n\n### Package naming\n\nIsn\'t using underscores in package names discouraged? The reasoning behind the `dploy_kickstart` naming is that this utility is not meant to be used programmatically. Its meant to be used as a sidecar to user code that should be unaware of its existence, therefore, a longer name has a lower chance of clashing with user code. Yes, this is quite subjective.\n\n### Contributing\n\nQuestions, ideas, suggestions? Feel free to create issue or PR.',
    'author': 'Bart Smeets',
    'author_email': 'bart@dploy.ai',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dploy-ai/dploy-kickstart/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
