# Copyright (C) CVAT.ai Corporation
#
# SPDX-License-Identifier: MIT

from .driver import annotate_task
from .exceptions import BadFunctionError
from .interface import (
    AutoAnnotationFunction,
    DetectionAnnotation,
    DetectionFunction,
    DetectionFunctionContext,
    DetectionFunctionSpec,
    TrackableShape,
    TrackingFunctionContext,
    TrackingFunctionShapeContext,
    TrackingFunctionSpec,
    attribute_spec,
    checkbox_attribute_spec,
    keypoint,
    keypoint_spec,
    label_spec,
    mask,
    number_attribute_spec,
    polygon,
    radio_attribute_spec,
    rectangle,
    select_attribute_spec,
    shape,
    skeleton,
    skeleton_label_spec,
    tag,
    text_attribute_spec,
)

__all__ = [
    "AutoAnnotationFunction",
    "annotate_task",
    "attribute_spec",
    "BadFunctionError",
    "checkbox_attribute_spec",
    "DetectionAnnotation",
    "DetectionFunction",
    "DetectionFunctionContext",
    "DetectionFunctionSpec",
    "TrackableShape",
    "TrackingFunctionContext",
    "TrackingFunctionShapeContext",
    "TrackingFunctionSpec",
    "keypoint_spec",
    "keypoint",
    "label_spec",
    "mask",
    "number_attribute_spec",
    "polygon",
    "radio_attribute_spec",
    "rectangle",
    "select_attribute_spec",
    "shape",
    "skeleton_label_spec",
    "skeleton",
    "tag",
    "text_attribute_spec",
]
