# Copyright (C) 2022 CVAT.ai Corporation
#
# SPDX-License-Identifier: MIT

# CVAT REST API
#
# REST API for Computer Vision Annotation Tool (CVAT)  # noqa: E501
#
# The version of the OpenAPI document: 2.51.0
# Contact: support@cvat.ai
# Generated by: https://openapi-generator.tech


from __future__ import annotations

import typing

import re  # noqa: F401
import sys  # noqa: F401

from cvat_sdk.api_client.model_utils import (  # noqa: F401
    ApiTypeError,
    IModelData,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from cvat_sdk.api_client.exceptions import ApiAttributeError

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    # Enable introspection. Can't work normally due to cyclic imports
    from cvat_sdk.api_client.apis import *
    from cvat_sdk.api_client.models import *


def lazy_import():
    from cvat_sdk.api_client.model.frame_selection_method import FrameSelectionMethod
    from cvat_sdk.api_client.model.validation_mode import ValidationMode
    globals()['FrameSelectionMethod'] = FrameSelectionMethod
    globals()['ValidationMode'] = ValidationMode



class IValidationParamsRequest(IModelData):
    """
    NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    # member type declarations
    mode: ValidationMode # noqa: E501
    """
    """

    frame_selection_method: FrameSelectionMethod # noqa: E501
    """
    """

    random_seed: int # noqa: E501
    """
    [optional]
    The seed value for the random number generator. The same value will produce the same frame sets. Applicable only to random frame selection methods. By default, a random value is used. .
    """

    frames: list[str] # noqa: E501
    """
    [optional]
    [str]
    The list of file names to be included in the validation set. Applicable only to the \"manual\" frame selection method. Can only be used for images. .
    """

    frame_count: int # noqa: E501
    """
    [optional]
    The number of frames to be included in the validation set. Applicable only to the \"random_uniform\" frame selection method .
    """

    frame_share: float # noqa: E501
    """
    [optional]
    The share of frames to be included in the validation set. Applicable only to the \"random_uniform\" frame selection method .
    """

    frames_per_job_count: int # noqa: E501
    """
    [optional]
    The number of frames to be included in the validation set from each annotation job. Applicable only to the \"random_per_job\" frame selection method .
    """

    frames_per_job_share: float # noqa: E501
    """
    [optional]
    The share of frames to be included in the validation set from each annotation job. Applicable only to the \"random_per_job\" frame selection method .
    """


class ValidationParamsRequest(ModelNormal, IValidationParamsRequest):
    """
    NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      mode (ValidationMode):

      frame_selection_method (FrameSelectionMethod):

      random_seed (int): The seed value for the random number generator. The same value will produce the same frame sets. Applicable only to random frame selection methods. By default, a random value is used. . [optional]  # noqa: E501

      frames ([str]): The list of file names to be included in the validation set. Applicable only to the \"manual\" frame selection method. Can only be used for images. . [optional]  # noqa: E501

      frame_count (int): The number of frames to be included in the validation set. Applicable only to the \"random_uniform\" frame selection method . [optional]  # noqa: E501

      frame_share (float): The share of frames to be included in the validation set. Applicable only to the \"random_uniform\" frame selection method . [optional]  # noqa: E501

      frames_per_job_count (int): The number of frames to be included in the validation set from each annotation job. Applicable only to the \"random_per_job\" frame selection method . [optional]  # noqa: E501

      frames_per_job_share (float): The share of frames to be included in the validation set from each annotation job. Applicable only to the \"random_per_job\" frame selection method . [optional]  # noqa: E501


      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.

    """

    allowed_values = {
    }

    validations = {
        ('random_seed',): {
            'inclusive_minimum': 0,
        },
        ('frame_count',): {
            'inclusive_minimum': 1,
        },
        ('frames_per_job_count',): {
            'inclusive_minimum': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'mode': (ValidationMode,),  # noqa: E501
            'frame_selection_method': (FrameSelectionMethod,),  # noqa: E501
            'random_seed': (int,),  # noqa: E501
            'frames': ([str],),  # noqa: E501
            'frame_count': (int,),  # noqa: E501
            'frame_share': (float,),  # noqa: E501
            'frames_per_job_count': (int,),  # noqa: E501
            'frames_per_job_share': (float,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'mode': 'mode',  # noqa: E501
        'frame_selection_method': 'frame_selection_method',  # noqa: E501
        'random_seed': 'random_seed',  # noqa: E501
        'frames': 'frames',  # noqa: E501
        'frame_count': 'frame_count',  # noqa: E501
        'frame_share': 'frame_share',  # noqa: E501
        'frames_per_job_count': 'frames_per_job_count',  # noqa: E501
        'frames_per_job_share': 'frames_per_job_share',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, mode, frame_selection_method, *args, **kwargs):  # noqa: E501
        """ValidationParamsRequest - a model defined in OpenAPI

        Args:
            mode (ValidationMode):
            frame_selection_method (FrameSelectionMethod):

        Keyword Args:
            random_seed (int): The seed value for the random number generator. The same value will produce the same frame sets. Applicable only to random frame selection methods. By default, a random value is used. . [optional]  # noqa: E501

            frames ([str]): The list of file names to be included in the validation set. Applicable only to the \"manual\" frame selection method. Can only be used for images. . [optional]  # noqa: E501

            frame_count (int): The number of frames to be included in the validation set. Applicable only to the \"random_uniform\" frame selection method . [optional]  # noqa: E501

            frame_share (float): The share of frames to be included in the validation set. Applicable only to the \"random_uniform\" frame selection method . [optional]  # noqa: E501

            frames_per_job_count (int): The number of frames to be included in the validation set from each annotation job. Applicable only to the \"random_per_job\" frame selection method . [optional]  # noqa: E501

            frames_per_job_share (float): The share of frames to be included in the validation set from each annotation job. Applicable only to the \"random_per_job\" frame selection method . [optional]  # noqa: E501

            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
"""

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.mode = mode
        self.frame_selection_method = frame_selection_method
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, mode, frame_selection_method, *args, **kwargs):  # noqa: E501
        """ValidationParamsRequest - a model defined in OpenAPI

        Args:
            mode (ValidationMode):
            frame_selection_method (FrameSelectionMethod):

        Keyword Args:
            random_seed (int): The seed value for the random number generator. The same value will produce the same frame sets. Applicable only to random frame selection methods. By default, a random value is used. . [optional]  # noqa: E501

            frames ([str]): The list of file names to be included in the validation set. Applicable only to the \"manual\" frame selection method. Can only be used for images. . [optional]  # noqa: E501

            frame_count (int): The number of frames to be included in the validation set. Applicable only to the \"random_uniform\" frame selection method . [optional]  # noqa: E501

            frame_share (float): The share of frames to be included in the validation set. Applicable only to the \"random_uniform\" frame selection method . [optional]  # noqa: E501

            frames_per_job_count (int): The number of frames to be included in the validation set from each annotation job. Applicable only to the \"random_per_job\" frame selection method . [optional]  # noqa: E501

            frames_per_job_share (float): The share of frames to be included in the validation set from each annotation job. Applicable only to the \"random_per_job\" frame selection method . [optional]  # noqa: E501

            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
"""

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.mode = mode
        self.frame_selection_method = frame_selection_method
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

