# Copyright (C) 2022 CVAT.ai Corporation
#
# SPDX-License-Identifier: MIT

# CVAT REST API
#
# REST API for Computer Vision Annotation Tool (CVAT)  # noqa: E501
#
# The version of the OpenAPI document: 2.51.0
# Contact: support@cvat.ai
# Generated by: https://openapi-generator.tech


from __future__ import annotations

import typing

import re  # noqa: F401
import sys  # noqa: F401

from cvat_sdk.api_client.model_utils import (  # noqa: F401
    ApiTypeError,
    IModelData,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from cvat_sdk.api_client.exceptions import ApiAttributeError

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    # Enable introspection. Can't work normally due to cyclic imports
    from cvat_sdk.api_client.apis import *
    from cvat_sdk.api_client.models import *


def lazy_import():
    from cvat_sdk.api_client.model.quality_report_summary_jobs import QualityReportSummaryJobs
    from cvat_sdk.api_client.model.quality_report_summary_tasks import QualityReportSummaryTasks
    globals()['QualityReportSummaryJobs'] = QualityReportSummaryJobs
    globals()['QualityReportSummaryTasks'] = QualityReportSummaryTasks



class IQualityReportSummary(IModelData):
    """
    NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    # member type declarations
    total_frames: int # noqa: E501
    """
    """

    frame_count: int # noqa: E501
    """
    [optional]
    Deprecated. Use 'validation_frames' instead.
    """

    validation_frames: int # noqa: E501
    """
    """

    frame_share: float # noqa: E501
    """
    [optional]
    Deprecated. Use 'validation_frame_share' instead.
    """

    validation_frame_share: float # noqa: E501
    """
    """

    conflict_count: int # noqa: E501
    """
    """

    warning_count: int # noqa: E501
    """
    """

    error_count: int # noqa: E501
    """
    """

    conflicts_by_type: dict[str, typing.Union[int,]] # noqa: E501
    """
    {str: (int,)}
    """

    valid_count: int # noqa: E501
    """
    """

    ds_count: int # noqa: E501
    """
    """

    gt_count: int # noqa: E501
    """
    """

    total_count: int # noqa: E501
    """
    """

    accuracy: float # noqa: E501
    """
    """

    precision: float # noqa: E501
    """
    """

    recall: float # noqa: E501
    """
    """

    tasks: QualityReportSummaryTasks # noqa: E501
    """
    [optional]
    """

    jobs: QualityReportSummaryJobs # noqa: E501
    """
    [optional]
    """


class QualityReportSummary(ModelNormal, IQualityReportSummary):
    """
    NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      total_frames (int):

      validation_frames (int):

      validation_frame_share (float):

      conflict_count (int):

      warning_count (int):

      error_count (int):

      conflicts_by_type ({str: (int,)}):

      valid_count (int):

      ds_count (int):

      gt_count (int):

      total_count (int):

      accuracy (float):

      precision (float):

      recall (float):

      frame_count (int): Deprecated. Use 'validation_frames' instead. [optional]  # noqa: E501

      frame_share (float): Deprecated. Use 'validation_frame_share' instead. [optional]  # noqa: E501

      tasks (QualityReportSummaryTasks): [optional]  # noqa: E501

      jobs (QualityReportSummaryJobs): [optional]  # noqa: E501


      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.

    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'total_frames': (int,),  # noqa: E501
            'validation_frames': (int,),  # noqa: E501
            'validation_frame_share': (float,),  # noqa: E501
            'conflict_count': (int,),  # noqa: E501
            'warning_count': (int,),  # noqa: E501
            'error_count': (int,),  # noqa: E501
            'conflicts_by_type': ({str: (int,)},),  # noqa: E501
            'valid_count': (int,),  # noqa: E501
            'ds_count': (int,),  # noqa: E501
            'gt_count': (int,),  # noqa: E501
            'total_count': (int,),  # noqa: E501
            'accuracy': (float,),  # noqa: E501
            'precision': (float,),  # noqa: E501
            'recall': (float,),  # noqa: E501
            'frame_count': (int,),  # noqa: E501
            'frame_share': (float,),  # noqa: E501
            'tasks': (QualityReportSummaryTasks,),  # noqa: E501
            'jobs': (QualityReportSummaryJobs,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'total_frames': 'total_frames',  # noqa: E501
        'validation_frames': 'validation_frames',  # noqa: E501
        'validation_frame_share': 'validation_frame_share',  # noqa: E501
        'conflict_count': 'conflict_count',  # noqa: E501
        'warning_count': 'warning_count',  # noqa: E501
        'error_count': 'error_count',  # noqa: E501
        'conflicts_by_type': 'conflicts_by_type',  # noqa: E501
        'valid_count': 'valid_count',  # noqa: E501
        'ds_count': 'ds_count',  # noqa: E501
        'gt_count': 'gt_count',  # noqa: E501
        'total_count': 'total_count',  # noqa: E501
        'accuracy': 'accuracy',  # noqa: E501
        'precision': 'precision',  # noqa: E501
        'recall': 'recall',  # noqa: E501
        'frame_count': 'frame_count',  # noqa: E501
        'frame_share': 'frame_share',  # noqa: E501
        'tasks': 'tasks',  # noqa: E501
        'jobs': 'jobs',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, total_frames, validation_frames, validation_frame_share, conflict_count, warning_count, error_count, conflicts_by_type, valid_count, ds_count, gt_count, total_count, accuracy, precision, recall, *args, **kwargs):  # noqa: E501
        """QualityReportSummary - a model defined in OpenAPI

        Args:
            total_frames (int):
            validation_frames (int):
            validation_frame_share (float):
            conflict_count (int):
            warning_count (int):
            error_count (int):
            conflicts_by_type ({str: (int,)}):
            valid_count (int):
            ds_count (int):
            gt_count (int):
            total_count (int):
            accuracy (float):
            precision (float):
            recall (float):

        Keyword Args:
            frame_count (int): Deprecated. Use 'validation_frames' instead. [optional]  # noqa: E501

            frame_share (float): Deprecated. Use 'validation_frame_share' instead. [optional]  # noqa: E501

            tasks (QualityReportSummaryTasks): [optional]  # noqa: E501

            jobs (QualityReportSummaryJobs): [optional]  # noqa: E501

            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
"""

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.total_frames = total_frames
        self.validation_frames = validation_frames
        self.validation_frame_share = validation_frame_share
        self.conflict_count = conflict_count
        self.warning_count = warning_count
        self.error_count = error_count
        self.conflicts_by_type = conflicts_by_type
        self.valid_count = valid_count
        self.ds_count = ds_count
        self.gt_count = gt_count
        self.total_count = total_count
        self.accuracy = accuracy
        self.precision = precision
        self.recall = recall
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, total_frames, validation_frames, validation_frame_share, conflict_count, warning_count, error_count, conflicts_by_type, valid_count, ds_count, gt_count, total_count, accuracy, precision, recall, *args, **kwargs):  # noqa: E501
        """QualityReportSummary - a model defined in OpenAPI

        Args:
            total_frames (int):
            validation_frames (int):
            validation_frame_share (float):
            conflict_count (int):
            warning_count (int):
            error_count (int):
            conflicts_by_type ({str: (int,)}):
            valid_count (int):
            ds_count (int):
            gt_count (int):
            total_count (int):
            accuracy (float):
            precision (float):
            recall (float):

        Keyword Args:
            frame_count (int): Deprecated. Use 'validation_frames' instead. [optional]  # noqa: E501

            frame_share (float): Deprecated. Use 'validation_frame_share' instead. [optional]  # noqa: E501

            tasks (QualityReportSummaryTasks): [optional]  # noqa: E501

            jobs (QualityReportSummaryJobs): [optional]  # noqa: E501

            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
"""

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.total_frames = total_frames
        self.validation_frames = validation_frames
        self.validation_frame_share = validation_frame_share
        self.conflict_count = conflict_count
        self.warning_count = warning_count
        self.error_count = error_count
        self.conflicts_by_type = conflicts_by_type
        self.valid_count = valid_count
        self.ds_count = ds_count
        self.gt_count = gt_count
        self.total_count = total_count
        self.accuracy = accuracy
        self.precision = precision
        self.recall = recall
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

