# Copyright (C) 2022 CVAT.ai Corporation
#
# SPDX-License-Identifier: MIT

# CVAT REST API
#
# REST API for Computer Vision Annotation Tool (CVAT)  # noqa: E501
#
# The version of the OpenAPI document: 2.51.0
# Contact: support@cvat.ai
# Generated by: https://openapi-generator.tech


from __future__ import annotations

import typing
import urllib3

import re  # noqa: F401

from cvat_sdk.api_client.api_client import ApiClient, Endpoint as _Endpoint
from cvat_sdk.api_client.model_utils import (  # noqa: F401
    date,
    datetime,
    file_type,
    none_type,
)
from cvat_sdk.api_client.model.paginated_annotation_conflict_list import PaginatedAnnotationConflictList
from cvat_sdk.api_client.model.paginated_quality_report_list import PaginatedQualityReportList
from cvat_sdk.api_client.model.paginated_quality_settings_list import PaginatedQualitySettingsList
from cvat_sdk.api_client.model.patched_quality_settings_request import PatchedQualitySettingsRequest
from cvat_sdk.api_client.model.quality_report import QualityReport
from cvat_sdk.api_client.model.quality_report_create_request import QualityReportCreateRequest
from cvat_sdk.api_client.model.quality_settings import QualitySettings
from cvat_sdk.api_client.model.rq_id import RqId

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    # Enable introspection. Can't work normally due to cyclic imports
    from cvat_sdk.api_client.apis import *
    from cvat_sdk.api_client.models import *


class QualityApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_report_endpoint = _Endpoint(
            settings={
                'response_schema': (QualityReport,),
                'auth': [
                    'accessTokenAuth',
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/quality/reports',
                'operation_id': 'create_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'rq_id',
                    'quality_report_create_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'rq_id':
                        (str,),
                    'quality_report_create_request':
                        (QualityReportCreateRequest,),
                },
                'attribute_map': {
                    'rq_id': 'rq_id',
                },
                'location_map': {
                    'rq_id': 'query',
                    'quality_report_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.list_conflicts_endpoint = _Endpoint(
            settings={
                'response_schema': (PaginatedAnnotationConflictList,),
                'auth': [
                    'accessTokenAuth',
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/quality/conflicts',
                'operation_id': 'list_conflicts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_organization',
                    'filter',
                    'frame',
                    'job_id',
                    'org',
                    'org_id',
                    'page',
                    'page_size',
                    'project_id',
                    'report_id',
                    'severity',
                    'sort',
                    'task_id',
                    'type',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'severity',
                    'type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('severity',): {

                        "WARNING": "warning",
                        "ERROR": "error"
                    },
                    ('type',): {

                        "MISSING_ANNOTATION": "missing_annotation",
                        "EXTRA_ANNOTATION": "extra_annotation",
                        "MISMATCHING_LABEL": "mismatching_label",
                        "LOW_OVERLAP": "low_overlap",
                        "MISMATCHING_DIRECTION": "mismatching_direction",
                        "MISMATCHING_ATTRIBUTES": "mismatching_attributes",
                        "MISMATCHING_GROUPS": "mismatching_groups",
                        "COVERED_ANNOTATION": "covered_annotation"
                    },
                },
                'openapi_types': {
                    'x_organization':
                        (str,),
                    'filter':
                        (str,),
                    'frame':
                        (int,),
                    'job_id':
                        (int,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'project_id':
                        (int,),
                    'report_id':
                        (int,),
                    'severity':
                        (str,),
                    'sort':
                        (str,),
                    'task_id':
                        (int,),
                    'type':
                        (str,),
                },
                'attribute_map': {
                    'x_organization': 'X-Organization',
                    'filter': 'filter',
                    'frame': 'frame',
                    'job_id': 'job_id',
                    'org': 'org',
                    'org_id': 'org_id',
                    'page': 'page',
                    'page_size': 'page_size',
                    'project_id': 'project_id',
                    'report_id': 'report_id',
                    'severity': 'severity',
                    'sort': 'sort',
                    'task_id': 'task_id',
                    'type': 'type',
                },
                'location_map': {
                    'x_organization': 'header',
                    'filter': 'query',
                    'frame': 'query',
                    'job_id': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'project_id': 'query',
                    'report_id': 'query',
                    'severity': 'query',
                    'sort': 'query',
                    'task_id': 'query',
                    'type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_reports_endpoint = _Endpoint(
            settings={
                'response_schema': (PaginatedQualityReportList,),
                'auth': [
                    'accessTokenAuth',
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/quality/reports',
                'operation_id': 'list_reports',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_organization',
                    'filter',
                    'job_id',
                    'org',
                    'org_id',
                    'page',
                    'page_size',
                    'parent_id',
                    'project_id',
                    'sort',
                    'target',
                    'task_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'target',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('target',): {

                        "JOB": "job",
                        "PROJECT": "project",
                        "TASK": "task"
                    },
                },
                'openapi_types': {
                    'x_organization':
                        (str,),
                    'filter':
                        (str,),
                    'job_id':
                        (int,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'parent_id':
                        (int,),
                    'project_id':
                        (int,),
                    'sort':
                        (str,),
                    'target':
                        (str,),
                    'task_id':
                        (int,),
                },
                'attribute_map': {
                    'x_organization': 'X-Organization',
                    'filter': 'filter',
                    'job_id': 'job_id',
                    'org': 'org',
                    'org_id': 'org_id',
                    'page': 'page',
                    'page_size': 'page_size',
                    'parent_id': 'parent_id',
                    'project_id': 'project_id',
                    'sort': 'sort',
                    'target': 'target',
                    'task_id': 'task_id',
                },
                'location_map': {
                    'x_organization': 'header',
                    'filter': 'query',
                    'job_id': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'parent_id': 'query',
                    'project_id': 'query',
                    'sort': 'query',
                    'target': 'query',
                    'task_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_settings_endpoint = _Endpoint(
            settings={
                'response_schema': (PaginatedQualitySettingsList,),
                'auth': [
                    'accessTokenAuth',
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/quality/settings',
                'operation_id': 'list_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_organization',
                    'filter',
                    'inherit',
                    'org',
                    'org_id',
                    'page',
                    'page_size',
                    'parent_type',
                    'project_id',
                    'sort',
                    'task_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'parent_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('parent_type',): {

                        "PROJECT": "project",
                        "TASK": "task"
                    },
                },
                'openapi_types': {
                    'x_organization':
                        (str,),
                    'filter':
                        (str,),
                    'inherit':
                        (bool,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'parent_type':
                        (str,),
                    'project_id':
                        (int,),
                    'sort':
                        (str,),
                    'task_id':
                        (int,),
                },
                'attribute_map': {
                    'x_organization': 'X-Organization',
                    'filter': 'filter',
                    'inherit': 'inherit',
                    'org': 'org',
                    'org_id': 'org_id',
                    'page': 'page',
                    'page_size': 'page_size',
                    'parent_type': 'parent_type',
                    'project_id': 'project_id',
                    'sort': 'sort',
                    'task_id': 'task_id',
                },
                'location_map': {
                    'x_organization': 'header',
                    'filter': 'query',
                    'inherit': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'parent_type': 'query',
                    'project_id': 'query',
                    'sort': 'query',
                    'task_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.partial_update_settings_endpoint = _Endpoint(
            settings={
                'response_schema': (QualitySettings,),
                'auth': [
                    'accessTokenAuth',
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/quality/settings/{id}',
                'operation_id': 'partial_update_settings',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'patched_quality_settings_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'patched_quality_settings_request':
                        (PatchedQualitySettingsRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'patched_quality_settings_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.retrieve_report_endpoint = _Endpoint(
            settings={
                'response_schema': (QualityReport,),
                'auth': [
                    'accessTokenAuth',
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/quality/reports/{id}',
                'operation_id': 'retrieve_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_report_data_endpoint = _Endpoint(
            settings={
                'response_schema': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'accessTokenAuth',
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/quality/reports/{id}/data',
                'operation_id': 'retrieve_report_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_settings_endpoint = _Endpoint(
            settings={
                'response_schema': (QualitySettings,),
                'auth': [
                    'accessTokenAuth',
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/quality/settings/{id}',
                'operation_id': 'retrieve_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_report(
        self,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[QualityReport], urllib3.HTTPResponse]:
        """Create a quality report  # noqa: E501

        Deprecation warning: Utilizing this endpoint to check the computation status is no longer possible. Consider using common requests API: GET /api/requests/<rq_id>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create_report(_async_call=True)
        >>> result = thread.get()


        Keyword Args:
            rq_id (str): The report creation request id. Can be specified to check the report creation status. . [optional]
            quality_report_create_request (QualityReportCreateRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (QualityReport, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        return self.create_report_endpoint.call_with_http_info(**kwargs)

    def list_conflicts(
        self,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[PaginatedAnnotationConflictList], urllib3.HTTPResponse]:
        """List annotation conflicts in a quality report  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.list_conflicts(_async_call=True)
        >>> result = thread.get()


        Keyword Args:
            x_organization (str): Organization unique slug. [optional]
            filter (str):  JSON Logic filter. This filter can be used to perform complex filtering by grouping rules.  For example, using such a filter you can get all resources created by you:      - {\"and\":[{\"==\":[{\"var\":\"owner\"},\"<user>\"]}]}  Details about the syntax used can be found at the link: https://jsonlogic.com/   Available filter_fields: ['id', 'frame', 'type', 'job_id', 'task_id', 'project_id', 'severity'].. [optional]
            frame (int): A simple equality filter for the frame field. [optional]
            job_id (int): A simple equality filter for the job_id field. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            page (int): A page number within the paginated result set.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            project_id (int): A simple equality filter for the project_id field. [optional]
            report_id (int): A simple equality filter for report id. [optional]
            severity (str): A simple equality filter for the severity field. [optional]
            sort (str): Which field to use when ordering the results. Available ordering_fields: ['id', 'frame', 'type', 'job_id', 'task_id', 'project_id', 'severity']. [optional]
            task_id (int): A simple equality filter for the task_id field. [optional]
            type (str): A simple equality filter for the type field. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (PaginatedAnnotationConflictList, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        return self.list_conflicts_endpoint.call_with_http_info(**kwargs)

    def list_reports(
        self,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[PaginatedQualityReportList], urllib3.HTTPResponse]:
        """Method returns a paginated list of quality reports.  # noqa: E501

        Please note that children reports are included by default if the \"task_id\", \"project_id\" filters are used. If you want to restrict the list of results to a specific report type, use the \"target\" parameter.  The \"parent_id\" filter includes all the nested reports recursively. For instance, if the \"parent_id\" is a project report, all the related task and job reports will be returned.  Please note that a report can be reused in several parent reports, but the \"parent_id\" field in responses will include only the first parent report id. The \"parent_id\" filter still returns all the relevant nested reports, even though the response \"parent_id\" values may be different from the requested one.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.list_reports(_async_call=True)
        >>> result = thread.get()


        Keyword Args:
            x_organization (str): Organization unique slug. [optional]
            filter (str):  JSON Logic filter. This filter can be used to perform complex filtering by grouping rules.  For example, using such a filter you can get all resources created by you:      - {\"and\":[{\"==\":[{\"var\":\"owner\"},\"<user>\"]}]}  Details about the syntax used can be found at the link: https://jsonlogic.com/   Available filter_fields: ['id', 'job_id', 'task_id', 'project_id', 'created_date', 'gt_last_updated', 'target_last_updated'].. [optional]
            job_id (int): A simple equality filter for the job_id field. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            page (int): A page number within the paginated result set.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            parent_id (int): A simple equality filter for parent id. [optional]
            project_id (int): A simple equality filter for project id. [optional]
            sort (str): Which field to use when ordering the results. Available ordering_fields: ['id', 'job_id', 'task_id', 'project_id', 'created_date', 'gt_last_updated', 'target_last_updated']. [optional]
            target (str): A simple equality filter for target. [optional]
            task_id (int): A simple equality filter for task id. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (PaginatedQualityReportList, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        return self.list_reports_endpoint.call_with_http_info(**kwargs)

    def list_settings(
        self,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[PaginatedQualitySettingsList], urllib3.HTTPResponse]:
        """List quality settings instances  # noqa: E501

        Please note that child task settings are included by default if the \"project_id\" filter is used. If you want to restrict results only to a specific parent type, use the \"parent_type\" parameter.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.list_settings(_async_call=True)
        >>> result = thread.get()


        Keyword Args:
            x_organization (str): Organization unique slug. [optional]
            filter (str):  JSON Logic filter. This filter can be used to perform complex filtering by grouping rules.  For example, using such a filter you can get all resources created by you:      - {\"and\":[{\"==\":[{\"var\":\"owner\"},\"<user>\"]}]}  Details about the syntax used can be found at the link: https://jsonlogic.com/   Available filter_fields: ['id', 'task_id', 'project_id', 'inherit', 'created_date', 'updated_date'].. [optional]
            inherit (bool): A simple equality filter for the inherit field. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            page (int): A page number within the paginated result set.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            parent_type (str): A simple equality filter for parent instance type. [optional]
            project_id (int): A simple equality filter for project id. [optional]
            sort (str): Which field to use when ordering the results. Available ordering_fields: ['id', 'task_id', 'project_id', 'inherit', 'created_date', 'updated_date']. [optional]
            task_id (int): A simple equality filter for the task_id field. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (PaginatedQualitySettingsList, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        return self.list_settings_endpoint.call_with_http_info(**kwargs)

    def partial_update_settings(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[QualitySettings], urllib3.HTTPResponse]:
        """Update a quality settings instance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.partial_update_settings(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): An id of a quality settings instance

        Keyword Args:
            patched_quality_settings_request (PatchedQualitySettingsRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (QualitySettings, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.partial_update_settings_endpoint.call_with_http_info(**kwargs)

    def retrieve_report(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[QualityReport], urllib3.HTTPResponse]:
        """Get quality report details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_report(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this quality report.

        Keyword Args:
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (QualityReport, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_report_endpoint.call_with_http_info(**kwargs)

    def retrieve_report_data(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[dict[str, typing.Union[typing.Any, none_type]]], urllib3.HTTPResponse]:
        """Get quality report contents  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_report_data(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this quality report.

        Keyword Args:
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_report_data_endpoint.call_with_http_info(**kwargs)

    def retrieve_settings(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[QualitySettings], urllib3.HTTPResponse]:
        """Get quality settings instance details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_settings(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): An id of a quality settings instance

        Keyword Args:
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (QualitySettings, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_settings_endpoint.call_with_http_info(**kwargs)

