# Copyright (C) 2022 CVAT.ai Corporation
#
# SPDX-License-Identifier: MIT

# CVAT REST API
#
# REST API for Computer Vision Annotation Tool (CVAT)  # noqa: E501
#
# The version of the OpenAPI document: 2.51.0
# Contact: support@cvat.ai
# Generated by: https://openapi-generator.tech


from __future__ import annotations

import typing
import urllib3

import re  # noqa: F401

from cvat_sdk.api_client.api_client import ApiClient, Endpoint as _Endpoint
from cvat_sdk.api_client.model_utils import (  # noqa: F401
    date,
    datetime,
    file_type,
    none_type,
)
from cvat_sdk.api_client.model.client_events import ClientEvents
from cvat_sdk.api_client.model.client_events_request import ClientEventsRequest
from cvat_sdk.api_client.model.rq_id import RqId

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    # Enable introspection. Can't work normally due to cyclic imports
    from cvat_sdk.api_client.apis import *
    from cvat_sdk.api_client.models import *


class EventsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_endpoint = _Endpoint(
            settings={
                'response_schema': (ClientEvents,),
                'auth': [
                    'accessTokenAuth',
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/events',
                'operation_id': 'create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'client_events_request',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'client_events_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'client_events_request':
                        (ClientEventsRequest,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'client_events_request': 'body',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_export_endpoint = _Endpoint(
            settings={
                'response_schema': (RqId,),
                'auth': [
                    'accessTokenAuth',
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/events/export',
                'operation_id': 'create_export',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'cloud_storage_id',
                    'filename',
                    '_from',
                    'job_id',
                    'location',
                    'org_id',
                    'project_id',
                    'task_id',
                    'to',
                    'user_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'location',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('location',): {

                        "CLOUD_STORAGE": "cloud_storage",
                        "LOCAL": "local"
                    },
                },
                'openapi_types': {
                    'cloud_storage_id':
                        (int,),
                    'filename':
                        (str,),
                    '_from':
                        (datetime,),
                    'job_id':
                        (int,),
                    'location':
                        (str,),
                    'org_id':
                        (int,),
                    'project_id':
                        (int,),
                    'task_id':
                        (int,),
                    'to':
                        (datetime,),
                    'user_id':
                        (int,),
                },
                'attribute_map': {
                    'cloud_storage_id': 'cloud_storage_id',
                    'filename': 'filename',
                    '_from': 'from',
                    'job_id': 'job_id',
                    'location': 'location',
                    'org_id': 'org_id',
                    'project_id': 'project_id',
                    'task_id': 'task_id',
                    'to': 'to',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'cloud_storage_id': 'query',
                    'filename': 'query',
                    '_from': 'query',
                    'job_id': 'query',
                    'location': 'query',
                    'org_id': 'query',
                    'project_id': 'query',
                    'task_id': 'query',
                    'to': 'query',
                    'user_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'accessTokenAuth',
                    'basicAuth',
                    'csrfAuth',
                    'csrfHeaderAuth',
                    'sessionAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/events',
                'operation_id': 'list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'action',
                    'filename',
                    '_from',
                    'job_id',
                    'org_id',
                    'project_id',
                    'query_id',
                    'task_id',
                    'to',
                    'user_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'action',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('action',): {

                        "DOWNLOAD": "download"
                    },
                },
                'openapi_types': {
                    'action':
                        (str,),
                    'filename':
                        (str,),
                    '_from':
                        (datetime,),
                    'job_id':
                        (int,),
                    'org_id':
                        (int,),
                    'project_id':
                        (int,),
                    'query_id':
                        (str,),
                    'task_id':
                        (int,),
                    'to':
                        (datetime,),
                    'user_id':
                        (int,),
                },
                'attribute_map': {
                    'action': 'action',
                    'filename': 'filename',
                    '_from': 'from',
                    'job_id': 'job_id',
                    'org_id': 'org_id',
                    'project_id': 'project_id',
                    'query_id': 'query_id',
                    'task_id': 'task_id',
                    'to': 'to',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'action': 'query',
                    'filename': 'query',
                    '_from': 'query',
                    'job_id': 'query',
                    'org_id': 'query',
                    'project_id': 'query',
                    'query_id': 'query',
                    'task_id': 'query',
                    'to': 'query',
                    'user_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )

    def create(
        self,
        client_events_request: ClientEventsRequest,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[ClientEvents], urllib3.HTTPResponse]:
        """Log client events  # noqa: E501

        Sends logs to the Clickhouse if it is connected  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create(client_events_request, _async_call=True)
        >>> result = thread.get()

        Args:
            client_events_request (ClientEventsRequest):

        Keyword Args:
            x_organization (str): Organization unique slug. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (ClientEvents, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['client_events_request'] = client_events_request
        return self.create_endpoint.call_with_http_info(**kwargs)

    def create_export(
        self,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[RqId], urllib3.HTTPResponse]:
        """Initiate a process to export events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create_export(_async_call=True)
        >>> result = thread.get()


        Keyword Args:
            cloud_storage_id (int): Storage id. [optional]
            filename (str): Desired output file name. [optional]
            _from (datetime): UTC start date for events filtration. Default is the minimal time.. [optional]
            job_id (int): Filter events by job ID. [optional]
            location (str): Where need to save events file. [optional]
            org_id (int): Filter events by organization ID. [optional]
            project_id (int): Filter events by project ID. [optional]
            task_id (int): Filter events by task ID. [optional]
            to (datetime): UTC end date for events filtration. Default is the current time.. [optional]
            user_id (int): Filter events by user ID. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (RqId, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        return self.create_export_endpoint.call_with_http_info(**kwargs)

    def list(
        self,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[list] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Get an event log  # noqa: E501

        The log is returned in the CSV format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.list(_async_call=True)
        >>> result = thread.get()


        Keyword Args:
            action (str): Used to start downloading process after annotation file had been created. [optional] if omitted the server will use the default value of "download"
            filename (str): Desired output file name. [optional]
            _from (datetime): UTC start date for events filtration. Default is the minimal time.. [optional]
            job_id (int): Filter events by job ID. [optional]
            org_id (int): Filter events by organization ID. [optional]
            project_id (int): Filter events by project ID. [optional]
            query_id (str): ID of query request that need to check or download. [optional]
            task_id (int): Filter events by task ID. [optional]
            to (datetime): UTC end date for events filtration. Default is the current time.. [optional]
            user_id (int): Filter events by user ID. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        return self.list_endpoint.call_with_http_info(**kwargs)

