import typing as T
from pydantic import BaseModel
from edgedb_orm import is_unset


class BasePatch(BaseModel):
    def updated_fields(self, exclude: T.Set[str] = None) -> T.Set[str]:
        return {
            field
            for field in self.__fields__
            if field not in exclude and not is_unset(getattr(self, field))
        }
