# -*- coding: utf-8 -*-
"""Functions for rendering ORCA input files"""


def render_orca_input(params: dict) -> str:
    """Rendering ORCA input file.
    The only thing missing is the coordinate section.

    Args:
        params (dict): Input parameters

    Returns:
        str: Input file as a single string
    """

    # List of strings, one per line, concatenated at the end
    output = ['### Generated by AiiDA-ORCA Plugin ###']

    keywords = params.get('input_keywords', ['SP'])
    output.append(f'! {" ".join(keywords)}')

    if extra_keywords := params.get('extra_input_keywords'):
        output.append(f'! {" ".join(extra_keywords)}')

    if blocks := params.get('input_blocks'):
        for key in blocks.keys():
            output.append(f'%{key} ')
            for keyword, val in blocks[key].items():
                if val is None:
                    output.append(f'\t{keyword}')
                else:
                    output.append(f'\t{keyword} {val}')
            output.append('end\n')

    return '\n'.join(output)
