## About Raion Framework

Raion is a web application framework with expressive, elegant syntax inspired by [laravel](https://laravel.com) and built with [fastapi](https://fastapi.tiangolo.com). We believe development must be an enjoyable and creative experience to be truly fulfilling. Raion takes the pain out of development by easing common tasks used in many web projects, such as:

- [Simple, fast routing engine](https://raion.dev/docs/routing).
- [Powerful dependency injection container](https://raion.dev/docs/container).
- Multiple back-ends for [session](https://raion.dev/docs/session) and [cache](https://raion.dev/docs/cache) storage.
- Expressive, intuitive [database ORM](https://raion.dev/docs/eloquent).
- Database agnostic [schema migrations](https://raion.dev/docs/migrations).
- [Robust background job processing](https://raion.dev/docs/queues).
- [Real-time event broadcasting](https://raion.dev/docs/broadcasting).

Raion is accessible, powerful, and provides tools required for large, robust applications.

## Learning Raion

Raion has the most extensive and thorough [documentation](https://raion.dev/docs) and tutorial library of all modern web application frameworks, making it a breeze to get started with the framework.

## Raion Sponsors

We would like to extend our thanks to the following sponsors for funding Raion development. If you are interested in becoming a sponsor, please visit the Raion [Patreon page](https://patreon.com/raiondev).

## Contributing

Thank you for considering contributing to the Raion framework! The contribution guide can be found in the [Raion documentation](https://raion.dev/docs/contributions).

## Code of Conduct

In order to ensure that the Raion community is welcoming to all, please review and abide by the [Code of Conduct](https://raion.dev/docs/contributions#code-of-conduct).

## Security Vulnerabilities

If you discover a security vulnerability within Raion, please send an e-mail via [support@raion.dev](mailto:support@raion.dev). All security vulnerabilities will be promptly addressed.

## License

The Raion framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).