# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bakers_registry']

package_data = \
{'': ['*']}

install_requires = \
['conseil', 'jsondiff', 'pytezos', 'yaspin']

entry_points = \
{'console_scripts': ['bakers = bakers_registry:cli.main']}

setup_kwargs = {
    'name': 'bakers-registry',
    'version': '0.2.0',
    'description': 'Command line interface for the Tezos Bakers Registry',
    'long_description': '# Bakers Registry client\n\n[![PyPI version](https://badge.fury.io/py/bakers-registry.svg?)](https://badge.fury.io/py/bakers-registry)\n[![made_with pytezos](https://img.shields.io/badge/made_with-pytezos-blue.svg)](https://github.com/baking-bad/pytezos)\n[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)\n\nConsole client for the [Tezos Bakers Registry](https://tezit.github.io/baker-registry)\n\n![bakers-registry](https://i.imgur.com/dIO1JXy.gif)\n\n#### Decentralized approach\n* Does not depend on a particular indexer: you can choose from several options, or add new one with little efforts\n* Most data is retrieved from a pool of public RPC nodes\n\n## Installation\n\n```bash\npip install bakers-registry\n```\n\n#### Requirements\n* python 3.6+\n* pip\n\n## Get the current baker config\n\n```bash\nbakers get BAKER_ADDRESS <flags>\n```\n\n#### Arguments\n* `BAKER_ADDRESS`   tz-address\n* `--output_file=OUTPUT_FILE`   path to the file to store the data (optional)\n* `--raw=RAW`   keep intermediate data representation (default is False)\n* `--network=NETWORK`   Tezos network (default is mainnet)\n* `--registry_address=REGISTRY_ADDRESS` address of the registry contract (predefined)\n\n#### Sample output\n```json\n{\n  "bakerName": "Bake\'n\'Rolls",\n  "openForDelegation": true,\n  "bakerOffchainRegistryUrl": "https://bakenrolls.com/registry.json",\n  "fee": "0.09",\n  "bakerPaysFromAccounts": [\n    "tz1Zrqm4TkJwqTxm5TiyVFh6taXG4Wrq7tko"\n  ],\n  "minDelegation": "10",\n  "subtractPayoutsLessThanMin": true,\n  "payoutDelay": 6,\n  "payoutFrequency": 1,\n  "minPayout": "0",\n  "bakerChargesTransactionFee": true,\n  "paymentConfig": {\n    "payForOwnBlocks": true,\n    "payForStolenBlocks": true,\n    "compensateMissedBlocks": false,\n    "payForEndorsements": true,\n    "compensateLowPriorityEndorsementLoss": false,\n    "compensateMissedEndorsements": false,\n    "payGainedFees": true,\n    "payForAccusationGains": true,\n    "subtractLostDepositsWhenAccused": true,\n    "subtractLostRewardsWhenAccused": true,\n    "subtractLostFeesWhenAccused": true,\n    "payForRevelation": true,\n    "subtractLostRewardsWhenMissRevelation": true,\n    "subtractLostFeesWhenMissRevelation": true\n  },\n  "overDelegationThreshold": 100,\n  "subtractRewardsFromUninvitedDelegation": true\n}\n```\n\n##### Raw format\n```json\n{\n  "bakerName": "42616b65276e27526f6c6c73",\n  "openForDelegation": true,\n  "bakerOffchainRegistryUrl": "68747470733a2f2f62616b656e726f6c6c732e636f6d2f72656769737472792e6a736f6e",\n  "split": 9100,\n  "bakerPaysFromAccounts": [\n    "tz1Zrqm4TkJwqTxm5TiyVFh6taXG4Wrq7tko"\n  ],\n  "minDelegation": 100000,\n  "subtractPayoutsLessThanMin": true,\n  "payoutDelay": 6,\n  "payoutFrequency": 1,\n  "minPayout": 0,\n  "bakerChargesTransactionFee": true,\n  "paymentConfigMask": 16383,\n  "overDelegationThreshold": 100,\n  "subtractRewardsFromUninvitedDelegation": true,\n  "reporterAccount": "tz1Zrqm4TkJwqTxm5TiyVFh6taXG4Wrq7tko"\n}\n\n```\n\n## Generate tezos-client command from the config file\n```bash\nbakers set BAKER_ADDRESS INPUT_FILE <flags>\n```\n\n#### Arguments\n* `BAKER_ADDRESS`   tz-address\n* `INPUT_FILE`  path to the file with configuration (can contain any-level representation)\n* `--preview=PREVIEW`   print resulting config instead of command line (default is False)\n* `--network=NETWORK`   Tezos network (default is mainnet)\n* `--registry_address=REGISTRY_ADDRESS` address of the registry contract (predefined)\n\n#### Sample output\n\n```bash\ntransfer 0 from tz1NortRftucvAkD1J58L32EhSVrQEWJCEnB to KT1ChNsEFxwyCbJyWGSL3KdjeXE28AY1Kaog --entrypoint \'set_data\' --arg \'Pair "tz1NortRftucvAkD1J58L32EhSVrQEWJCEnB" (Pair (Some (Pair (Pair (Pair 0x42616b65276e27526f6c6c73 True) 0x68747470733a2f2f62616b656e726f6c6c732e636f6d2f72656769737472792e6a736f6e) (Pair (Pair 9100 { "tz1Zrqm4TkJwqTxm5TiyVFh6taXG4Wrq7tko" }) (Pair (Pair (Pair 100000 True) (Pair 6 (Pair 1 0))) (Pair (Pair True 16383) (Pair 100 True)))))) None)\'\n```\n\n## Create default config\n\n```bash\nbakers new <flags>\n```\n\n#### Arguments\n* `--output_file=OUTPUT_FILE`   path to the file to store the data (optional)\n\n## Get all bakers data\n\n```bash\nbakers all OUTPUT_FILE <flags>\n```\n\n#### Arguments\n* `OUTPUT_FILE`   path to the file\n* `--raw=RAW`   keep intermediate data representation (default is False)\n* `--indexer=INDEXER`   which indexer to use to retrieve operation levels [tzkt, tzstats, conseil]\n* `--network=NETWORK`   Tezos network (default is mainnet)\n* `--registry_address=REGISTRY_ADDRESS` address of the registry contract (predefined)\n\n## Get recent changes\n\n```bash\nbakers log <flags>\n```\n\n#### Arguments\n* `--output_file=OUTPUT_FILE`   path to the file\n* `--since=SINCE`   set lower bound, can be level (int) or string "level:700000" "cycle:170"\n* `--raw=RAW`   keep intermediate data representation (default is False)\n* `--indexer=INDEXER`   which indexer to use to retrieve operation levels [tzkt, tzstats, conseil]\n* `--network=NETWORK`   Tezos network (default is mainnet)\n* `--registry_address=REGISTRY_ADDRESS` address of the registry contract (predefined)\n\n#### Sample output\n\n```bash\n738542  Airfoil              subtractLostFeesWhenMissRevelation: true => false\n738542  Airfoil              subtractLostRewardsWhenMissRevelation: true => false\n738542  Airfoil              payForRevelation: true => false\n738542  Airfoil              bakerPaysFromAccounts: [] => ["tz1QH3G2btaWc1vRLNsEfx2gHM7Ad81TeRit"]\n738542  Airfoil              bakerOffchainRegistryUrl: "" => "https://airfoil.services/airfoil.json"\n738542  Airfoil              openForDelegation: false => true\n736381  Crypto Delegate LLC  subtractRewardsFromUninvitedDelegation: true => false\n736381  Crypto Delegate LLC  subtractLostFeesWhenMissRevelation: true => false\n736381  Crypto Delegate LLC  subtractLostRewardsWhenMissRevelation: true => false\n736381  Crypto Delegate LLC  subtractLostFeesWhenAccused: true => false\n736381  Crypto Delegate LLC  subtractLostRewardsWhenAccused: true => false\n736381  Crypto Delegate LLC  subtractLostDepositsWhenAccused: true => false\n736381  Crypto Delegate LLC  compensateMissedEndorsements: false => true\n736381  Crypto Delegate LLC  compensateMissedBlocks: false => true\n736381  Crypto Delegate LLC  payoutDelay: 6 => 0\n736381  Crypto Delegate LLC  subtractPayoutsLessThanMin: true => false\n736381  Crypto Delegate LLC  bakerPaysFromAccounts: [] => ["tz1MyXTZmeMCM4yFnrER9LNYDZ9t2rHYDvcH"]\n736381  Crypto Delegate LLC  fee: "0.25" => "-80"\n736381  Crypto Delegate LLC  bakerOffchainRegistryUrl: "" => "https://www.cryptodelegate.com/files/theme/CDReg.json"\n736381  Crypto Delegate LLC  bakerName: "Crypto Delegate" => "Crypto Delegate LLC"\n732641  YieldWallet.io       New Baker: tz1Q8QkSBS63ZQnH3fBTiAMPes9R666Rn6Sc\n730509  Bake\'n\'Rolls         minDelegation: "0" => "10"\n730226  TezoSteam            minDelegation: "0" => "100"\n730226  TezoSteam            bakerPaysFromAccounts: [] => ["tz1YrmJw6Lje27gWqZ94gU9mNavEjkHu1xGc"]\n730226  TezoSteam            bakerOffchainRegistryUrl: "" => "https://raw.githubusercontent.com/StakingTeam/TezoSteam/master/info/reg.json"\n730151  tezzz                fee: "0.03" => "0.045"\n```\n',
    'author': 'Michael Zaikin',
    'author_email': 'mz@baking-bad.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/baking-bad/bakers-registry-cli',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
