from typing import Union, List, Optional

from pyspark.sql.types import StructType, StructField, StringType, ArrayType, DataType


# This file is auto-generated by generate_schema so do not edit it manually
# noinspection PyPep8Naming
class ActivityDefinition_DynamicValueSchema:
    """
    This resource allows for the definition of some activity to be performed,
    independent of a particular patient, practitioner, or other performance
    context.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueUrl",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        This resource allows for the definition of some activity to be performed,
        independent of a particular patient, practitioner, or other performance
        context.


        id: Unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. To make the use of extensions safe and manageable,
            there is a strict set of governance  applied to the definition and use of
            extensions. Though any implementer can define an extension, there is a set of
            requirements that SHALL be met as part of the definition of the extension.

        path: The path to the element to be customized. This is the path on the resource
            that will hold the result of the calculation defined by the expression. The
            specified path SHALL be a FHIRPath resolveable on the specified target type of
            the ActivityDefinition, and SHALL consist only of identifiers, constant
            indexers, and a restricted subset of functions. The path is allowed to contain
            qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse
            multiple-cardinality sub-elements (see the [Simple FHIRPath
            Profile](fhirpath.html#simple) for full details).

        expression: An expression specifying the value of the customized element.

        """
        from spark_fhir_schemas.r4.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.r4.complex_types.expression import ExpressionSchema

        if (
            max_recursion_limit
            and nesting_list.count("ActivityDefinition_DynamicValue")
            >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ActivityDefinition_DynamicValue"]
        schema = StructType(
            [
                # Unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. To make the use of extensions safe and manageable,
                # there is a strict set of governance  applied to the definition and use of
                # extensions. Though any implementer can define an extension, there is a set of
                # requirements that SHALL be met as part of the definition of the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # The path to the element to be customized. This is the path on the resource
                # that will hold the result of the calculation defined by the expression. The
                # specified path SHALL be a FHIRPath resolveable on the specified target type of
                # the ActivityDefinition, and SHALL consist only of identifiers, constant
                # indexers, and a restricted subset of functions. The path is allowed to contain
                # qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse
                # multiple-cardinality sub-elements (see the [Simple FHIRPath
                # Profile](fhirpath.html#simple) for full details).
                StructField("path", StringType(), True),
                # An expression specifying the value of the customized element.
                StructField(
                    "expression",
                    ExpressionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
