from typing import List
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ExplanationOfBenefitSchema:
    """
    This resource provides: the claim details; adjudication details from the
    processing of a Claim; and optionally account balance information, for
    informing the subscriber of the benefits provided.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_recursion_depth: int = 4,
        recursion_depth: int = 0,
        recursion_list: List[str] = []
    ) -> Union[StructType, DataType]:
        """
        This resource provides: the claim details; adjudication details from the
        processing of a Claim; and optionally account balance information, for
        informing the subscriber of the benefits provided.


        resourceType: This is a ExplanationOfBenefit resource

        id: The logical id of the resource, as used in the URL for the resource. Once
            assigned, this value never changes.

        meta: The metadata about the resource. This is content that is maintained by the
            infrastructure. Changes to the content might not always be associated with
            version changes to the resource.

        implicitRules: A reference to a set of rules that were followed when the resource was
            constructed, and which must be understood when processing the content. Often,
            this is a reference to an implementation guide that defines the special rules
            along with other profiles etc.

        language: The base language in which the resource is written.

        text: A human-readable narrative that contains a summary of the resource and can be
            used to represent the content of the resource to a human. The narrative need
            not encode all the structured data, but is required to contain sufficient
            detail to make it "clinically safe" for a human to just read the narrative.
            Resource definitions may define what content should be represented in the
            narrative to ensure clinical safety.

        contained: These resources do not have an independent existence apart from the resource
            that contains them - they cannot be identified independently, and nor can they
            have their own independent transaction scope.

        extension: May be used to represent additional information that is not part of the basic
            definition of the resource. To make the use of extensions safe and manageable,
            there is a strict set of governance  applied to the definition and use of
            extensions. Though any implementer can define an extension, there is a set of
            requirements that SHALL be met as part of the definition of the extension.

        modifierExtension: May be used to represent additional information that is not part of the basic
            definition of the resource and that modifies the understanding of the element
            that contains it and/or the understanding of the containing element's
            descendants. Usually modifier elements provide negation or qualification. To
            make the use of extensions safe and manageable, there is a strict set of
            governance applied to the definition and use of extensions. Though any
            implementer is allowed to define an extension, there is a set of requirements
            that SHALL be met as part of the definition of the extension. Applications
            processing a resource are required to check for modifier extensions.

            Modifier extensions SHALL NOT change the meaning of any elements on Resource
            or DomainResource (including cannot change the meaning of modifierExtension
            itself).

        identifier: A unique identifier assigned to this explanation of benefit.

        status: The status of the resource instance.

        type: The category of claim, e.g. oral, pharmacy, vision, institutional,
            professional.

        subType: A finer grained suite of claim type codes which may convey additional
            information such as Inpatient vs Outpatient and/or a specialty service.

        use: A code to indicate whether the nature of the request is: to request
            adjudication of products and services previously rendered; or requesting
            authorization and adjudication for provision in the future; or requesting the
            non-binding adjudication of the listed products and services which could be
            provided in the future.

        patient: The party to whom the professional services and/or products have been supplied
            or are being considered and for whom actual for forecast reimbursement is
            sought.

        billablePeriod: The period for which charges are being submitted.

        created: The date this resource was created.

        enterer: Individual who created the claim, predetermination or preauthorization.

        insurer: The party responsible for authorization, adjudication and reimbursement.

        provider: The provider which is responsible for the claim, predetermination or
            preauthorization.

        priority: The provider-required urgency of processing the request. Typical values
            include: stat, routine deferred.

        fundsReserveRequested: A code to indicate whether and for whom funds are to be reserved for future
            claims.

        fundsReserve: A code, used only on a response to a preauthorization, to indicate whether the
            benefits payable have been reserved and for whom.

        related: Other claims which are related to this claim such as prior submissions or
            claims for related services or for the same event.

        prescription: Prescription to support the dispensing of pharmacy, device or vision products.

        originalPrescription: Original prescription which has been superseded by this prescription to
            support the dispensing of pharmacy services, medications or products.

        payee: The party to be reimbursed for cost of the products and services according to
            the terms of the policy.

        referral: A reference to a referral resource.

        facility: Facility where the services were provided.

        claim: The business identifier for the instance of the adjudication request: claim
            predetermination or preauthorization.

        claimResponse: The business identifier for the instance of the adjudication response: claim,
            predetermination or preauthorization response.

        outcome: The outcome of the claim, predetermination, or preauthorization processing.

        disposition: A human readable description of the status of the adjudication.

        preAuthRef: Reference from the Insurer which is used in later communications which refers
            to this adjudication.

        preAuthRefPeriod: The timeframe during which the supplied preauthorization reference may be
            quoted on claims to obtain the adjudication as provided.

        careTeam: The members of the team who provided the products and services.

        supportingInfo: Additional information codes regarding exceptions, special considerations, the
            condition, situation, prior or concurrent issues.

        diagnosis: Information about diagnoses relevant to the claim items.

        procedure: Procedures performed on the patient relevant to the billing items with the
            claim.

        precedence: This indicates the relative order of a series of EOBs related to different
            coverages for the same suite of services.

        insurance: Financial instruments for reimbursement for the health care products and
            services specified on the claim.

        accident: Details of a accident which resulted in injuries which required the products
            and services listed in the claim.

        item: A claim line. Either a simple (a product or service) or a 'group' of details
            which can also be a simple items or groups of sub-details.

        addItem: The first-tier service adjudications for payor added product or service lines.

        adjudication: The adjudication results which are presented at the header level rather than
            at the line-item or add-item levels.

        total: Categorized monetary totals for the adjudication.

        payment: Payment details for the adjudication of the claim.

        formCode: A code for the form to be used for printing the content.

        form: The actual form, by reference or inclusion, for printing the content or an
            EOB.

        processNote: A note that describes or explains adjudication results in a human readable
            form.

        benefitPeriod: The term of the benefits documented in this response.

        benefitBalance: Balance by Benefit Category.

        """
        from spark_fhir_schemas.r4.simple_types.id import idSchema
        from spark_fhir_schemas.r4.complex_types.meta import MetaSchema
        from spark_fhir_schemas.r4.simple_types.uri import uriSchema
        from spark_fhir_schemas.r4.simple_types.code import codeSchema
        from spark_fhir_schemas.r4.complex_types.narrative import NarrativeSchema
        from spark_fhir_schemas.r4.complex_types.resourcelist import ResourceListSchema
        from spark_fhir_schemas.r4.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.r4.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.r4.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.r4.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.r4.complex_types.period import PeriodSchema
        from spark_fhir_schemas.r4.simple_types.datetime import dateTimeSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_related import ExplanationOfBenefit_RelatedSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_payee import ExplanationOfBenefit_PayeeSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_careteam import ExplanationOfBenefit_CareTeamSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_supportinginfo import ExplanationOfBenefit_SupportingInfoSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_diagnosis import ExplanationOfBenefit_DiagnosisSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_procedure import ExplanationOfBenefit_ProcedureSchema
        from spark_fhir_schemas.r4.simple_types.positiveint import positiveIntSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_insurance import ExplanationOfBenefit_InsuranceSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_accident import ExplanationOfBenefit_AccidentSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_item import ExplanationOfBenefit_ItemSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_additem import ExplanationOfBenefit_AddItemSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_adjudication import ExplanationOfBenefit_AdjudicationSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_total import ExplanationOfBenefit_TotalSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_payment import ExplanationOfBenefit_PaymentSchema
        from spark_fhir_schemas.r4.complex_types.attachment import AttachmentSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_processnote import ExplanationOfBenefit_ProcessNoteSchema
        from spark_fhir_schemas.r4.complex_types.explanationofbenefit_benefitbalance import ExplanationOfBenefit_BenefitBalanceSchema
        if recursion_list.count(
            "ExplanationOfBenefit"
        ) >= 2 or recursion_depth >= max_recursion_depth:
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_recursion_list: List[str] = recursion_list + [
            "ExplanationOfBenefit"
        ]
        schema = StructType(
            [
                # This is a ExplanationOfBenefit resource
                StructField("resourceType", StringType(), True),
                # The logical id of the resource, as used in the URL for the resource. Once
                # assigned, this value never changes.
                StructField(
                    "id",
                    idSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The metadata about the resource. This is content that is maintained by the
                # infrastructure. Changes to the content might not always be associated with
                # version changes to the resource.
                StructField(
                    "meta",
                    MetaSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A reference to a set of rules that were followed when the resource was
                # constructed, and which must be understood when processing the content. Often,
                # this is a reference to an implementation guide that defines the special rules
                # along with other profiles etc.
                StructField(
                    "implicitRules",
                    uriSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The base language in which the resource is written.
                StructField(
                    "language",
                    codeSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A human-readable narrative that contains a summary of the resource and can be
                # used to represent the content of the resource to a human. The narrative need
                # not encode all the structured data, but is required to contain sufficient
                # detail to make it "clinically safe" for a human to just read the narrative.
                # Resource definitions may define what content should be represented in the
                # narrative to ensure clinical safety.
                StructField(
                    "text",
                    NarrativeSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # These resources do not have an independent existence apart from the resource
                # that contains them - they cannot be identified independently, and nor can they
                # have their own independent transaction scope.
                StructField(
                    "contained",
                    ArrayType(
                        ResourceListSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the resource. To make the use of extensions safe and manageable,
                # there is a strict set of governance  applied to the definition and use of
                # extensions. Though any implementer can define an extension, there is a set of
                # requirements that SHALL be met as part of the definition of the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the resource and that modifies the understanding of the element
                # that contains it and/or the understanding of the containing element's
                # descendants. Usually modifier elements provide negation or qualification. To
                # make the use of extensions safe and manageable, there is a strict set of
                # governance applied to the definition and use of extensions. Though any
                # implementer is allowed to define an extension, there is a set of requirements
                # that SHALL be met as part of the definition of the extension. Applications
                # processing a resource are required to check for modifier extensions.
                #
                # Modifier extensions SHALL NOT change the meaning of any elements on Resource
                # or DomainResource (including cannot change the meaning of modifierExtension
                # itself).
                StructField(
                    "modifierExtension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # A unique identifier assigned to this explanation of benefit.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # The status of the resource instance.
                StructField("status", StringType(), True),
                # The category of claim, e.g. oral, pharmacy, vision, institutional,
                # professional.
                StructField(
                    "type",
                    CodeableConceptSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A finer grained suite of claim type codes which may convey additional
                # information such as Inpatient vs Outpatient and/or a specialty service.
                StructField(
                    "subType",
                    CodeableConceptSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A code to indicate whether the nature of the request is: to request
                # adjudication of products and services previously rendered; or requesting
                # authorization and adjudication for provision in the future; or requesting the
                # non-binding adjudication of the listed products and services which could be
                # provided in the future.
                StructField(
                    "use",
                    codeSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The party to whom the professional services and/or products have been supplied
                # or are being considered and for whom actual for forecast reimbursement is
                # sought.
                StructField(
                    "patient",
                    ReferenceSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The period for which charges are being submitted.
                StructField(
                    "billablePeriod",
                    PeriodSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The date this resource was created.
                StructField(
                    "created",
                    dateTimeSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # Individual who created the claim, predetermination or preauthorization.
                StructField(
                    "enterer",
                    ReferenceSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The party responsible for authorization, adjudication and reimbursement.
                StructField(
                    "insurer",
                    ReferenceSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The provider which is responsible for the claim, predetermination or
                # preauthorization.
                StructField(
                    "provider",
                    ReferenceSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The provider-required urgency of processing the request. Typical values
                # include: stat, routine deferred.
                StructField(
                    "priority",
                    CodeableConceptSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A code to indicate whether and for whom funds are to be reserved for future
                # claims.
                StructField(
                    "fundsReserveRequested",
                    CodeableConceptSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A code, used only on a response to a preauthorization, to indicate whether the
                # benefits payable have been reserved and for whom.
                StructField(
                    "fundsReserve",
                    CodeableConceptSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # Other claims which are related to this claim such as prior submissions or
                # claims for related services or for the same event.
                StructField(
                    "related",
                    ArrayType(
                        ExplanationOfBenefit_RelatedSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # Prescription to support the dispensing of pharmacy, device or vision products.
                StructField(
                    "prescription",
                    ReferenceSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # Original prescription which has been superseded by this prescription to
                # support the dispensing of pharmacy services, medications or products.
                StructField(
                    "originalPrescription",
                    ReferenceSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The party to be reimbursed for cost of the products and services according to
                # the terms of the policy.
                StructField(
                    "payee",
                    ExplanationOfBenefit_PayeeSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A reference to a referral resource.
                StructField(
                    "referral",
                    ReferenceSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # Facility where the services were provided.
                StructField(
                    "facility",
                    ReferenceSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The business identifier for the instance of the adjudication request: claim
                # predetermination or preauthorization.
                StructField(
                    "claim",
                    ReferenceSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The business identifier for the instance of the adjudication response: claim,
                # predetermination or preauthorization response.
                StructField(
                    "claimResponse",
                    ReferenceSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The outcome of the claim, predetermination, or preauthorization processing.
                StructField(
                    "outcome",
                    codeSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A human readable description of the status of the adjudication.
                StructField("disposition", StringType(), True),
                # Reference from the Insurer which is used in later communications which refers
                # to this adjudication.
                StructField("preAuthRef", ArrayType(StringType()), True),
                # The timeframe during which the supplied preauthorization reference may be
                # quoted on claims to obtain the adjudication as provided.
                StructField(
                    "preAuthRefPeriod",
                    ArrayType(
                        PeriodSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # The members of the team who provided the products and services.
                StructField(
                    "careTeam",
                    ArrayType(
                        ExplanationOfBenefit_CareTeamSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # Additional information codes regarding exceptions, special considerations, the
                # condition, situation, prior or concurrent issues.
                StructField(
                    "supportingInfo",
                    ArrayType(
                        ExplanationOfBenefit_SupportingInfoSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # Information about diagnoses relevant to the claim items.
                StructField(
                    "diagnosis",
                    ArrayType(
                        ExplanationOfBenefit_DiagnosisSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # Procedures performed on the patient relevant to the billing items with the
                # claim.
                StructField(
                    "procedure",
                    ArrayType(
                        ExplanationOfBenefit_ProcedureSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # This indicates the relative order of a series of EOBs related to different
                # coverages for the same suite of services.
                StructField(
                    "precedence",
                    positiveIntSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # Financial instruments for reimbursement for the health care products and
                # services specified on the claim.
                StructField(
                    "insurance",
                    ArrayType(
                        ExplanationOfBenefit_InsuranceSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # Details of a accident which resulted in injuries which required the products
                # and services listed in the claim.
                StructField(
                    "accident",
                    ExplanationOfBenefit_AccidentSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A claim line. Either a simple (a product or service) or a 'group' of details
                # which can also be a simple items or groups of sub-details.
                StructField(
                    "item",
                    ArrayType(
                        ExplanationOfBenefit_ItemSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # The first-tier service adjudications for payor added product or service lines.
                StructField(
                    "addItem",
                    ArrayType(
                        ExplanationOfBenefit_AddItemSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # The adjudication results which are presented at the header level rather than
                # at the line-item or add-item levels.
                StructField(
                    "adjudication",
                    ArrayType(
                        ExplanationOfBenefit_AdjudicationSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # Categorized monetary totals for the adjudication.
                StructField(
                    "total",
                    ArrayType(
                        ExplanationOfBenefit_TotalSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # Payment details for the adjudication of the claim.
                StructField(
                    "payment",
                    ExplanationOfBenefit_PaymentSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A code for the form to be used for printing the content.
                StructField(
                    "formCode",
                    CodeableConceptSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The actual form, by reference or inclusion, for printing the content or an
                # EOB.
                StructField(
                    "form",
                    AttachmentSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A note that describes or explains adjudication results in a human readable
                # form.
                StructField(
                    "processNote",
                    ArrayType(
                        ExplanationOfBenefit_ProcessNoteSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # The term of the benefits documented in this response.
                StructField(
                    "benefitPeriod",
                    PeriodSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # Balance by Benefit Category.
                StructField(
                    "benefitBalance",
                    ArrayType(
                        ExplanationOfBenefit_BenefitBalanceSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
            ]
        )
        return schema
