from typing import List
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class TriggerDefinitionSchema:
    """
    A description of a triggering event. Triggering events can be named events,
    data events, or periodic, as determined by the type element.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_recursion_depth: int = 4,
        recursion_depth: int = 0,
        recursion_list: List[str] = []
    ) -> Union[StructType, DataType]:
        """
        A description of a triggering event. Triggering events can be named events,
        data events, or periodic, as determined by the type element.


        id: Unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. To make the use of extensions safe and manageable,
            there is a strict set of governance  applied to the definition and use of
            extensions. Though any implementer can define an extension, there is a set of
            requirements that SHALL be met as part of the definition of the extension.

        type: The type of triggering event.

        name: A formal name for the event. This may be an absolute URI that identifies the
            event formally (e.g. from a trigger registry), or a simple relative URI that
            identifies the event in a local context.

        timingTiming: The timing of the event (if this is a periodic trigger).

        timingReference: The timing of the event (if this is a periodic trigger).

        timingDate: The timing of the event (if this is a periodic trigger).

        timingDateTime: The timing of the event (if this is a periodic trigger).

        data: The triggering data of the event (if this is a data trigger). If more than one
            data is requirement is specified, then all the data requirements must be true.

        condition: A boolean-valued expression that is evaluated in the context of the container
            of the trigger definition and returns whether or not the trigger fires.

        """
        from spark_fhir_schemas.r4.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.r4.complex_types.timing import TimingSchema
        from spark_fhir_schemas.r4.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.r4.complex_types.datarequirement import DataRequirementSchema
        from spark_fhir_schemas.r4.complex_types.expression import ExpressionSchema
        if recursion_list.count(
            "TriggerDefinition"
        ) >= 2 or recursion_depth >= max_recursion_depth:
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_recursion_list: List[str] = recursion_list + ["TriggerDefinition"]
        schema = StructType(
            [
                # Unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. To make the use of extensions safe and manageable,
                # there is a strict set of governance  applied to the definition and use of
                # extensions. Though any implementer can define an extension, there is a set of
                # requirements that SHALL be met as part of the definition of the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # The type of triggering event.
                StructField("type", StringType(), True),
                # A formal name for the event. This may be an absolute URI that identifies the
                # event formally (e.g. from a trigger registry), or a simple relative URI that
                # identifies the event in a local context.
                StructField("name", StringType(), True),
                # The timing of the event (if this is a periodic trigger).
                StructField(
                    "timingTiming",
                    TimingSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The timing of the event (if this is a periodic trigger).
                StructField(
                    "timingReference",
                    ReferenceSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The timing of the event (if this is a periodic trigger).
                StructField("timingDate", StringType(), True),
                # The timing of the event (if this is a periodic trigger).
                StructField("timingDateTime", StringType(), True),
                # The triggering data of the event (if this is a data trigger). If more than one
                # data is requirement is specified, then all the data requirements must be true.
                StructField(
                    "data",
                    ArrayType(
                        DataRequirementSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # A boolean-valued expression that is evaluated in the context of the container
                # of the trigger definition and returns whether or not the trigger fires.
                StructField(
                    "condition",
                    ExpressionSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
            ]
        )
        return schema
