from typing import List
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class TestScript_OperationSchema:
    """
    A structured set of tests against a FHIR server or client implementation to
    determine compliance against the FHIR specification.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_recursion_depth: int = 4,
        recursion_depth: int = 0,
        recursion_list: List[str] = []
    ) -> Union[StructType, DataType]:
        """
        A structured set of tests against a FHIR server or client implementation to
        determine compliance against the FHIR specification.


        id: Unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. To make the use of extensions safe and manageable,
            there is a strict set of governance  applied to the definition and use of
            extensions. Though any implementer can define an extension, there is a set of
            requirements that SHALL be met as part of the definition of the extension.

        modifierExtension: May be used to represent additional information that is not part of the basic
            definition of the element and that modifies the understanding of the element
            in which it is contained and/or the understanding of the containing element's
            descendants. Usually modifier elements provide negation or qualification. To
            make the use of extensions safe and manageable, there is a strict set of
            governance applied to the definition and use of extensions. Though any
            implementer can define an extension, there is a set of requirements that SHALL
            be met as part of the definition of the extension. Applications processing a
            resource are required to check for modifier extensions.

            Modifier extensions SHALL NOT change the meaning of any elements on Resource
            or DomainResource (including cannot change the meaning of modifierExtension
            itself).

        type: Server interaction or operation type.

        resource: The type of the resource.  See http://build.fhir.org/resourcelist.html.

        label: The label would be used for tracking/logging purposes by test engines.

        description: The description would be used by test engines for tracking and reporting
            purposes.

        accept: The mime-type to use for RESTful operation in the 'Accept' header.

        contentType: The mime-type to use for RESTful operation in the 'Content-Type' header.

        destination: The server where the request message is destined for.  Must be one of the
            server numbers listed in TestScript.destination section.

        encodeRequestUrl: Whether or not to implicitly send the request url in encoded format. The
            default is true to match the standard RESTful client behavior. Set to false
            when communicating with a server that does not support encoded url paths.

        method: The HTTP method the test engine MUST use for this operation regardless of any
            other operation details.

        origin: The server where the request message originates from.  Must be one of the
            server numbers listed in TestScript.origin section.

        params: Path plus parameters after [type].  Used to set parts of the request URL
            explicitly.

        requestHeader: Header elements would be used to set HTTP headers.

        requestId: The fixture id (maybe new) to map to the request.

        responseId: The fixture id (maybe new) to map to the response.

        sourceId: The id of the fixture used as the body of a PUT or POST request.

        targetId: Id of fixture used for extracting the [id],  [type], and [vid] for GET
            requests.

        url: Complete request URL.

        """
        from spark_fhir_schemas.r4.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.r4.complex_types.coding import CodingSchema
        from spark_fhir_schemas.r4.simple_types.code import codeSchema
        from spark_fhir_schemas.r4.simple_types.integer import integerSchema
        from spark_fhir_schemas.r4.complex_types.testscript_requestheader import TestScript_RequestHeaderSchema
        from spark_fhir_schemas.r4.simple_types.id import idSchema
        if recursion_list.count(
            "TestScript_Operation"
        ) >= 2 or recursion_depth >= max_recursion_depth:
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_recursion_list: List[str] = recursion_list + [
            "TestScript_Operation"
        ]
        schema = StructType(
            [
                # Unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. To make the use of extensions safe and manageable,
                # there is a strict set of governance  applied to the definition and use of
                # extensions. Though any implementer can define an extension, there is a set of
                # requirements that SHALL be met as part of the definition of the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element and that modifies the understanding of the element
                # in which it is contained and/or the understanding of the containing element's
                # descendants. Usually modifier elements provide negation or qualification. To
                # make the use of extensions safe and manageable, there is a strict set of
                # governance applied to the definition and use of extensions. Though any
                # implementer can define an extension, there is a set of requirements that SHALL
                # be met as part of the definition of the extension. Applications processing a
                # resource are required to check for modifier extensions.
                #
                # Modifier extensions SHALL NOT change the meaning of any elements on Resource
                # or DomainResource (including cannot change the meaning of modifierExtension
                # itself).
                StructField(
                    "modifierExtension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # Server interaction or operation type.
                StructField(
                    "type",
                    CodingSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The type of the resource.  See http://build.fhir.org/resourcelist.html.
                StructField(
                    "resource",
                    codeSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The label would be used for tracking/logging purposes by test engines.
                StructField("label", StringType(), True),
                # The description would be used by test engines for tracking and reporting
                # purposes.
                StructField("description", StringType(), True),
                # The mime-type to use for RESTful operation in the 'Accept' header.
                StructField(
                    "accept",
                    codeSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The mime-type to use for RESTful operation in the 'Content-Type' header.
                StructField(
                    "contentType",
                    codeSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The server where the request message is destined for.  Must be one of the
                # server numbers listed in TestScript.destination section.
                StructField(
                    "destination",
                    integerSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # Whether or not to implicitly send the request url in encoded format. The
                # default is true to match the standard RESTful client behavior. Set to false
                # when communicating with a server that does not support encoded url paths.
                StructField("encodeRequestUrl", BooleanType(), True),
                # The HTTP method the test engine MUST use for this operation regardless of any
                # other operation details.
                StructField("method", StringType(), True),
                # The server where the request message originates from.  Must be one of the
                # server numbers listed in TestScript.origin section.
                StructField(
                    "origin",
                    integerSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # Path plus parameters after [type].  Used to set parts of the request URL
                # explicitly.
                StructField("params", StringType(), True),
                # Header elements would be used to set HTTP headers.
                StructField(
                    "requestHeader",
                    ArrayType(
                        TestScript_RequestHeaderSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # The fixture id (maybe new) to map to the request.
                StructField(
                    "requestId",
                    idSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The fixture id (maybe new) to map to the response.
                StructField(
                    "responseId",
                    idSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # The id of the fixture used as the body of a PUT or POST request.
                StructField(
                    "sourceId",
                    idSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # Id of fixture used for extracting the [id],  [type], and [vid] for GET
                # requests.
                StructField(
                    "targetId",
                    idSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # Complete request URL.
                StructField("url", StringType(), True),
            ]
        )
        return schema
