from typing import List
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MetaSchema:
    """
    The metadata about a resource. This is content in the resource that is
    maintained by the infrastructure. Changes to the content might not always be
    associated with version changes to the resource.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_recursion_depth: int = 4,
        recursion_depth: int = 0,
        recursion_list: List[str] = []
    ) -> Union[StructType, DataType]:
        """
        The metadata about a resource. This is content in the resource that is
        maintained by the infrastructure. Changes to the content might not always be
        associated with version changes to the resource.


        id: Unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. To make the use of extensions safe and manageable,
            there is a strict set of governance  applied to the definition and use of
            extensions. Though any implementer can define an extension, there is a set of
            requirements that SHALL be met as part of the definition of the extension.

        versionId: The version specific identifier, as it appears in the version portion of the
            URL. This value changes when the resource is created, updated, or deleted.

        lastUpdated: When the resource last changed - e.g. when the version changed.

        source: A uri that identifies the source system of the resource. This provides a
            minimal amount of [[[Provenance]]] information that can be used to track or
            differentiate the source of information in the resource. The source may
            identify another FHIR server, document, message, database, etc.

        profile: A list of profiles (references to [[[StructureDefinition]]] resources) that
            this resource claims to conform to. The URL is a reference to
            [[[StructureDefinition.url]]].

        security: Security labels applied to this resource. These tags connect specific
            resources to the overall security policy and infrastructure.

        tag: Tags applied to this resource. Tags are intended to be used to identify and
            relate resources to process and workflow, and applications are not required to
            consider the tags when interpreting the meaning of a resource.

        """
        from spark_fhir_schemas.r4.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.r4.simple_types.id import idSchema
        from spark_fhir_schemas.r4.simple_types.instant import instantSchema
        from spark_fhir_schemas.r4.simple_types.uri import uriSchema
        from spark_fhir_schemas.r4.simple_types.canonical import canonicalSchema
        from spark_fhir_schemas.r4.complex_types.coding import CodingSchema
        if recursion_list.count(
            "Meta"
        ) >= 2 or recursion_depth >= max_recursion_depth:
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_recursion_list: List[str] = recursion_list + ["Meta"]
        schema = StructType(
            [
                # Unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. To make the use of extensions safe and manageable,
                # there is a strict set of governance  applied to the definition and use of
                # extensions. Though any implementer can define an extension, there is a set of
                # requirements that SHALL be met as part of the definition of the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # The version specific identifier, as it appears in the version portion of the
                # URL. This value changes when the resource is created, updated, or deleted.
                StructField(
                    "versionId",
                    idSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # When the resource last changed - e.g. when the version changed.
                StructField(
                    "lastUpdated",
                    instantSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A uri that identifies the source system of the resource. This provides a
                # minimal amount of [[[Provenance]]] information that can be used to track or
                # differentiate the source of information in the resource. The source may
                # identify another FHIR server, document, message, database, etc.
                StructField(
                    "source",
                    uriSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # A list of profiles (references to [[[StructureDefinition]]] resources) that
                # this resource claims to conform to. The URL is a reference to
                # [[[StructureDefinition.url]]].
                StructField(
                    "profile",
                    ArrayType(
                        canonicalSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # Security labels applied to this resource. These tags connect specific
                # resources to the overall security policy and infrastructure.
                StructField(
                    "security",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # Tags applied to this resource. Tags are intended to be used to identify and
                # relate resources to process and workflow, and applications are not required to
                # consider the tags when interpreting the meaning of a resource.
                StructField(
                    "tag",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
            ]
        )
        return schema
