from typing import List
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ContactPointSchema:
    """
    Details for all kinds of technology mediated contact points for a person or
    organization, including telephone, email, etc.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_recursion_depth: int = 4,
        recursion_depth: int = 0,
        recursion_list: List[str] = []
    ) -> Union[StructType, DataType]:
        """
        Details for all kinds of technology mediated contact points for a person or
        organization, including telephone, email, etc.


        id: Unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. To make the use of extensions safe and manageable,
            there is a strict set of governance  applied to the definition and use of
            extensions. Though any implementer can define an extension, there is a set of
            requirements that SHALL be met as part of the definition of the extension.

        system: Telecommunications form for contact point - what communications system is
            required to make use of the contact.

        value: The actual contact point details, in a form that is meaningful to the
            designated communication system (i.e. phone number or email address).

        use: Identifies the purpose for the contact point.

        rank: Specifies a preferred order in which to use a set of contacts. ContactPoints
            with lower rank values are more preferred than those with higher rank values.

        period: Time period when the contact point was/is in use.

        """
        from spark_fhir_schemas.r4.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.r4.simple_types.positiveint import positiveIntSchema
        from spark_fhir_schemas.r4.complex_types.period import PeriodSchema
        if recursion_list.count(
            "ContactPoint"
        ) >= 2 or recursion_depth >= max_recursion_depth:
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_recursion_list: List[str] = recursion_list + ["ContactPoint"]
        schema = StructType(
            [
                # Unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. To make the use of extensions safe and manageable,
                # there is a strict set of governance  applied to the definition and use of
                # extensions. Though any implementer can define an extension, there is a set of
                # requirements that SHALL be met as part of the definition of the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_recursion_depth=max_recursion_depth,
                            recursion_depth=recursion_depth + 1,
                            recursion_list=my_recursion_list
                        )
                    ), True
                ),
                # Telecommunications form for contact point - what communications system is
                # required to make use of the contact.
                StructField("system", StringType(), True),
                # The actual contact point details, in a form that is meaningful to the
                # designated communication system (i.e. phone number or email address).
                StructField("value", StringType(), True),
                # Identifies the purpose for the contact point.
                StructField("use", StringType(), True),
                # Specifies a preferred order in which to use a set of contacts. ContactPoints
                # with lower rank values are more preferred than those with higher rank values.
                StructField(
                    "rank",
                    positiveIntSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
                # Time period when the contact point was/is in use.
                StructField(
                    "period",
                    PeriodSchema.get_schema(
                        max_recursion_depth=max_recursion_depth,
                        recursion_depth=recursion_depth + 1,
                        recursion_list=my_recursion_list
                    ), True
                ),
            ]
        )
        return schema
