# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['KafkaClusterArgs', 'KafkaCluster']

@pulumi.input_type
class KafkaClusterArgs:
    def __init__(__self__, *,
                 availability: pulumi.Input[str],
                 environment_id: pulumi.Input[str],
                 region: pulumi.Input[str],
                 service_provider: pulumi.Input[str],
                 cku: Optional[pulumi.Input[int]] = None,
                 deployment: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_egress: Optional[pulumi.Input[int]] = None,
                 network_ingress: Optional[pulumi.Input[int]] = None,
                 storage: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a KafkaCluster resource.
        :param pulumi.Input[str] availability: LOW(single-zone) or HIGH(multi-zone)
        :param pulumi.Input[str] environment_id: Environment ID
        :param pulumi.Input[str] region: where
        :param pulumi.Input[str] service_provider: AWS / GCP
        :param pulumi.Input[int] cku: cku
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] deployment: Deployment settings. Currently only `sku` is supported.
        :param pulumi.Input[str] name: The name of the cluster
        :param pulumi.Input[int] network_egress: Network egress limit(MBps)
        :param pulumi.Input[int] network_ingress: Network ingress limit(MBps)
        :param pulumi.Input[int] storage: Storage limit(GB)
        """
        pulumi.set(__self__, "availability", availability)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "service_provider", service_provider)
        if cku is not None:
            pulumi.set(__self__, "cku", cku)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_egress is not None:
            pulumi.set(__self__, "network_egress", network_egress)
        if network_ingress is not None:
            pulumi.set(__self__, "network_ingress", network_ingress)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)

    @property
    @pulumi.getter
    def availability(self) -> pulumi.Input[str]:
        """
        LOW(single-zone) or HIGH(multi-zone)
        """
        return pulumi.get(self, "availability")

    @availability.setter
    def availability(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        Environment ID
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        where
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceProvider")
    def service_provider(self) -> pulumi.Input[str]:
        """
        AWS / GCP
        """
        return pulumi.get(self, "service_provider")

    @service_provider.setter
    def service_provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_provider", value)

    @property
    @pulumi.getter
    def cku(self) -> Optional[pulumi.Input[int]]:
        """
        cku
        """
        return pulumi.get(self, "cku")

    @cku.setter
    def cku(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cku", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Deployment settings. Currently only `sku` is supported.
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkEgress")
    def network_egress(self) -> Optional[pulumi.Input[int]]:
        """
        Network egress limit(MBps)
        """
        return pulumi.get(self, "network_egress")

    @network_egress.setter
    def network_egress(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "network_egress", value)

    @property
    @pulumi.getter(name="networkIngress")
    def network_ingress(self) -> Optional[pulumi.Input[int]]:
        """
        Network ingress limit(MBps)
        """
        return pulumi.get(self, "network_ingress")

    @network_ingress.setter
    def network_ingress(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "network_ingress", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[int]]:
        """
        Storage limit(GB)
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage", value)


@pulumi.input_type
class _KafkaClusterState:
    def __init__(__self__, *,
                 availability: Optional[pulumi.Input[str]] = None,
                 bootstrap_servers: Optional[pulumi.Input[str]] = None,
                 cku: Optional[pulumi.Input[int]] = None,
                 deployment: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_egress: Optional[pulumi.Input[int]] = None,
                 network_ingress: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_provider: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering KafkaCluster resources.
        :param pulumi.Input[str] availability: LOW(single-zone) or HIGH(multi-zone)
        :param pulumi.Input[int] cku: cku
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] deployment: Deployment settings. Currently only `sku` is supported.
        :param pulumi.Input[str] environment_id: Environment ID
        :param pulumi.Input[str] name: The name of the cluster
        :param pulumi.Input[int] network_egress: Network egress limit(MBps)
        :param pulumi.Input[int] network_ingress: Network ingress limit(MBps)
        :param pulumi.Input[str] region: where
        :param pulumi.Input[str] service_provider: AWS / GCP
        :param pulumi.Input[int] storage: Storage limit(GB)
        """
        if availability is not None:
            pulumi.set(__self__, "availability", availability)
        if bootstrap_servers is not None:
            pulumi.set(__self__, "bootstrap_servers", bootstrap_servers)
        if cku is not None:
            pulumi.set(__self__, "cku", cku)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_egress is not None:
            pulumi.set(__self__, "network_egress", network_egress)
        if network_ingress is not None:
            pulumi.set(__self__, "network_ingress", network_ingress)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_provider is not None:
            pulumi.set(__self__, "service_provider", service_provider)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)

    @property
    @pulumi.getter
    def availability(self) -> Optional[pulumi.Input[str]]:
        """
        LOW(single-zone) or HIGH(multi-zone)
        """
        return pulumi.get(self, "availability")

    @availability.setter
    def availability(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability", value)

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bootstrap_servers")

    @bootstrap_servers.setter
    def bootstrap_servers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_servers", value)

    @property
    @pulumi.getter
    def cku(self) -> Optional[pulumi.Input[int]]:
        """
        cku
        """
        return pulumi.get(self, "cku")

    @cku.setter
    def cku(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cku", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Deployment settings. Currently only `sku` is supported.
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Environment ID
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkEgress")
    def network_egress(self) -> Optional[pulumi.Input[int]]:
        """
        Network egress limit(MBps)
        """
        return pulumi.get(self, "network_egress")

    @network_egress.setter
    def network_egress(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "network_egress", value)

    @property
    @pulumi.getter(name="networkIngress")
    def network_ingress(self) -> Optional[pulumi.Input[int]]:
        """
        Network ingress limit(MBps)
        """
        return pulumi.get(self, "network_ingress")

    @network_ingress.setter
    def network_ingress(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "network_ingress", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        where
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceProvider")
    def service_provider(self) -> Optional[pulumi.Input[str]]:
        """
        AWS / GCP
        """
        return pulumi.get(self, "service_provider")

    @service_provider.setter
    def service_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_provider", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[int]]:
        """
        Storage limit(GB)
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage", value)


class KafkaCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability: Optional[pulumi.Input[str]] = None,
                 cku: Optional[pulumi.Input[int]] = None,
                 deployment: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_egress: Optional[pulumi.Input[int]] = None,
                 network_ingress: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_provider: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a KafkaCluster resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability: LOW(single-zone) or HIGH(multi-zone)
        :param pulumi.Input[int] cku: cku
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] deployment: Deployment settings. Currently only `sku` is supported.
        :param pulumi.Input[str] environment_id: Environment ID
        :param pulumi.Input[str] name: The name of the cluster
        :param pulumi.Input[int] network_egress: Network egress limit(MBps)
        :param pulumi.Input[int] network_ingress: Network ingress limit(MBps)
        :param pulumi.Input[str] region: where
        :param pulumi.Input[str] service_provider: AWS / GCP
        :param pulumi.Input[int] storage: Storage limit(GB)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a KafkaCluster resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param KafkaClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability: Optional[pulumi.Input[str]] = None,
                 cku: Optional[pulumi.Input[int]] = None,
                 deployment: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_egress: Optional[pulumi.Input[int]] = None,
                 network_ingress: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_provider: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaClusterArgs.__new__(KafkaClusterArgs)

            if availability is None and not opts.urn:
                raise TypeError("Missing required property 'availability'")
            __props__.__dict__["availability"] = availability
            __props__.__dict__["cku"] = cku
            __props__.__dict__["deployment"] = deployment
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["name"] = name
            __props__.__dict__["network_egress"] = network_egress
            __props__.__dict__["network_ingress"] = network_ingress
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if service_provider is None and not opts.urn:
                raise TypeError("Missing required property 'service_provider'")
            __props__.__dict__["service_provider"] = service_provider
            __props__.__dict__["storage"] = storage
            __props__.__dict__["bootstrap_servers"] = None
        super(KafkaCluster, __self__).__init__(
            'confluent:index/kafkaCluster:KafkaCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability: Optional[pulumi.Input[str]] = None,
            bootstrap_servers: Optional[pulumi.Input[str]] = None,
            cku: Optional[pulumi.Input[int]] = None,
            deployment: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_egress: Optional[pulumi.Input[int]] = None,
            network_ingress: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            service_provider: Optional[pulumi.Input[str]] = None,
            storage: Optional[pulumi.Input[int]] = None) -> 'KafkaCluster':
        """
        Get an existing KafkaCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability: LOW(single-zone) or HIGH(multi-zone)
        :param pulumi.Input[int] cku: cku
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] deployment: Deployment settings. Currently only `sku` is supported.
        :param pulumi.Input[str] environment_id: Environment ID
        :param pulumi.Input[str] name: The name of the cluster
        :param pulumi.Input[int] network_egress: Network egress limit(MBps)
        :param pulumi.Input[int] network_ingress: Network ingress limit(MBps)
        :param pulumi.Input[str] region: where
        :param pulumi.Input[str] service_provider: AWS / GCP
        :param pulumi.Input[int] storage: Storage limit(GB)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaClusterState.__new__(_KafkaClusterState)

        __props__.__dict__["availability"] = availability
        __props__.__dict__["bootstrap_servers"] = bootstrap_servers
        __props__.__dict__["cku"] = cku
        __props__.__dict__["deployment"] = deployment
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_egress"] = network_egress
        __props__.__dict__["network_ingress"] = network_ingress
        __props__.__dict__["region"] = region
        __props__.__dict__["service_provider"] = service_provider
        __props__.__dict__["storage"] = storage
        return KafkaCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def availability(self) -> pulumi.Output[str]:
        """
        LOW(single-zone) or HIGH(multi-zone)
        """
        return pulumi.get(self, "availability")

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> pulumi.Output[str]:
        return pulumi.get(self, "bootstrap_servers")

    @property
    @pulumi.getter
    def cku(self) -> pulumi.Output[Optional[int]]:
        """
        cku
        """
        return pulumi.get(self, "cku")

    @property
    @pulumi.getter
    def deployment(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Deployment settings. Currently only `sku` is supported.
        """
        return pulumi.get(self, "deployment")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        Environment ID
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the cluster
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkEgress")
    def network_egress(self) -> pulumi.Output[Optional[int]]:
        """
        Network egress limit(MBps)
        """
        return pulumi.get(self, "network_egress")

    @property
    @pulumi.getter(name="networkIngress")
    def network_ingress(self) -> pulumi.Output[Optional[int]]:
        """
        Network ingress limit(MBps)
        """
        return pulumi.get(self, "network_ingress")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        where
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceProvider")
    def service_provider(self) -> pulumi.Output[str]:
        """
        AWS / GCP
        """
        return pulumi.get(self, "service_provider")

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Output[Optional[int]]:
        """
        Storage limit(GB)
        """
        return pulumi.get(self, "storage")

