from typing import Optional

from pydantic import dataclasses as pydantic_dataclasses


@pydantic_dataclasses.dataclass
class LlmSettings:
    """LLM settings for agents.

    These settings influence how agent responses are generated by the underlying LLM.

    Args:
        model Optional[str]: The name of the LLM to use.
            See https://docs.fixie.ai/agents/#agent-default-model-and-model-params for supported
            values.
        temperature Optional[float]: The sampling temperature to use, between 0 and 2.
            Higher values like 0.8 will make the output more random, while lower values like
            0.2 will make it more focused and deterministic. The precise behavior is
            model-specific.
        maximum_tokens Optional[int]: The maximum number of tokens to generate in responses.
            One token is typically a subword. The exact token definition depends on the model.
    """

    model: Optional[str] = None
    temperature: Optional[float] = None
    maximum_tokens: Optional[int] = None
