# flake8: noqa
# Countries list (ISO-3166)
COUNTRIES = {'##': 'non renseign\xc3\xa9',
             '..': 'non renseign\xc3\xa9',
             'aa': 'aire g\xc3\xa9ographique ancienne',
             'ad': 'Andorre',
             'ae': '\xc3\x89mirats arabes unis',
             'af': 'Afghanistan',
             'ag': 'Antigua-et-Barbuda',
             'ai': 'Anguilla',
             'al': 'Albanie',
             'am': 'Arm\xc3\xa9nie',
             'an': 'Antilles n\xc3\xa9erlandaises',
             'ao': 'Angola',
             'aq': 'Antarctique',
             'ar': 'Argentine',
             'as': 'Samoa am\xc3\xa9ricaines',
             'at': 'Autriche',
             'au': 'Australie',
             'aw': 'Aruba',
             'ax': 'Aland (\xc3\xaeles)',
             'az': 'Azerba\xc3\xafdjan',
             'ba': 'Bosnie-Herz\xc3\xa9govine',
             'bb': 'Barbade',
             'bd': 'Bangladesh',
             'be': 'Belgique',
             'bf': 'Burkina',
             'bg': 'Bulgarie',
             'bh': 'Bahre\xc3\xafn',
             'bi': 'Burundi',
             'bj': 'B\xc3\xa9nin',
             'bl': 'Saint-Barth\xc3\xa9lemy',
             'bm': 'Bermudes',
             'bn': 'Brun\xc3\xa9i',
             'bo': 'Bolivie',
             'bq': 'Bonaire, Saint-Eustache et Saba,Saba###Saint-Eustache',
             'br': 'Br\xc3\xa9sil',
             'bs': 'Bahamas',
             'bt': 'Bhoutan',
             'bv': 'Bouvet (\xc3\xaele)',
             'bw': 'Botswana',
             'by': 'Bi\xc3\xa9lorussie,B\xc3\xa9larus',
             'bz': 'Belize',
             'ca': 'Canada',
             'cc': 'Cocos (\xc3\xaeles),Keeling (\xc3\xaeles)',
             'cd': 'Congo (R\xc3\xa9publique d\xc3\xa9mocratique),Za\xc3\xafre',
             'cf': 'Centrafrique,R\xc3\xa9publique centrafricaine',
             'cg': 'Congo,Congo (R\xc3\xa9publique)',
             'ch': 'Suisse,Conf\xc3\xa9d\xc3\xa9ration helv\xc3\xa9tique',
             'ci': "C\xc3\xb4te d'Ivoire\n",
             'ck': 'Cook (\xc3\xaeles)',
             'cl': 'Chili',
             'cm': 'Cameroun',
             'cn': 'Chine,Chine (R\xc3\xa9publique populaire)',
             'co': 'Colombie',
             'cr': 'Costa Rica',
             'cs': 'Serbie-et-Mont\xc3\xa9n\xc3\xa9gro',
             'cu': 'Cuba',
             'cv': 'Cap-Vert',
             'cw': 'Cura\xc3\xa7ao',
             'cx': 'Christmas (\xc3\xaele)',
             'cy': 'Chypre',
             'cz': 'R\xc3\xa9publique tch\xc3\xa8que,Tch\xc3\xa8que, R\xc3\xa9publique',
             'dd': 'Allemagne (R\xc3\xa9publique d\xc3\xa9mocratique)',
             'de': 'Allemagne,Allemagne (R\xc3\xa9publique f\xc3\xa9d\xc3\xa9rale)',
             'dj': 'Djibouti',
             'dk': 'Danemark',
             'dm': 'Dominique',
             'do': 'R\xc3\xa9publique dominicaine,Dominicaine, R\xc3\xa9publique',
             'dz': 'Alg\xc3\xa9rie',
             'ec': '\xc3\x89quateur',
             'ee': 'Estonie',
             'eg': '\xc3\x89gypte',
             'eh': 'Sahara occidental',
             'er': '\xc3\x89rythr\xc3\xa9e',
             'es': 'Espagne',
             'et': '\xc3\x89thiopie',
             'fi': 'Finlande',
             'fj': 'Fidji',
             'fk': 'Malouines (\xc3\xaeles),Falkland (\xc3\xaeles)',
             'fm': 'Micron\xc3\xa9sie,\xc3\x89tats f\xc3\xa9d\xc3\xa9r\xc3\xa9s de Micron\xc3\xa9sie',
             'fo': 'F\xc3\xa9ro\xc3\xa9 (\xc3\xaeles)',
             'fr': 'France',
             'ga': 'Gabon',
             'gb': 'Grande-Bretagne,Royaume-Uni',
             'gd': 'Grenade',
             'ge': 'G\xc3\xa9orgie',
             'gf': 'Guyane fran\xc3\xa7aise',
             'gg': 'Guernesey',
             'gh': 'Ghana',
             'gi': 'Gibraltar',
             'gl': 'Groenland',
             'gm': 'Gambie',
             'gn': 'Guin\xc3\xa9e',
             'gp': 'Guadeloupe',
             'gq': 'Guin\xc3\xa9e \xc3\xa9quatoriale',
             'gr': 'Gr\xc3\xa8ce',
             'gs': 'G\xc3\xa9orgie du Sud et les \xc3\xaeles Sandwich du Sud',
             'gt': 'Guatemala',
             'gu': 'Guam',
             'gw': 'Guin\xc3\xa9e-Bissau',
             'gy': 'Guyana',
             'hk': 'Hong Kong',
             'hm': 'Heard (\xc3\xaele) et \xc3\xaeles McDonald',
             'hn': 'Honduras',
             'hr': 'Croatie',
             'ht': 'Ha\xc3\xafti',
             'hu': 'Hongrie',
             'id': 'Indon\xc3\xa9sie',
             'ie': 'Irlande',
             'ii': 'intergouvernemental',
             'il': 'Isra\xc3\xabl',
             'im': '\xc3\x8ele de Man,Man, \xc3\x8ele de',
             'in': 'Inde',
             'io': "Territoire britannique de l'Oc\xc3\xa9an indien,Chagos (\xc3\xaeles)###Oc\xc3\xa9an indien, Territoire britannique de l'\n",
             'iq': 'Irak',
             'ir': 'Iran',
             'is': 'Islande',
             'it': 'Italie',
             'je': 'Jersey',
             'jm': 'Jama\xc3\xafque',
             'jo': 'Jordanie',
             'jp': 'Japon',
             'ke': 'Kenya',
             'kg': 'Kirghizistan',
             'kh': 'Cambodge',
             'ki': 'Kiribati',
             'km': 'Comores',
             'kn': 'Saint-Kitts-et-Nevis,Saint-Christophe-et-Nevis',
             'ko': 'Kosovo',
             'kp': 'Cor\xc3\xa9e (R\xc3\xa9publique populaire d\xc3\xa9mocratique),Cor\xc3\xa9e du Nord',
             'kr': 'Cor\xc3\xa9e (R\xc3\xa9publique),Cor\xc3\xa9e du Sud',
             'kw': 'Kowe\xc3\xaft',
             'ky': 'Cayman,Ca\xc3\xafmanes, \xc3\x8eles###Ca\xc3\xafman (\xc3\xaeles)',
             'kz': 'Kazakhstan',
             'la': 'Laos',
             'lb': 'Liban',
             'lc': 'Sainte-Lucie',
             'li': 'Liechtenstein',
             'lk': 'Sri Lanka',
             'lr': 'Liberia',
             'ls': 'Lesotho',
             'lt': 'Lituanie',
             'lu': 'Luxembourg',
             'lv': 'Lettonie',
             'ly': 'Libye',
             'ma': 'Maroc',
             'mc': 'Monaco',
             'md': 'Moldavie,Moldova, R\xc3\xa9publique de',
             'me': 'Mont\xc3\xa9n\xc3\xa9gro',
             'mf': 'Saint-Martin (partie fran\xc3\xa7aise)',
             'mg': 'Madagascar',
             'mh': 'Marshall (\xc3\xaeles)',
             'mk': 'Mac\xc3\xa9doine (R\xc3\xa9publique)',
             'ml': 'Mali',
             'mm': 'Myanmar,Birmanie',
             'mn': 'Mongolie',
             'mo': 'Macao',
             'mp': 'Mariannes du Nord (\xc3\xaeles)',
             'mq': 'Martinique',
             'mr': 'Mauritanie',
             'ms': 'Montserrat',
             'mt': 'Malte',
             'mu': 'Maurice',
             'mv': 'Maldives',
             'mw': 'Malawi',
             'mx': 'Mexique',
             'my': 'Malaisie',
             'mz': 'Mozambique',
             'na': 'Namibie',
             'nc': 'Nouvelle-Cal\xc3\xa9donie',
             'ne': 'Niger',
             'nf': 'Norfolk (\xc3\xaele)',
             'ng': 'Nigeria',
             'ni': 'Nicaragua',
             'nl': 'Pays-Bas',
             'no': 'Norv\xc3\xa8ge',
             'np': 'N\xc3\xa9pal',
             'nr': 'Nauru',
             'nu': 'Niue',
             'nz': 'Nouvelle-Z\xc3\xa9lande',
             'om': 'Oman',
             'oo': 'code non adapt\xc3\xa9',
             'pa': 'Panama',
             'pe': 'P\xc3\xa9rou',
             'pf': 'Polyn\xc3\xa9sie fran\xc3\xa7aise',
             'pg': 'Papouasie-Nouvelle-Guin\xc3\xa9e',
             'ph': 'Philippines',
             'pk': 'Pakistan',
             'pl': 'Pologne',
             'pm': 'Saint-Pierre-et-Miquelon',
             'pn': 'Pitcairn',
             'pr': 'Porto Rico',
             'ps': 'Autorit\xc3\xa9 palestinienne,Palestine',
             'pt': 'Portugal',
             'pw': 'Palau,Palaos',
             'py': 'Paraguay',
             'qa': 'Qatar',
             're': 'R\xc3\xa9union',
             'ro': 'Roumanie',
             'rs': 'Serbie',
             'ru': 'Russie (F\xc3\xa9d\xc3\xa9ration),Russie',
             'rw': 'Rwanda',
             'sa': 'Arabie saoudite',
             'sb': 'Salomon (\xc3\xaeles)',
             'sc': 'Seychelles',
             'sd': 'Soudan',
             'se': 'Su\xc3\xa8de',
             'sg': 'Singapour',
             'sh': 'Sainte-H\xc3\xa9l\xc3\xa8ne,Ascension (\xc3\xaele)###Tristan da Cunha (\xc3\xaele)',
             'si': 'Slov\xc3\xa9nie',
             'sj': 'Svalbard et \xc3\xaele Jan Mayen',
             'sk': 'Slovaquie',
             'sl': 'Sierra Leone',
             'sm': 'Saint-Marin',
             'sn': 'S\xc3\xa9n\xc3\xa9gal',
             'so': 'Somalie',
             'sr': 'Suriname',
             'ss': 'Soudan du Sud,Sud Soudan',
             'st': 'Sao Tom\xc3\xa9-et-Principe',
             'su': 'URSS',
             'sv': 'El Salvador,Salvador',
             'sx': 'Saint-Martin (partie n\xc3\xa9erlandaise),Sint Maarten',
             'sy': 'Syrie',
             'sz': 'Swaziland',
             'tc': 'Turks et Ca\xc3\xafques (\xc3\xaeles)',
             'td': 'Tchad',
             'tf': 'Terres australes fran\xc3\xa7aises',
             'tg': 'Togo',
             'th': 'Tha\xc3\xaflande',
             'tj': 'Tadjikistan',
             'tk': 'Tokelau',
             'tl': 'Timor oriental',
             'tm': 'Turkm\xc3\xa9nistan',
             'tn': 'Tunisie',
             'to': 'Tonga',
             'tr': 'Turquie',
             'tt': 'Trinit\xc3\xa9-et-Tobago',
             'tv': 'Tuvalu',
             'tw': 'Ta\xc3\xafwan,Chine (R\xc3\xa9publique)',
             'tz': 'Tanzanie',
             'ua': 'Ukraine',
             'ug': 'Ouganda',
             'um': '\xc3\x8eles mineures \xc3\xa9loign\xc3\xa9es des \xc3\x89tats-Unis',
             'us': '\xc3\x89tats-Unis',
             'uy': 'Uruguay',
             'uz': 'Ouzb\xc3\xa9kistan',
             'va': 'Vatican,Saint-Si\xc3\xa8ge',
             'vc': 'Saint-Vincent-et-les Grenadines',
             've': 'Venezuela',
             'vg': '\xc3\x8eles Vierges britanniques,Vierges (\xc3\xaeles) britanniques',
             'vi': '\xc3\x8eles Vierges am\xc3\xa9ricaines,Vierges (\xc3\xaeles) am\xc3\xa9ricaines',
             'vn': 'Viet Nam',
             'vu': 'Vanuatu',
             'wf': 'Wallis et Futuna (\xc3\xaeles)',
             'ws': 'Samoa,Samoa occidentales',
             'xc': 'Tch\xc3\xa9coslovaquie',
             'xd': 'Allemagne avant 1945',
             'xe': 'Europe,Union europ\xc3\xa9enne',
             'xk': 'Cor\xc3\xa9e avant 1948',
             'xn': 'Pays-Bas avant 1830,Belgique avant 1830',
             'xx': 'inconnu',
             'yd': 'Y\xc3\xa9men (R\xc3\xa9publique d\xc3\xa9mocratique populaire),Sud Y\xc3\xa9men',
             'ye': 'Y\xc3\xa9men',
             'yt': 'Mayotte',
             'yu': 'Yougoslavie',
             'yy': "ne s'applique pas\n",
             'za': 'Afrique du Sud',
             'zm': 'Zambie',
             'zw': 'Zimbabwe',
             'zz': 'multiple\n'}


# REGIONS TO COUNTRIES MAPPING
REGIONS_TO_COUNTRIES = {u'Abruzzes': u'Italie',
                        u'Acha\xefe': u'Gr\xe8ce',
                        u'Acre': u'Br\xe9sil',
                        u'Afghanistan': u'Afghanistan',
                        u'Afrique du Sud': u'Afrique du Sud',
                        u'Aguascalientes': u'Mexique',
                        u'Ain': u'France',
                        u'Aisne': u'France',
                        u'Alabama': u'\xc9tats-Unis',
                        u'Alagoas': u'Br\xe9sil',
                        u'Aland (\xeeles)': u'Aland (\xeeles)',
                        u'Alaska': u'\xc9tats-Unis',
                        u'Albanie': u'Albanie',
                        u'Alberta': u'Canada',
                        u'Alg\xe9rie': u'Alg\xe9rie',
                        u'Allemagne': u'Allemagne',
                        u'Allemagne (R\xe9publique d\xe9mocratique)': u'Allemagne (R\xe9publique d\xe9mocratique)',
                        u'Allemagne avant 1945': u'Allemagne avant 1945',
                        u'Allier': u'France',
                        u'Alpes-Maritimes': u'France',
                        u'Alpes-de-Haute-Provence': u'France',
                        u'Alsace': u'France',
                        u'Amapa': u'Br\xe9sil',
                        u'Amazonas': u'Br\xe9sil',
                        u'Andalousie': u'Espagne',
                        u'Andorre': u'Andorre',
                        u'Angola': u'Angola',
                        u'Anguilla': u'Anguilla',
                        u'Antarctique': u'Antarctique',
                        u'Antigua-et-Barbuda': u'Antigua-et-Barbuda',
                        u'Antilles n\xe9erlandaises': u'Antilles n\xe9erlandaises',
                        u'Anvers': u'Belgique',
                        u'Appenzell-Rhodes-Ext\xe9rieures': u'Suisse',
                        u'Appenzell-Rhodes-Int\xe9rieures': u'Suisse',
                        u'Aquitaine': u'France',
                        u'Arabie saoudite': u'Arabie saoudite',
                        u'Aragon': u'Espagne',
                        u'Arcadie': u'Gr\xe8ce',
                        u'Ardennes': u'France',
                        u'Ard\xe8che': u'France',
                        u'Argentine': u'Argentine',
                        u'Argolide': u'Gr\xe8ce',
                        u'Argovie': u'Suisse',
                        u'Arizona': u'\xc9tats-Unis',
                        u'Ari\xe8ge': u'France',
                        u'Arkansas': u'\xc9tats-Unis',
                        u'Arm\xe9nie': u'Arm\xe9nie',
                        u'Aruba': u'Aruba',
                        u'Asturies': u'Espagne',
                        u'Ath\xe8nes et agglom\xe9ration': u'Gr\xe8ce',
                        u'Attique': u'Gr\xe8ce',
                        u'Aube': u'France',
                        u'Aude': u'France',
                        u'Australie': u'Australie',
                        u'Australie-M\xe9ridionale': u'Australie',
                        u'Australie-Occidentale': u'Australie',
                        u'Autorit\xe9 palestinienne': u'Autorit\xe9 palestinienne',
                        u'Autriche': u'Autriche',
                        u'Auvergne': u'France',
                        u'Aveyron': u'France',
                        u'Azerba\xefdjan': u'Azerba\xefdjan',
                        u'Bade-Wurtemberg': u'Allemagne',
                        u'Bahamas': u'Bahamas',
                        u'Bahia': u'Br\xe9sil',
                        u'Bahre\xefn': u'Bahre\xefn',
                        u'Baja California Norte': u'Mexique',
                        u'Baja California Sur': u'Mexique',
                        u'Bangladesh': u'Bangladesh',
                        u'Barbade': u'Barbade',
                        u'Bas-Rhin': u'France',
                        u'Basilicate': u'Italie',
                        u'Basse-Autriche': u'Autriche',
                        u'Basse-Normandie': u'France',
                        u'Basse-Saxe': u'Allemagne',
                        u'Bavi\xe8re': u'Allemagne',
                        u'Belgique': u'Belgique',
                        u'Belize': u'Belize',
                        u'Berlin': u'Allemagne',
                        u'Bermudes': u'Bermudes',
                        u'Berne': u'Suisse',
                        u'Bhoutan': u'Bhoutan',
                        u'Bi\xe9lorussie': u'Bi\xe9lorussie',
                        u'Bolivie': u'Bolivie',
                        u'Bonaire, Saint-Eustache et Saba': u'Bonaire, Saint-Eustache et Saba',
                        u'Bosnie-Herz\xe9govine': u'Bosnie-Herz\xe9govine',
                        u'Botswana': u'Botswana',
                        u'Bouches-du-Rh\xf4ne': u'France',
                        u'Bourgogne': u'France',
                        u'Bouvet (\xeele)': u'Bouvet (\xeele)',
                        u'Brabant': u'Belgique',
                        u'Brabant flamand': u'Belgique',
                        u'Brabant wallon': u'Belgique',
                        u'Brabant-Septentrional': u'Pays-Bas',
                        u'Brandebourg': u'Allemagne',
                        u'Bretagne': u'France',
                        u'Brun\xe9i': u'Brun\xe9i',
                        u'Bruxelles': u'Belgique',
                        u'Br\xe9sil': u'Br\xe9sil',
                        u'Br\xeame': u'Allemagne',
                        u'Buenos Aires': u'Argentine',
                        u'Bulgarie': u'Bulgarie',
                        u'Burgenland': u'Autriche',
                        u'Burkina': u'Burkina',
                        u'Burundi': u'Burundi',
                        u'B\xe2le-Campagne': u'Suisse',
                        u'B\xe2le-Ville': u'Suisse',
                        u'B\xe9nin': u'B\xe9nin',
                        u'B\xe9otie': u'Gr\xe8ce',
                        u'Calabre': u'Italie',
                        u'Californie': u'\xc9tats-Unis',
                        u'Calvados': u'France',
                        u'Cambodge': u'Cambodge',
                        u'Cameroun': u'Cameroun',
                        u'Campanie': u'Italie',
                        u'Campeche': u'Mexique',
                        u'Canada': u'Canada',
                        u'Canaries': u'Espagne',
                        u'Cantabrie': u'Espagne',
                        u'Cantal': u'France',
                        u'Cap-Vert': u'Cap-Vert',
                        u'Capitale f\xe9d\xe9rale': u'Argentine',
                        u'Carinthie': u'Autriche',
                        u'Caroline du Nord': u'\xc9tats-Unis',
                        u'Caroline du Sud': u'\xc9tats-Unis',
                        u'Castille et L\xe9on': u'Espagne',
                        u'Castille-la Manche': u'Espagne',
                        u'Catalogne': u'Espagne',
                        u'Catamarca': u'Argentine',
                        u'Cayman': u'Cayman',
                        u'Cear\xe1': u'Br\xe9sil',
                        u'Centrafrique': u'Centrafrique',
                        u'Centre': u'France',
                        u'Ceuta': u'Espagne',
                        u'Chaco': u'Argentine',
                        u'Chalcidique': u'Gr\xe8ce',
                        u'Champagne-Ardenne': u'France',
                        u'Charente': u'France',
                        u'Charente-Maritime': u'France',
                        u'Cher': u'France',
                        u'Chiapas': u'Mexique',
                        u'Chihuahua': u'Mexique',
                        u'Chili': u'Chili',
                        u'Chine': u'Chine',
                        u'Christmas (\xeele)': u'Christmas (\xeele)',
                        u'Chubut': u'Argentine',
                        u'Chypre': u'Chypre',
                        u'Ch\xedos': u'Gr\xe8ce',
                        u'Coahuila': u'Mexique',
                        u'Cocos (\xeeles)': u'Cocos (\xeeles)',
                        u'Colima': u'Mexique',
                        u'Colombie': u'Colombie',
                        u'Colombie britannique': u'Canada',
                        u'Colorado': u'\xc9tats-Unis',
                        u'Communaut\xe9 de Madrid': u'Espagne',
                        u'Communaut\xe9 de Valence': u'Espagne',
                        u'Comores': u'Comores',
                        u'Congo': u'Congo',
                        u'Congo (R\xe9publique d\xe9mocratique)': u'Congo (R\xe9publique d\xe9mocratique)',
                        u'Connecticut': u'\xc9tats-Unis',
                        u'Cook (\xeeles)': u'Cook (\xeeles)',
                        u'Corfou': u'Gr\xe8ce',
                        u'Corinthie': u'Gr\xe8ce',
                        u'Corrientes': u'Argentine',
                        u'Corr\xe8ze': u'France',
                        u'Corse': u'France',
                        u'Corse-du-Sud': u'France',
                        u'Cor\xe9e (R\xe9publique populaire d\xe9mocratique)': u'Cor\xe9e (R\xe9publique populaire d\xe9mocratique)',
                        u'Cor\xe9e (R\xe9publique)': u'Cor\xe9e (R\xe9publique)',
                        u'Cor\xe9e avant 1948': u'Cor\xe9e avant 1948',
                        u'Costa Rica': u'Costa Rica',
                        u'Creuse': u'France',
                        u'Croatie': u'Croatie',
                        u'Cr\xe8te': u'Gr\xe8ce',
                        u'Cuba': u'Cuba',
                        u'Cura\xe7ao': u'Cura\xe7ao',
                        u'Cyclades': u'Gr\xe8ce',
                        u'C\xe9phalonie': u'Gr\xe8ce',
                        u'C\xf3rdoba': u'Argentine',
                        u"C\xf4te d'Ivoire": u"C\xf4te d'Ivoire",
                        u"C\xf4te-d'Or": u'France',
                        u"C\xf4tes-d'Armor": u'France',
                        u'Dakota du Nord': u'\xc9tats-Unis',
                        u'Dakota du Sud': u'\xc9tats-Unis',
                        u'Danemark': u'Danemark',
                        u'Delaware': u'\xc9tats-Unis',
                        u'Deux-S\xe8vres': u'France',
                        u'District de Columbia': u'\xc9tats-Unis',
                        u'District f\xe9d\xe9ral': u'Br\xe9sil',
                        u'Djibouti': u'Djibouti',
                        u'Dod\xe9can\xe8se': u'Gr\xe8ce',
                        u'Dominique': u'Dominique',
                        u'Dordogne': u'France',
                        u'Doubs': u'France',
                        u'Drenthe': u'Pays-Bas',
                        u'Dr\xe1ma': u'Gr\xe8ce',
                        u'Dr\xf4me': u'France',
                        u'Durango': u'Mexique',
                        u'D\xe9pendance de Ross (Nouvelle-Z\xe9lande)': u'Antarctique',
                        u'El Salvador': u'El Salvador',
                        u'Entre-Rios': u'Argentine',
                        u'Espagne': u'Espagne',
                        u'Espirito Santo': u'Br\xe9sil',
                        u'Essonne': u'France',
                        u'Estonie': u'Estonie',
                        u'Estr\xe9madure': u'Espagne',
                        u'Eub\xe9e': u'Gr\xe8ce',
                        u'Eure': u'France',
                        u'Eure-et-Loir': u'France',
                        u'Eurytanie': u'Gr\xe8ce',
                        u'Fidji': u'Fidji',
                        u'Finist\xe8re': u'France',
                        u'Finlande': u'Finlande',
                        u'Flandre occidentale': u'Belgique',
                        u'Flandre orientale': u'Belgique',
                        u'Floride': u'\xc9tats-Unis',
                        u'Fl\xf3rina': u'Gr\xe8ce',
                        u'Formosa': u'Argentine',
                        u'France': u'France',
                        u'Franche-Comt\xe9': u'France',
                        u'Fribourg': u'Suisse',
                        u'Frioul-V\xe9n\xe9tie-Julienne': u'Italie',
                        u'Frise': u'Pays-Bas',
                        u'F\xe9ro\xe9 (\xeeles)': u'F\xe9ro\xe9 (\xeeles)',
                        u'Gabon': u'Gabon',
                        u'Galice': u'Espagne',
                        u'Gambie': u'Gambie',
                        u'Gard': u'France',
                        u'Gen\xe8ve': u'Suisse',
                        u'Gers': u'France',
                        u'Ghana': u'Ghana',
                        u'Gibraltar': u'Gibraltar',
                        u'Gironde': u'France',
                        u'Glaris': u'Suisse',
                        u'Goi\xe1s': u'Br\xe9sil',
                        u'Grande-Bretagne': u'Grande-Bretagne',
                        u'Grenade': u'Grenade',
                        u'Greven\xe1': u'Gr\xe8ce',
                        u'Grisons': u'Suisse',
                        u'Groenland': u'Groenland',
                        u'Groningue': u'Pays-Bas',
                        u'Gr\xe8ce': u'Gr\xe8ce',
                        u'Gr\xe8ce centrale': u'Gr\xe8ce',
                        u'Gr\xe8ce occidentale': u'Gr\xe8ce',
                        u'Guadeloupe': u'Guadeloupe',
                        u'Guam': u'Guam',
                        u'Guanajuato': u'Mexique',
                        u'Guatemala': u'Guatemala',
                        u'Gueldre': u'Pays-Bas',
                        u'Guernesey': u'Guernesey',
                        u'Guerrero': u'Mexique',
                        u'Guin\xe9e': u'Guin\xe9e',
                        u'Guin\xe9e \xe9quatoriale': u'Guin\xe9e \xe9quatoriale',
                        u'Guin\xe9e-Bissau': u'Guin\xe9e-Bissau',
                        u'Guyana': u'Guyana',
                        u'Guyane fran\xe7aise': u'Guyane fran\xe7aise',
                        u'G\xe9orgie': u'\xc9tats-Unis',
                        u'G\xe9orgie du Sud et les \xeeles Sandwich du Sud': u'G\xe9orgie du Sud et les \xeeles Sandwich du Sud',
                        u'Hainaut': u'Belgique',
                        u'Hambourg': u'Allemagne',
                        u'Haut-Rhin': u'France',
                        u'Haute-Autriche': u'Autriche',
                        u'Haute-Corse': u'France',
                        u'Haute-Garonne': u'France',
                        u'Haute-Loire': u'France',
                        u'Haute-Marne': u'France',
                        u'Haute-Normandie': u'France',
                        u'Haute-Savoie': u'France',
                        u'Haute-Sa\xf4ne': u'France',
                        u'Haute-Vienne': u'France',
                        u'Hautes-Alpes': u'France',
                        u'Hautes-Pyr\xe9n\xe9es': u'France',
                        u'Hauts-de-Seine': u'France',
                        u'Hawaii': u'\xc9tats-Unis',
                        u'Ha\xefti': u'Ha\xefti',
                        u'Heard (\xeele) et \xeeles McDonald': u'Heard (\xeele) et \xeeles McDonald',
                        u'Hesse': u'Allemagne',
                        u'Hidalgo': u'Mexique',
                        u'Hollande-M\xe9ridionale': u'Pays-Bas',
                        u'Hollande-Septentrionale': u'Pays-Bas',
                        u'Honduras': u'Honduras',
                        u'Hong Kong': u'Hong Kong',
                        u'Hongrie': u'Hongrie',
                        u'H\xe9rault': u'France',
                        u'Idaho': u'\xc9tats-Unis',
                        u'Ille-et-Vilaine': u'France',
                        u'Illinois': u'\xc9tats-Unis',
                        u'Inde': u'Inde',
                        u'Indiana': u'\xc9tats-Unis',
                        u'Indon\xe9sie': u'Indon\xe9sie',
                        u'Indre': u'France',
                        u'Indre-et-Loire': u'France',
                        u'Iowa': u'\xc9tats-Unis',
                        u'Io\xe1nnina': u'Gr\xe8ce',
                        u'Irak': u'Irak',
                        u'Iran': u'Iran',
                        u'Irlande': u'Irlande',
                        u'Ir\xe1kleion': u'Gr\xe8ce',
                        u'Islande': u'Islande',
                        u'Isra\xebl': u'Isra\xebl',
                        u'Is\xe8re': u'France',
                        u'Italie': u'Italie',
                        u'Jalisco': u'Mexique',
                        u'Jama\xefque': u'Jama\xefque',
                        u'Japon': u'Japon',
                        u'Jersey': u'Jersey',
                        u'Jordanie': u'Jordanie',
                        u'Jujuy': u'Argentine',
                        u'Jura': u'France',
                        u'Kansas': u'\xc9tats-Unis',
                        u'Kard\xedtsa': u'Gr\xe8ce',
                        u'Kastori\xe1': u'Gr\xe8ce',
                        u'Kav\xe1la': u'Gr\xe8ce',
                        u'Kazakhstan': u'Kazakhstan',
                        u'Kentucky': u'\xc9tats-Unis',
                        u'Kenya': u'Kenya',
                        u'Kilk\xeds': u'Gr\xe8ce',
                        u'Kirghizistan': u'Kirghizistan',
                        u'Kiribati': u'Kiribati',
                        u'Kosovo': u'Kosovo',
                        u'Kowe\xeft': u'Kowe\xeft',
                        u'Koz\xe1ni': u'Gr\xe8ce',
                        u'La Can\xe9e': u'Gr\xe8ce',
                        u'Laconie': u'Gr\xe8ce',
                        u'Landes': u'France',
                        u'Languedoc-Roussillon': u'France',
                        u'Laos': u'Laos',
                        u'Las\xedthi': u'Gr\xe8ce',
                        u'Latium': u'Italie',
                        u'Le Pir\xe9e': u'Gr\xe8ce',
                        u'Lesotho': u'Lesotho',
                        u'Lettonie': u'Lettonie',
                        u'Leucade': u'Gr\xe8ce',
                        u'Liban': u'Liban',
                        u'Liberia': u'Liberia',
                        u'Libye': u'Libye',
                        u'Liechtenstein': u'Liechtenstein',
                        u'Ligurie': u'Italie',
                        u'Limbourg': u'Pays-Bas',
                        u'Limousin': u'France',
                        u'Lituanie': u'Lituanie',
                        u'Li\xe8ge': u'Belgique',
                        u'Loir-et-Cher': u'France',
                        u'Loire': u'France',
                        u'Loire-Atlantique': u'France',
                        u'Loiret': u'France',
                        u'Lombardie': u'Italie',
                        u'Lorraine': u'France',
                        u'Lot': u'France',
                        u'Lot-et-Garonne': u'France',
                        u'Louisiane': u'\xc9tats-Unis',
                        u'Loz\xe8re': u'France',
                        u'Lucerne': u'Suisse',
                        u'Luxembourg': u'Belgique',
                        u'L\xe1risa': u'Gr\xe8ce',
                        u'L\xe9svos': u'Gr\xe8ce',
                        u'Macao': u'Macao',
                        u'Mac\xe9doine (R\xe9publique)': u'Mac\xe9doine (R\xe9publique)',
                        u'Mac\xe9doine centrale': u'Gr\xe8ce',
                        u'Mac\xe9doine occidentale': u'Gr\xe8ce',
                        u'Mac\xe9doine orientale et Thrace': u'Gr\xe8ce',
                        u'Madagascar': u'Madagascar',
                        u'Magn\xe9sie': u'Gr\xe8ce',
                        u'Maine': u'\xc9tats-Unis',
                        u'Maine-et-Loire': u'France',
                        u'Malaisie': u'Malaisie',
                        u'Malawi': u'Malawi',
                        u'Maldives': u'Maldives',
                        u'Mali': u'Mali',
                        u'Malouines (\xeeles)': u'Malouines (\xeeles)',
                        u'Malte': u'Malte',
                        u'Manche': u'France',
                        u'Manitoba': u'Canada',
                        u'Maranh\xe3o': u'Br\xe9sil',
                        u'Marches': u'Italie',
                        u'Mariannes du Nord (\xeeles)': u'Mariannes du Nord (\xeeles)',
                        u'Marne': u'France',
                        u'Maroc': u'Maroc',
                        u'Marshall (\xeeles)': u'Marshall (\xeeles)',
                        u'Martinique': u'Martinique',
                        u'Maryland': u'\xc9tats-Unis',
                        u'Massachusetts': u'\xc9tats-Unis',
                        u'Mato grosso': u'Br\xe9sil',
                        u'Mato grosso do Sul': u'Br\xe9sil',
                        u'Maurice': u'Maurice',
                        u'Mauritanie': u'Mauritanie',
                        u'Mayenne': u'France',
                        u'Mayotte': u'Mayotte',
                        u'Mecklembourg-Pom\xe9ranie ant\xe9rieure': u'Allemagne',
                        u'Melilla': u'Espagne',
                        u'Mendoza': u'Argentine',
                        u'Mess\xe9nie': u'Gr\xe8ce',
                        u'Meurthe-et-Moselle': u'France',
                        u'Meuse': u'France',
                        u'Mexico': u'Mexique',
                        u'Mexique': u'Mexique',
                        u'Michigan': u'\xc9tats-Unis',
                        u'Michoac\xe1n': u'Mexique',
                        u'Micron\xe9sie': u'Micron\xe9sie',
                        u'Midi-Pyr\xe9n\xe9es': u'France',
                        u'Minas Gerais': u'Br\xe9sil',
                        u'Minnesota': u'\xc9tats-Unis',
                        u'Misiones': u'Argentine',
                        u'Mississippi': u'\xc9tats-Unis',
                        u'Missouri': u'\xc9tats-Unis',
                        u'Moldavie': u'Moldavie',
                        u'Molise': u'Italie',
                        u'Monaco': u'Monaco',
                        u'Mongolie': u'Mongolie',
                        u'Montana': u'\xc9tats-Unis',
                        u'Montserrat': u'Montserrat',
                        u'Mont\xe9n\xe9gro': u'Mont\xe9n\xe9gro',
                        u'Morbihan': u'France',
                        u'Morelos': u'Mexique',
                        u'Moselle': u'France',
                        u'Mozambique': u'Mozambique',
                        u'Murcie': u'Espagne',
                        u'Myanmar': u'Myanmar',
                        u'Namibie': u'Namibie',
                        u'Namur': u'Belgique',
                        u'Nauru': u'Nauru',
                        u'Navarre': u'Espagne',
                        u'Nayarit': u'Mexique',
                        u'Nebraska': u'\xc9tats-Unis',
                        u'Neuch\xe2tel': u'Suisse',
                        u'Neuqu\xe9n': u'Argentine',
                        u'Nevada': u'\xc9tats-Unis',
                        u'New Hampshire': u'\xc9tats-Unis',
                        u'New Jersey': u'\xc9tats-Unis',
                        u'New York': u'\xc9tats-Unis',
                        u'Nicaragua': u'Nicaragua',
                        u'Nidwald': u'Suisse',
                        u'Niger': u'Niger',
                        u'Nigeria': u'Nigeria',
                        u'Niue': u'Niue',
                        u'Ni\xe8vre': u'France',
                        u'Nord': u'France',
                        u'Nord-Pas-de-Calais': u'France',
                        u'Norfolk (\xeele)': u'Norfolk (\xeele)',
                        u'Norv\xe8ge': u'Norv\xe8ge',
                        u'Nouveau Mexique': u'\xc9tats-Unis',
                        u'Nouveau-Brunswick': u'Canada',
                        u'Nouvelle-Cal\xe9donie': u'Nouvelle-Cal\xe9donie',
                        u'Nouvelle-Galles-du-Sud': u'Australie',
                        u'Nouvelle-Z\xe9lande': u'Nouvelle-Z\xe9lande',
                        u'Nouvelle-\xc9cosse': u'Canada',
                        u'Nuevo Le\xf3n': u'Mexique',
                        u'N\xe9pal': u'N\xe9pal',
                        u'Oaxaca': u'Mexique',
                        u'Obwald': u'Suisse',
                        u'Ohio': u'\xc9tats-Unis',
                        u'Oise': u'France',
                        u'Oklahoma': u'\xc9tats-Unis',
                        u'Oman': u'Oman',
                        u'Ombrie': u'Italie',
                        u'Ontario': u'Canada',
                        u'Oregon': u'\xc9tats-Unis',
                        u'Orne': u'France',
                        u'Ouganda': u'Ouganda',
                        u'Ouzb\xe9kistan': u'Ouzb\xe9kistan',
                        u'Overijssell': u'Pays-Bas',
                        u'Pakistan': u'Pakistan',
                        u'Palau': u'Palau',
                        u'Pampa': u'Argentine',
                        u'Panama': u'Panama',
                        u'Papouasie-Nouvelle-Guin\xe9e': u'Papouasie-Nouvelle-Guin\xe9e',
                        u'Paraguay': u'Paraguay',
                        u'Paraiba': u'Br\xe9sil',
                        u'Param\xe1': u'Br\xe9sil',
                        u'Paris': u'France',
                        u'Par\xe1': u'Br\xe9sil',
                        u'Pas-de-Calais': u'France',
                        u'Pays Basque': u'Espagne',
                        u'Pays-Bas': u'Pays-Bas',
                        u'Pays-Bas avant 1830': u'Pays-Bas avant 1830',
                        u'Pays-de-la-Loire': u'France',
                        u'Pennsylvanie': u'\xc9tats-Unis',
                        u'Pernambouc': u'Br\xe9sil',
                        u'Philippines': u'Philippines',
                        u'Phocide': u'Gr\xe8ce',
                        u'Phtiotide': u'Gr\xe8ce',
                        u'Piau\xed': u'Br\xe9sil',
                        u'Picardie': u'France',
                        u'Pitcairn': u'Pitcairn',
                        u'Pi\xe9mont': u'Italie',
                        u'Pi\xe9rie': u'Gr\xe8ce',
                        u'Poitou-Charentes': u'France',
                        u'Pologne': u'Pologne',
                        u'Polyn\xe9sie fran\xe7aise': u'Polyn\xe9sie fran\xe7aise',
                        u'Porto Rico': u'Porto Rico',
                        u'Portugal': u'Portugal',
                        u'Pouilles': u'Italie',
                        u"Provence-Alpes-C\xf4te d'Azur": u'France',
                        u'Pr\xe9veza': u'Gr\xe8ce',
                        u'Puebla': u'Mexique',
                        u'Puy-de-D\xf4me': u'France',
                        u'Pyr\xe9n\xe9es-Atlantiques': u'France',
                        u'Pyr\xe9n\xe9es-Orientales': u'France',
                        u'P\xe9lla': u'Gr\xe8ce',
                        u'P\xe9loponn\xe8se': u'Gr\xe8ce',
                        u'P\xe9rou': u'P\xe9rou',
                        u'Qatar': u'Qatar',
                        u'Queensland': u'Australie',
                        u'Quer\xe9taro': u'Mexique',
                        u'Quintana Roo': u'Mexique',
                        u'Qu\xe9bec': u'Canada',
                        u'Rhode Island': u'\xc9tats-Unis',
                        u'Rhodope': u'Gr\xe8ce',
                        u'Rh\xe9nanie-Palatinat': u'Allemagne',
                        u'Rh\xe9nanie-du-Nord-Westphalie': u'Allemagne',
                        u'Rh\xf4ne': u'France',
                        u'Rh\xf4ne-Alpes': u'France',
                        u'Rio Grande do Norte': u'Br\xe9sil',
                        u'Rio Grande do Sul': u'Br\xe9sil',
                        u'Rio Negro': u'Argentine',
                        u'Rio de Janeiro': u'Br\xe9sil',
                        u'Rioja': u'Argentine',
                        u'Rond\xf4nia': u'Br\xe9sil',
                        u'Roraima': u'Br\xe9sil',
                        u'Roumanie': u'Roumanie',
                        u'Royaume-Uni': u'Grande-Bretagne',
                        u'Russie (F\xe9d\xe9ration)': u'Russie (F\xe9d\xe9ration)',
                        u'Rwanda': u'Rwanda',
                        u'R\xc3\xa9publique Tch\xc3\xa8que': u'R\xc3\xa9publique tch\xc3\xa8que',
                        u'R\xe9publique dominicaine': u'R\xe9publique dominicaine',
                        u'R\xe9publique tch\xe8que': u'R\xe9publique tch\xe8que',
                        u'R\xe9thymnon': u'Gr\xe8ce',
                        u'R\xe9union': u'R\xe9union',
                        u'Sahara occidental': u'Sahara occidental',
                        u'Saint-Barth\xe9lemy': u'Saint-Barth\xe9lemy',
                        u'Saint-Gall': u'Suisse',
                        u'Saint-Kitts-et-Nevis': u'Saint-Kitts-et-Nevis',
                        u'Saint-Marin': u'Saint-Marin',
                        u'Saint-Martin (partie fran\xe7aise)': u'Saint-Martin (partie fran\xe7aise)',
                        u'Saint-Martin (partie n\xe9erlandaise)': u'Saint-Martin (partie n\xe9erlandaise)',
                        u'Saint-Pierre-et-Miquelon': u'Saint-Pierre-et-Miquelon',
                        u'Saint-Vincent-et-les Grenadines': u'Saint-Vincent-et-les Grenadines',
                        u'Sainte-H\xe9l\xe8ne': u'Sainte-H\xe9l\xe8ne',
                        u'Sainte-Lucie': u'Sainte-Lucie',
                        u'Salomon (\xeeles)': u'Salomon (\xeeles)',
                        u'Salta': u'Argentine',
                        u'Salzbourg': u'Autriche',
                        u'Samoa': u'Samoa',
                        u'Samoa am\xe9ricaines': u'Samoa am\xe9ricaines',
                        u'San Juan': u'Argentine',
                        u'San Luis': u'Argentine',
                        u'San Luis Potos\xed': u'Mexique',
                        u'Santa Catarina': u'Br\xe9sil',
                        u'Santa Cruz': u'Argentine',
                        u'Santa Fe': u'Argentine',
                        u'Santiago del Estero': u'Argentine',
                        u'Sao Tom\xe9-et-Principe': u'Sao Tom\xe9-et-Principe',
                        u'Sardaigne': u'Italie',
                        u'Sarre': u'Allemagne',
                        u'Sarthe': u'France',
                        u'Saskatchewan': u'Canada',
                        u'Savoie': u'France',
                        u'Saxe': u'Allemagne',
                        u'Saxe-Anhalt': u'Allemagne',
                        u'Sa\xf4ne-et-Loire': u'France',
                        u'Schaffhouse': u'Suisse',
                        u'Schleswig-Holstein': u'Allemagne',
                        u'Schwyz': u'Suisse',
                        u'Seine-Maritime': u'France',
                        u'Seine-Saint-Denis': u'France',
                        u'Seine-et-Marne': u'France',
                        u'Serbie': u'Serbie',
                        u'Serbie-et-Mont\xe9n\xe9gro': u'Serbie-et-Mont\xe9n\xe9gro',
                        u'Sergipe': u'Br\xe9sil',
                        u'Seychelles': u'Seychelles',
                        u'Sicile': u'Italie',
                        u'Sierra Leone': u'Sierra Leone',
                        u'Sinaloa': u'Mexique',
                        u'Singapour': u'Singapour',
                        u'Slovaquie': u'Slovaquie',
                        u'Slov\xe9nie': u'Slov\xe9nie',
                        u'Soleure': u'Suisse',
                        u'Somalie': u'Somalie',
                        u'Somme': u'France',
                        u'Sonora': u'Mexique',
                        u'Soudan': u'Soudan',
                        u'Soudan du Sud': u'Soudan du Sud',
                        u'Sri Lanka': u'Sri Lanka',
                        u'Styrie': u'Autriche',
                        u'Suisse': u'Suisse',
                        u'Suriname': u'Suriname',
                        u'Su\xe8de': u'Su\xe8de',
                        u'Svalbard et \xeele Jan Mayen': u'Svalbard et \xeele Jan Mayen',
                        u'Swaziland': u'Swaziland',
                        u'Syrie': u'Syrie',
                        u'S\xe1mos': u'Gr\xe8ce',
                        u'S\xe3o Paulo': u'Br\xe9sil',
                        u'S\xe9n\xe9gal': u'S\xe9n\xe9gal',
                        u'S\xe9rrai': u'Gr\xe8ce',
                        u'Tabasco': u'Mexique',
                        u'Tadjikistan': u'Tadjikistan',
                        u'Tamaulipas': u'Mexique',
                        u'Tanzanie': u'Tanzanie',
                        u'Tarn': u'France',
                        u'Tarn-et-Garonne': u'France',
                        u'Tasmanie': u'Australie',
                        u'Ta\xefwan': u'Ta\xefwan',
                        u'Tchad': u'Tchad',
                        u'Tch\xe9coslovaquie': u'Tch\xe9coslovaquie',
                        u'Tennessee': u'\xc9tats-Unis',
                        u'Terre de Feu': u'Argentine',
                        u'Terre de la Reine-Maud (Norv\xe8ge)': u'Antarctique',
                        u'Terre-Neuve': u'Canada',
                        u'Terres australes et antarctiques fran\xe7aises': u'Antarctique',
                        u'Terres australes fran\xe7aises': u'Terres australes fran\xe7aises',
                        u'Territoire antarctique australien': u'Antarctique',
                        u'Territoire antarctique britannique': u'Antarctique',
                        u"Territoire britannique de l'Oc\xe9an indien": u"Territoire britannique de l'Oc\xe9an indien",
                        u'Territoire de la capitale australienne': u'Australie',
                        u'Territoire du Nord': u'Australie',
                        u'Territoire du Yukon': u'Canada',
                        u'Territoire-de-Belfort': u'France',
                        u'Territoires du Nord-Ouest': u'Canada',
                        u'Tessin': u'Suisse',
                        u'Texas': u'\xc9tats-Unis',
                        u'Tha\xeflande': u'Tha\xeflande',
                        u'Thesprotie': u'Gr\xe8ce',
                        u'Thessalie': u'Gr\xe8ce',
                        u'Thessalonique': u'Gr\xe8ce',
                        u'Thurgovie': u'Suisse',
                        u'Thuringe': u'Allemagne',
                        u'Timor oriental': u'Timor oriental',
                        u'Tlaxcala': u'Mexique',
                        u'Togo': u'Togo',
                        u'Tokelau': u'Tokelau',
                        u'Tonga': u'Tonga',
                        u'Toscane': u'Italie',
                        u'Trentin-Haut-Adige': u'Italie',
                        u'Trinit\xe9-et-Tobago': u'Trinit\xe9-et-Tobago',
                        u'Tr\xedkala': u'Gr\xe8ce',
                        u'Tucum\xe1n': u'Argentine',
                        u'Tunisie': u'Tunisie',
                        u'Turkm\xe9nistan': u'Turkm\xe9nistan',
                        u'Turks et Ca\xefques (\xeeles)': u'Turks et Ca\xefques (\xeeles)',
                        u'Turquie': u'Turquie',
                        u'Tuvalu': u'Tuvalu',
                        u'Tyrol': u'Autriche',
                        u'URSS': u'URSS',
                        u'US': u'\xc9tats-Unis',
                        'USA': u'\xc9tats-Unis',
                        u'Ukraine': u'Ukraine',
                        u'Uri': u'Suisse',
                        u'Uruguay': u'Uruguay',
                        u'Utah': u'\xc9tats-Unis',
                        u'Utrecht': u'Pays-Bas',
                        u"Val d'Aoste": u'Italie',
                        u"Val-d'Oise": u'France',
                        u'Val-de-Marne': u'France',
                        u'Valais': u'Suisse',
                        u'Vanuatu': u'Vanuatu',
                        u'Var': u'France',
                        u'Vatican': u'Vatican',
                        u'Vaucluse': u'France',
                        u'Vaud': u'Suisse',
                        u'Vend\xe9e': u'France',
                        u'Venezuela': u'Venezuela',
                        u'Veracruz': u'Mexique',
                        u'Vermont': u'\xc9tats-Unis',
                        u'Victoria': u'Australie',
                        u'Vienne': u'Autriche',
                        u'Viet Nam': u'Viet Nam',
                        u'Virginie': u'\xc9tats-Unis',
                        u'Virginie occidentale': u'\xc9tats-Unis',
                        u'Vorarlberg': u'Autriche',
                        u'Vosges': u'France',
                        u'V\xe9n\xe9tie': u'Italie',
                        u'Wallis et Futuna (\xeeles)': u'Wallis et Futuna (\xeeles)',
                        u'Washington': u'\xc9tats-Unis',
                        u'Wisconsin': u'\xc9tats-Unis',
                        u'Wyoming': u'\xc9tats-Unis',
                        u'X\xe1nthi': u'Gr\xe8ce',
                        u'Yonne': u'France',
                        u'Yougoslavie': u'Yougoslavie',
                        u'Yucat\xe1n': u'Mexique',
                        u'Yvelines': u'France',
                        u'Y\xe9men': u'Y\xe9men',
                        u'Y\xe9men (R\xe9publique d\xe9mocratique populaire)': u'Y\xe9men (R\xe9publique d\xe9mocratique populaire)',
                        u'Zacatecas': u'Mexique',
                        u'Zambie': u'Zambie',
                        u'Zimbabwe': u'Zimbabwe',
                        u'Zoug': u'Suisse',
                        u'Zurich': u'Suisse',
                        u'Z\xe1kynthos': u'Gr\xe8ce',
                        u'Z\xe9lande': u'Pays-Bas',
                        u'aire g\xe9ographique ancienne': u'aire g\xe9ographique ancienne',
                        u'code non adapt\xe9': u'code non adapt\xe9',
                        u'inconnu': u'inconnu',
                        u'intergouvernemental': u'intergouvernemental',
                        u'multiple': u'multiple',
                        u"ne s'applique pas": u"ne s'applique pas",
                        u'non renseign\xe9': u'non renseign\xe9',
                        u'\xc1rta': u'Gr\xe8ce',
                        u'\xc9gypte': u'\xc9gypte',
                        u'\xc9lide': u'Gr\xe8ce',
                        u'\xc9mathie': u'Gr\xe8ce',
                        u'\xc9milie-Romagne': u'Italie',
                        u'\xc9mirats arabes unis': u'\xc9mirats arabes unis',
                        u'\xc9pire': u'Gr\xe8ce',
                        u'\xc9quateur': u'\xc9quateur',
                        u'\xc9rythr\xe9e': u'\xc9rythr\xe9e',
                        u'\xc9tats-Unis': u'\xc9tats-Unis',
                        u'\xc9thiopie': u'\xc9thiopie',
                        u'\xc9tolie-et-Acarnanie': u'Gr\xe8ce',
                        u'\xc9vros': u'Gr\xe8ce',
                        u'\xcele Pierre 1er (Norv\xe8ge)': u'Antarctique',
                        u'\xcele de Man': u'\xcele de Man',
                        u'\xcele du Prince-\xc9douard': u'Canada',
                        u'\xcele-de-France': u'France',
                        u'\xceles Bal\xe9ares': u'Espagne',
                        u'\xceles Ioniennes': u'Gr\xe8ce',
                        u'\xceles Vierges am\xe9ricaines': u'\xceles Vierges am\xe9ricaines',
                        u'\xceles Vierges britanniques': u'\xceles Vierges britanniques',
                        u'\xceles de la Mer \xc9g\xe9e m\xe9ridionale': u'Gr\xe8ce',
                        u'\xceles de la Mer \xc9g\xe9e septentrionale': u'Gr\xe8ce',
                        u'\xceles mineures \xe9loign\xe9es des \xc9tats-Unis': u'\xceles mineures \xe9loign\xe9es des \xc9tats-Unis'
                        }
