"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const k3s = require("./");
const core_1 = require("@aws-cdk/core");
// import * as ec2 from '@aws-cdk/aws-ec2';
class IntegTesting {
    constructor() {
        const app = new core_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new core_1.Stack(app, 'testing-stack', { env });
        // const vpc = k3s.VpcProvider.getOrCreate(stack);
        const cluster = new k3s.Cluster(stack, 'Cluster');
        //    const cluster = new k3s.Cluster(stack, 'Cluster', {
        //      vpc,
        //      spotWorkerNodes: true,
        //      workerMinCapacity: 3,
        //      workerInstanceType: new ec2.InstanceType('m6g.medium'),
        //      controlPlaneInstanceType: new ec2.InstanceType('m6g.medium'),
        //    })
        new core_1.CfnOutput(stack, 'EndpointURI', { value: cluster.endpointUri });
        this.stack = [stack];
    }
    ;
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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