"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BalancerEntry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_elasticloadbalancingv2_1 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
const aws_route53_1 = require("aws-cdk-lib/aws-route53");
const aws_route53_targets_1 = require("aws-cdk-lib/aws-route53-targets");
class BalancerEntry extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const listeners = this.getLoadBalancerListener(props.lbArn, props.sslEnabled, props.appName);
        if (props.sslEnabled) {
            new aws_elasticloadbalancingv2_1.CfnListenerRule(this, props.appName + '-https-rule', {
                listenerArn: listeners[0],
                actions: [
                    {
                        type: 'forward',
                        targetGroupArn: props.targetGroupArn,
                    },
                ],
                conditions: [
                    {
                        field: 'host-header',
                        hostHeaderConfig: {
                            values: [props.hostHeader],
                        },
                    },
                ],
                priority: Math.floor(Math.random() * (1000 - 200 + 1)) + 200,
            });
        }
        else {
            new aws_elasticloadbalancingv2_1.CfnListenerRule(this, props.appName + '-http-rule', {
                listenerArn: listeners[0],
                actions: [
                    {
                        type: 'forward',
                        targetGroupArn: props.targetGroupArn,
                    },
                ],
                conditions: [
                    {
                        field: 'host-header',
                        hostHeaderConfig: {
                            values: [props.hostHeader],
                        },
                    },
                ],
                priority: Math.floor(Math.random() * (1000 - 200 + 1)) + 200,
            });
        }
        this.createRoute53Entry(props);
    }
    getLoadBalancerListener(loadBalancerArn, sslEnabled, appName) {
        const listeners = [];
        if (!sslEnabled) {
            listeners.push(aws_elasticloadbalancingv2_1.ApplicationListener.fromLookup(this, appName + '-listener-http', {
                loadBalancerArn: loadBalancerArn,
                listenerProtocol: aws_elasticloadbalancingv2_1.ApplicationProtocol.HTTP,
            }).listenerArn);
        }
        if (sslEnabled) {
            listeners.push(aws_elasticloadbalancingv2_1.ApplicationListener.fromLookup(this, appName + '-listener-https', {
                loadBalancerArn: loadBalancerArn,
                listenerProtocol: aws_elasticloadbalancingv2_1.ApplicationProtocol.HTTPS,
            }).listenerArn);
        }
        return listeners;
    }
    createRoute53Entry(props) {
        const lb = aws_elasticloadbalancingv2_1.ApplicationLoadBalancer.fromLookup(this, 'lb-' + props.lbArn, {
            loadBalancerArn: props.lbArn,
        });
        new aws_route53_1.ARecord(this, 'record-' + props.hostHeader.split('.')[-2], {
            target: aws_route53_1.RecordTarget.fromAlias(new aws_route53_targets_1.LoadBalancerTarget(lb)),
            zone: new aws_route53_1.HostedZone(this, props.hostHeader + '-zone', {
                zoneName: props.zoneName,
            }),
        });
    }
}
exports.BalancerEntry = BalancerEntry;
_a = JSII_RTTI_SYMBOL_1;
BalancerEntry[_a] = { fqn: "@smallcase/aws-cdk-microservice.BalancerEntry", version: "0.0.17" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmV0d29yay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9jb25zdHJ1Y3RzL25ldHdvcmsudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2Q0FBdUM7QUFDdkMsdUZBQTRJO0FBQzVJLHlEQUE0RTtBQUM1RSx5RUFBcUU7QUFZckUsTUFBYSxhQUFjLFNBQVEsc0JBQVE7SUFDekMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF3QjtRQUNoRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLE1BQU0sU0FBUyxHQUFHLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxVQUFVLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzdGLElBQUksS0FBSyxDQUFDLFVBQVUsRUFBRTtZQUNwQixJQUFJLDRDQUFlLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxPQUFPLEdBQUcsYUFBYSxFQUFFO2dCQUN2RCxXQUFXLEVBQUUsU0FBUyxDQUFDLENBQUMsQ0FBQztnQkFDekIsT0FBTyxFQUFFO29CQUNQO3dCQUNFLElBQUksRUFBRSxTQUFTO3dCQUNmLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztxQkFDckM7aUJBQ0Y7Z0JBQ0QsVUFBVSxFQUFFO29CQUNWO3dCQUNFLEtBQUssRUFBRSxhQUFhO3dCQUNwQixnQkFBZ0IsRUFBRTs0QkFDaEIsTUFBTSxFQUFFLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQzt5QkFDM0I7cUJBQ0Y7aUJBQ0Y7Z0JBQ0QsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSSxHQUFHLEdBQUcsR0FBRyxDQUFDLENBQUMsQ0FBQyxHQUFHLEdBQUc7YUFDN0QsQ0FBQyxDQUFDO1NBQ0o7YUFBTTtZQUNMLElBQUksNENBQWUsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLE9BQU8sR0FBRyxZQUFZLEVBQUU7Z0JBQ3RELFdBQVcsRUFBRSxTQUFTLENBQUMsQ0FBQyxDQUFDO2dCQUN6QixPQUFPLEVBQUU7b0JBQ1A7d0JBQ0UsSUFBSSxFQUFFLFNBQVM7d0JBQ2YsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO3FCQUNyQztpQkFDRjtnQkFDRCxVQUFVLEVBQUU7b0JBQ1Y7d0JBQ0UsS0FBSyxFQUFFLGFBQWE7d0JBQ3BCLGdCQUFnQixFQUFFOzRCQUNoQixNQUFNLEVBQUUsQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDO3lCQUMzQjtxQkFDRjtpQkFDRjtnQkFDRCxRQUFRLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJLEdBQUcsR0FBRyxHQUFHLENBQUMsQ0FBQyxDQUFDLEdBQUcsR0FBRzthQUM3RCxDQUFDLENBQUM7U0FDSjtRQUNELElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNqQyxDQUFDO0lBRU8sdUJBQXVCLENBQUMsZUFBdUIsRUFBRSxVQUFtQixFQUFFLE9BQWU7UUFDM0YsTUFBTSxTQUFTLEdBQUcsRUFBRSxDQUFDO1FBRXJCLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDZixTQUFTLENBQUMsSUFBSSxDQUFDLGdEQUFtQixDQUFDLFVBQVUsQ0FBQyxJQUFJLEVBQUUsT0FBTyxHQUFHLGdCQUFnQixFQUFFO2dCQUM5RSxlQUFlLEVBQUUsZUFBZTtnQkFDaEMsZ0JBQWdCLEVBQUUsZ0RBQW1CLENBQUMsSUFBSTthQUMzQyxDQUFDLENBQUMsV0FBVyxDQUFDLENBQUM7U0FDakI7UUFFRCxJQUFJLFVBQVUsRUFBRTtZQUNkLFNBQVMsQ0FBQyxJQUFJLENBQUMsZ0RBQW1CLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRSxPQUFPLEdBQUcsaUJBQWlCLEVBQUU7Z0JBQy9FLGVBQWUsRUFBRSxlQUFlO2dCQUNoQyxnQkFBZ0IsRUFBRSxnREFBbUIsQ0FBQyxLQUFLO2FBQzVDLENBQUMsQ0FBQyxXQUFXLENBQUMsQ0FBQztTQUNqQjtRQUNELE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7SUFFTyxrQkFBa0IsQ0FBQyxLQUF3QjtRQUNqRCxNQUFNLEVBQUUsR0FBRyxvREFBdUIsQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFO1lBQ3ZFLGVBQWUsRUFBRSxLQUFLLENBQUMsS0FBSztTQUM3QixDQUFDLENBQUM7UUFDSCxJQUFJLHFCQUFPLENBQUMsSUFBSSxFQUFFLFNBQVMsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO1lBQzdELE1BQU0sRUFBRSwwQkFBWSxDQUFDLFNBQVMsQ0FBQyxJQUFJLHdDQUFrQixDQUFDLEVBQUUsQ0FBQyxDQUFDO1lBQzFELElBQUksRUFBRSxJQUFJLHdCQUFVLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxVQUFVLEdBQUcsT0FBTyxFQUFFO2dCQUNyRCxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7YUFDekIsQ0FBQztTQUNILENBQUMsQ0FBQztJQUNMLENBQUM7O0FBM0VILHNDQTRFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFJlc291cmNlIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQXBwbGljYXRpb25MaXN0ZW5lciwgQXBwbGljYXRpb25Mb2FkQmFsYW5jZXIsIEFwcGxpY2F0aW9uUHJvdG9jb2wsIENmbkxpc3RlbmVyUnVsZSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyJztcbmltcG9ydCB7IEFSZWNvcmQsIEhvc3RlZFpvbmUsIFJlY29yZFRhcmdldCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1yb3V0ZTUzJztcbmltcG9ydCB7IExvYWRCYWxhbmNlclRhcmdldCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1yb3V0ZTUzLXRhcmdldHMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgTG9hZEJhbGFuY2VyUHJvcHMge1xuICByZWFkb25seSBhcHBOYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGhvc3RIZWFkZXI6IHN0cmluZztcbiAgcmVhZG9ubHkgdGFyZ2V0R3JvdXBBcm46IHN0cmluZztcbiAgcmVhZG9ubHkgbGJBcm46IHN0cmluZztcbiAgcmVhZG9ubHkgc3NsRW5hYmxlZDogYm9vbGVhbjtcbiAgcmVhZG9ubHkgem9uZU5hbWU6IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIEJhbGFuY2VyRW50cnkgZXh0ZW5kcyBSZXNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBMb2FkQmFsYW5jZXJQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgY29uc3QgbGlzdGVuZXJzID0gdGhpcy5nZXRMb2FkQmFsYW5jZXJMaXN0ZW5lcihwcm9wcy5sYkFybiwgcHJvcHMuc3NsRW5hYmxlZCwgcHJvcHMuYXBwTmFtZSk7XG4gICAgaWYgKHByb3BzLnNzbEVuYWJsZWQpIHtcbiAgICAgIG5ldyBDZm5MaXN0ZW5lclJ1bGUodGhpcywgcHJvcHMuYXBwTmFtZSArICctaHR0cHMtcnVsZScsIHtcbiAgICAgICAgbGlzdGVuZXJBcm46IGxpc3RlbmVyc1swXSxcbiAgICAgICAgYWN0aW9uczogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIHR5cGU6ICdmb3J3YXJkJyxcbiAgICAgICAgICAgIHRhcmdldEdyb3VwQXJuOiBwcm9wcy50YXJnZXRHcm91cEFybixcbiAgICAgICAgICB9LFxuICAgICAgICBdLFxuICAgICAgICBjb25kaXRpb25zOiBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgZmllbGQ6ICdob3N0LWhlYWRlcicsXG4gICAgICAgICAgICBob3N0SGVhZGVyQ29uZmlnOiB7XG4gICAgICAgICAgICAgIHZhbHVlczogW3Byb3BzLmhvc3RIZWFkZXJdLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9LFxuICAgICAgICBdLFxuICAgICAgICBwcmlvcml0eTogTWF0aC5mbG9vcihNYXRoLnJhbmRvbSgpICogKDEwMDAgLSAyMDAgKyAxKSkgKyAyMDAsIC8vIHRoaXMgbGluZSBpcyBhIGZsaXBwaW5nIGxlYXAgb2YgZmFpdGhcbiAgICAgIH0pO1xuICAgIH0gZWxzZSB7XG4gICAgICBuZXcgQ2ZuTGlzdGVuZXJSdWxlKHRoaXMsIHByb3BzLmFwcE5hbWUgKyAnLWh0dHAtcnVsZScsIHtcbiAgICAgICAgbGlzdGVuZXJBcm46IGxpc3RlbmVyc1swXSxcbiAgICAgICAgYWN0aW9uczogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIHR5cGU6ICdmb3J3YXJkJyxcbiAgICAgICAgICAgIHRhcmdldEdyb3VwQXJuOiBwcm9wcy50YXJnZXRHcm91cEFybixcbiAgICAgICAgICB9LFxuICAgICAgICBdLFxuICAgICAgICBjb25kaXRpb25zOiBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgZmllbGQ6ICdob3N0LWhlYWRlcicsXG4gICAgICAgICAgICBob3N0SGVhZGVyQ29uZmlnOiB7XG4gICAgICAgICAgICAgIHZhbHVlczogW3Byb3BzLmhvc3RIZWFkZXJdLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9LFxuICAgICAgICBdLFxuICAgICAgICBwcmlvcml0eTogTWF0aC5mbG9vcihNYXRoLnJhbmRvbSgpICogKDEwMDAgLSAyMDAgKyAxKSkgKyAyMDAsIC8vIHRoaXMgbGluZSBpcyBhIGZsaXBwaW5nIGxlYXAgb2YgZmFpdGhcbiAgICAgIH0pO1xuICAgIH1cbiAgICB0aGlzLmNyZWF0ZVJvdXRlNTNFbnRyeShwcm9wcyk7XG4gIH1cblxuICBwcml2YXRlIGdldExvYWRCYWxhbmNlckxpc3RlbmVyKGxvYWRCYWxhbmNlckFybjogc3RyaW5nLCBzc2xFbmFibGVkOiBib29sZWFuLCBhcHBOYW1lOiBzdHJpbmcpIHtcbiAgICBjb25zdCBsaXN0ZW5lcnMgPSBbXTtcblxuICAgIGlmICghc3NsRW5hYmxlZCkge1xuICAgICAgbGlzdGVuZXJzLnB1c2goQXBwbGljYXRpb25MaXN0ZW5lci5mcm9tTG9va3VwKHRoaXMsIGFwcE5hbWUgKyAnLWxpc3RlbmVyLWh0dHAnLCB7XG4gICAgICAgIGxvYWRCYWxhbmNlckFybjogbG9hZEJhbGFuY2VyQXJuLFxuICAgICAgICBsaXN0ZW5lclByb3RvY29sOiBBcHBsaWNhdGlvblByb3RvY29sLkhUVFAsXG4gICAgICB9KS5saXN0ZW5lckFybik7XG4gICAgfVxuXG4gICAgaWYgKHNzbEVuYWJsZWQpIHtcbiAgICAgIGxpc3RlbmVycy5wdXNoKEFwcGxpY2F0aW9uTGlzdGVuZXIuZnJvbUxvb2t1cCh0aGlzLCBhcHBOYW1lICsgJy1saXN0ZW5lci1odHRwcycsIHtcbiAgICAgICAgbG9hZEJhbGFuY2VyQXJuOiBsb2FkQmFsYW5jZXJBcm4sXG4gICAgICAgIGxpc3RlbmVyUHJvdG9jb2w6IEFwcGxpY2F0aW9uUHJvdG9jb2wuSFRUUFMsXG4gICAgICB9KS5saXN0ZW5lckFybik7XG4gICAgfVxuICAgIHJldHVybiBsaXN0ZW5lcnM7XG4gIH1cblxuICBwcml2YXRlIGNyZWF0ZVJvdXRlNTNFbnRyeShwcm9wczogTG9hZEJhbGFuY2VyUHJvcHMpIHtcbiAgICBjb25zdCBsYiA9IEFwcGxpY2F0aW9uTG9hZEJhbGFuY2VyLmZyb21Mb29rdXAodGhpcywgJ2xiLScgKyBwcm9wcy5sYkFybiwge1xuICAgICAgbG9hZEJhbGFuY2VyQXJuOiBwcm9wcy5sYkFybixcbiAgICB9KTtcbiAgICBuZXcgQVJlY29yZCh0aGlzLCAncmVjb3JkLScgKyBwcm9wcy5ob3N0SGVhZGVyLnNwbGl0KCcuJylbLTJdLCB7XG4gICAgICB0YXJnZXQ6IFJlY29yZFRhcmdldC5mcm9tQWxpYXMobmV3IExvYWRCYWxhbmNlclRhcmdldChsYikpLFxuICAgICAgem9uZTogbmV3IEhvc3RlZFpvbmUodGhpcywgcHJvcHMuaG9zdEhlYWRlciArICctem9uZScsIHtcbiAgICAgICAgem9uZU5hbWU6IHByb3BzLnpvbmVOYW1lLFxuICAgICAgfSksXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==