"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const autoScalingGroup_1 = require("./autoScalingGroup");
const deployment_1 = require("./deployment");
const network_1 = require("./network");
class MicroService extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        super(scope, id);
        this.instanceType = (_b = props === null || props === void 0 ? void 0 : props.instanceType) !== null && _b !== void 0 ? _b : 't3a.micro';
        this.appName = props.appName;
        this.asgMaxSize = (_c = props === null || props === void 0 ? void 0 : props.asgMaxSize) !== null && _c !== void 0 ? _c : '2';
        this.asgMinSize = (_d = props === null || props === void 0 ? void 0 : props.asgMinSize) !== null && _d !== void 0 ? _d : '1';
        this.env = (_e = props === null || props === void 0 ? void 0 : props.env) !== null && _e !== void 0 ? _e : 'development';
        this.instanceLabels = props === null || props === void 0 ? void 0 : props.instanceLabels;
        this.diskSize = (_f = props.diskSize) !== null && _f !== void 0 ? _f : 8;
        this.vpc = props.vpc;
        this.role = props.role;
        this.tcpRules = (_g = props.tcpRules) !== null && _g !== void 0 ? _g : [];
        this.subnets = props.subnets;
        this.sshKey = props.sshKey;
        this.diskType = props.diskType;
        this.createCodedeployApplication = (_h = props.createCodedeployApplication) !== null && _h !== void 0 ? _h : false;
        this.deploymentPolicies = (_j = props.deploymentPolicies) !== null && _j !== void 0 ? _j : [];
        this.applicationType = (_k = props.applicationType) !== null && _k !== void 0 ? _k : 'new';
        this.securityGroupProps = props.securityGroupProps;
        this.networkProps = (_l = props.networkProps) !== null && _l !== void 0 ? _l : [];
        this.targetGroupProps = [];
        this.networkProps = (_m = props.networkProps) !== null && _m !== void 0 ? _m : [];
        const resourceNamePrefix = this.env + '-' + this.appName;
        const asg = new autoScalingGroup_1.AutoScaler(this, resourceNamePrefix + '-as', {
            asgName: resourceNamePrefix + '-ASG',
            appName: resourceNamePrefix,
            networkProps: this.networkProps,
            maxSize: this.asgMaxSize,
            minSize: this.asgMinSize,
            templateProps: {
                instanceType: this.instanceType,
                detailedMonitoring: false,
                templateName: resourceNamePrefix + '-LT',
                amiImageId: props.ami,
                type: 'new',
                blockDevice: {
                    size: this.diskSize,
                    name: '/dev/sda1',
                    type: this.getDiskType((_o = this.diskType) !== null && _o !== void 0 ? _o : 'GP3'),
                },
                vpc: {
                    type: 'existing',
                    vpcName: this.vpc,
                },
                securityGroup: (_p = this.securityGroupProps) !== null && _p !== void 0 ? _p : {
                    type: 'new',
                    allowAllOutbound: true,
                    securityGroupName: resourceNamePrefix + '-SG',
                    ingressRules: this.tcpRules,
                },
                role: this.role,
                sshKey: this.sshKey,
            },
            tags: props.instanceLabels,
            subnets: this.subnets,
        });
        if (this.createCodedeployApplication) {
            const depRole = this.getDeploymentGroupRole();
            const dep = new deployment_1.Deployment(this, resourceNamePrefix + '-cd', {
                asgNames: [resourceNamePrefix + '-ASG'],
                deploymentConfigName: 'CodeDeployDefault.OneAtATime',
                roleArn: depRole.roleArn,
                applicationProps: {
                    applicationName: this.appName + '-' + this.env,
                    type: this.applicationType,
                    resourceType: 'Server',
                },
                deploymentGroupName: this.env,
                tgName: resourceNamePrefix + '-TG',
            });
            dep.node.addDependency(depRole);
            dep.node.addDependency(asg);
        }
        if (this.networkProps.length) {
            (_q = asg.loadBalancerProperties) === null || _q === void 0 ? void 0 : _q.forEach(lbProp => {
                const lbEntry = new network_1.BalancerEntry(this, lbProp.hostHeader, lbProp);
                lbEntry.node.addDependency(asg);
            });
        }
    }
    getDeploymentGroupRole() {
        var _b;
        var role = new aws_iam_1.Role(this, this.appName + '-deployment-group-role', {
            assumedBy: new aws_iam_1.ServicePrincipal('codedeploy.amazonaws.com'),
            roleName: this.appName + '-deployment-group-role',
        });
        role.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            resources: ['*'],
            actions: [
                'autoscaling:CompleteLifecycleAction',
                'autoscaling:DeleteLifecycleHook',
                'autoscaling:DescribeAutoScalingGroups',
                'autoscaling:DescribeLifecycleHooks',
                'autoscaling:PutLifecycleHook',
                'autoscaling:RecordLifecycleActionHeartbeat',
                'autoscaling:CreateAutoScalingGroup',
                'autoscaling:UpdateAutoScalingGroup',
                'autoscaling:EnableMetricsCollection',
                'autoscaling:DescribePolicies',
                'autoscaling:DescribeScheduledActions',
                'autoscaling:DescribeNotificationConfigurations',
                'autoscaling:SuspendProcesses',
                'autoscaling:ResumeProcesses',
                'autoscaling:AttachLoadBalancers',
                'autoscaling:AttachLoadBalancerTargetGroups',
                'autoscaling:PutScalingPolicy',
                'autoscaling:PutScheduledUpdateGroupAction',
                'autoscaling:PutNotificationConfiguration',
                'autoscaling:PutWarmPool',
                'autoscaling:DescribeScalingActivities',
                'autoscaling:DeleteAutoScalingGroup',
                'ec2:DescribeInstances',
                'ec2:DescribeInstanceStatus',
                'ec2:TerminateInstances',
                'tag:GetResources',
                'sns:Publish',
                'cloudwatch:DescribeAlarms',
                'cloudwatch:PutMetricAlarm',
                'elasticloadbalancing:DescribeLoadBalancers',
                'elasticloadbalancing:DescribeInstanceHealth',
                'elasticloadbalancing:RegisterInstancesWithLoadBalancer',
                'elasticloadbalancing:DeregisterInstancesFromLoadBalancer',
                'elasticloadbalancing:DescribeTargetGroups',
                'elasticloadbalancing:DescribeTargetHealth',
                'elasticloadbalancing:RegisterTargets',
                'elasticloadbalancing:DeregisterTargets',
                'ec2:CreateTags',
                'ec2:RunInstances',
                'iam:PassRole',
                ...(_b = this.deploymentPolicies) !== null && _b !== void 0 ? _b : [],
            ],
        }));
        return role;
    }
    getDiskType(type) {
        return type;
    }
}
exports.MicroService = MicroService;
_a = JSII_RTTI_SYMBOL_1;
MicroService[_a] = { fqn: "@smallcase/aws-cdk-microservice.MicroService", version: "0.0.17" };
//# sourceMappingURL=data:application/json;base64,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