import { Resource } from 'aws-cdk-lib';
import { BlockDevice, CfnAutoScalingGroup, EbsDeviceVolumeType } from 'aws-cdk-lib/aws-autoscaling';
import { InstanceProps, LaunchTemplateAttributes, VpcProps } from 'aws-cdk-lib/aws-ec2';
import { NetworkTargetGroupProps } from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { Construct } from 'constructs';
import { LoadBalancerProps } from './network';
export interface InternalVPC {
    readonly type: string;
    readonly vpcName: string;
    readonly vpcProps?: VpcProps;
}
export interface NetworkProps {
    readonly protocol: string;
    readonly port: number;
    readonly healthCheckPath: string;
    readonly sslEnabled: boolean;
    readonly host: string;
    readonly lbArn: string;
    readonly zoneName: string;
}
export interface IngressRule {
    readonly sourceSG: string;
    readonly description?: string;
    readonly port: number;
}
export interface InternalRole {
    readonly roleName?: string;
    readonly type: string;
    readonly roleArn?: string;
    readonly additionalPolicies?: any[];
}
export interface InternalSG {
    readonly type: string;
    readonly sgGroupId?: string;
    readonly ingressRules?: IngressRule[];
    readonly securityGroupName?: string;
    readonly description?: string;
    readonly allowAllOutbound?: boolean;
    readonly disableInlineRules?: boolean;
}
export interface InstanceStackProps {
    readonly asgName: string;
    readonly securityGroup?: InternalSG;
    readonly vpc?: InternalVPC;
    readonly role?: InternalRole;
    readonly instanceProps: InstanceProps;
    readonly tags?: Record<string, string>;
    readonly instanceVolumeSize?: BlockDevice;
    readonly targetGroupProps?: NetworkTargetGroupProps;
}
export interface InternalBD {
    readonly name: string;
    readonly size: number;
    readonly type: EbsDeviceVolumeType;
}
export interface InternalLaunchTemplateProps {
    readonly type: string;
    readonly templateName: string;
    readonly existingAttributes?: LaunchTemplateAttributes;
    readonly vpc: InternalVPC;
    readonly role: InternalRole;
    readonly instanceType: string;
    readonly amiImageId: string;
    readonly detailedMonitoring: boolean;
    readonly instanceVolumeSize?: BlockDevice;
    readonly securityGroup: InternalSG;
    readonly blockDevice: InternalBD;
    readonly sshKey: string;
}
export interface TargetGroupProps {
    readonly type: string;
    readonly port?: number;
    readonly name?: string;
    readonly protocol?: string;
    readonly timeout?: number;
    readonly healthPath?: string;
    readonly thresholdCount?: number;
    readonly tgArn?: string;
}
export interface AutoScalerProps {
    readonly asgName: string;
    readonly templateProps: InternalLaunchTemplateProps;
    readonly maxSize: string;
    readonly minSize: string;
    readonly tags?: CfnAutoScalingGroup.TagPropertyProperty[];
    readonly tgProps?: TargetGroupProps;
    readonly subnets: string[];
    readonly networkProps: NetworkProps[];
    readonly appName: string;
}
export declare class AutoScaler extends Resource {
    readonly loadBalancerProperties?: LoadBalancerProps[];
    constructor(scope: Construct, id: string, props: AutoScalerProps);
    private getVPC;
    private getRole;
    private getSG;
    private getBD;
    private getLT;
    private getTG;
    private getZones;
}
