"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Subscription = exports.SubscriptionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const mns_generated_1 = require("./mns.generated");
Object.defineProperty(exports, "SubscriptionProperty", { enumerable: true, get: function () { return mns_generated_1.RosSubscription; } });
/**
 * A ROS resource type:  `ALIYUN::MNS::Subscription`
 */
class Subscription extends ros.Resource {
    /**
     * Create a new `ALIYUN::MNS::Subscription`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSubscription = new mns_generated_1.RosSubscription(this, id, {
            endpoint: props.endpoint,
            notifyStrategy: props.notifyStrategy === undefined || props.notifyStrategy === null ? 'BACKOFF_RETRY' : props.notifyStrategy,
            notifyContentFormat: props.notifyContentFormat === undefined || props.notifyContentFormat === null ? 'XML' : props.notifyContentFormat,
            filterTag: props.filterTag,
            subscriptionName: props.subscriptionName,
            topicName: props.topicName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSubscription;
        this.attrSubscriptionName = rosSubscription.attrSubscriptionName;
        this.attrSubscriptionUrl = rosSubscription.attrSubscriptionUrl;
        this.attrTopicName = rosSubscription.attrTopicName;
    }
}
exports.Subscription = Subscription;
//# sourceMappingURL=data:application/json;base64,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