"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core");
const index_1 = require("./resources/eks/helm-charts/kong/index");
class KongEks extends constructs_1.Construct {
    // public endpoints: DnsProps;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        // this.endpoints = {
        //   adminDns: `admin.${props.hostedZoneName}:443`,
        //   clusterDns: `cluster.${props.hostedZoneName}:443`,
        //   telemetryDns: `telemetry.${props.hostedZoneName}:443`,
        //   managerDns: `manager.${props.hostedZoneName}:443`,
        // };
        const control_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'CPSecretsKey', {
            enableKeyRotation: true,
        });
        this.controlPlane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps.eksClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
        });
        const cp_nodegroup = this.controlPlane.addNodegroupCapacity('CpASG', props.controlPlaneNodeProps);
        cp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: this.controlPlane,
        //   nodegroup: cp_nodegroup,
        // });
        new kong_core.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        const kong_rds_instance = new kong_core.RdsStack(this, 'KongRds', {
            ...props.rdsProps,
            vpc: this.controlPlane.vpc,
        });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: 'kube-system',
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: this.controlPlane,
        });
        new kong_core.ExternalDns(kong_pre_requisites_nested_stack, 'ExtDns', {
            cluster: this.controlPlane,
            hostedZoneName: props.dnsProps.hostedZoneName,
        });
        const aws_acm_pca = new kong_core.AcmPca(kong_pre_requisites_nested_stack, 'KongCpCa', {
            hostedZoneName: props.dnsProps.hostedZoneName,
            vpc: this.controlPlane.vpc,
        });
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'KongCpCertManager', {
            cluster: this.controlPlane,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            privateCaArn: aws_acm_pca.privateCaArn,
        });
        this.privateCaArn = aws_acm_pca.privateCaArn;
        const kong_control_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongCpNestedStack');
        new index_1.KongControlPlaneEKS(kong_control_plane_nested_stack, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            // nodegroup: cp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_CP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            // commonname: 'www.dummy.com',
            // hostedZoneName: props.dnsProps.hostedZoneName,
            HelmOptions: props.controlPlaneClusterProps.kongHelmOptions,
            endpoints: props.dnsProps,
        });
        kong_control_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack, kong_rds_instance);
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryNestedStack');
        const telemetry_stack = new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            createPrometheusWorkspace: props.controlPlaneClusterProps.kongTelemetryOptions.createPrometheusWorkspace,
            cluster: this.controlPlane,
            namespace: kong_core.Namespace.TELEMETRY,
        });
        this.prometheusEndpoint = telemetry_stack.prometheusEndpoint;
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "3.0.0-dev.10" };
//# sourceMappingURL=data:application/json;base64,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